/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.execapp.AzkabanExecutorServer;
import azkaban.executor.ConnectorParams;
import azkaban.utils.JSONUtils;
import azkaban.webapp.servlet.HttpRequestUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JMXHttpServlet
extends HttpServlet
implements ConnectorParams {
    private static final long serialVersionUID = -3085603824826446270L;
    private static final Logger logger = Logger.getLogger(JMXHttpServlet.class);
    private AzkabanExecutorServer server;

    public void init(ServletConfig config) throws ServletException {
        this.server = (AzkabanExecutorServer)config.getServletContext().getAttribute("azkaban_app");
    }

    public boolean hasParam(HttpServletRequest request, String param) {
        return HttpRequestUtils.hasParam(request, param);
    }

    public String getParam(HttpServletRequest request, String name) throws ServletException {
        return HttpRequestUtils.getParam(request, name);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (this.hasParam(req, "getMBeans")) {
            ret.put("mbeans", this.server.getMbeanNames());
        } else if (this.hasParam(req, "getAllMBeanAttributes")) {
            if (!this.hasParam(req, "mBean")) {
                ret.put("error", "Parameters 'mbean' must be set");
            } else {
                String mbeanName = this.getParam(req, "mBean");
                try {
                    ObjectName name = new ObjectName(mbeanName);
                    MBeanInfo info = this.server.getMBeanInfo(name);
                    MBeanAttributeInfo[] mbeanAttrs = info.getAttributes();
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    for (MBeanAttributeInfo attrInfo : mbeanAttrs) {
                        Object obj = this.server.getMBeanAttribute(name, attrInfo.getName());
                        attributes.put(attrInfo.getName(), obj);
                    }
                    ret.put("attributes", attributes);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    ret.put("error", "'" + mbeanName + "' is not a valid mBean name");
                }
            }
        }
        JSONUtils.toJSON(ret, (OutputStream)resp.getOutputStream(), true);
    }
}

