/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.utils.TypedMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionOptions {
    public static final String CONCURRENT_OPTION_SKIP = "skip";
    public static final String CONCURRENT_OPTION_PIPELINE = "pipeline";
    public static final String CONCURRENT_OPTION_IGNORE = "ignore";
    private static final String FLOW_PARAMETERS = "flowParameters";
    private static final String NOTIFY_ON_FIRST_FAILURE = "notifyOnFirstFailure";
    private static final String NOTIFY_ON_LAST_FAILURE = "notifyOnLastFailure";
    private static final String SUCCESS_EMAILS = "successEmails";
    private static final String FAILURE_EMAILS = "failureEmails";
    private static final String FAILURE_ACTION = "failureAction";
    private static final String PIPELINE_LEVEL = "pipelineLevel";
    private static final String PIPELINE_EXECID = "pipelineExecId";
    private static final String QUEUE_LEVEL = "queueLevel";
    private static final String CONCURRENT_OPTION = "concurrentOption";
    private static final String DISABLE = "disabled";
    private static final String FAILURE_EMAILS_OVERRIDE = "failureEmailsOverride";
    private static final String SUCCESS_EMAILS_OVERRIDE = "successEmailsOverride";
    private static final String MAIL_CREATOR = "mailCreator";
    private boolean notifyOnFirstFailure = true;
    private boolean notifyOnLastFailure = false;
    private boolean failureEmailsOverride = false;
    private boolean successEmailsOverride = false;
    private ArrayList<String> failureEmails = new ArrayList();
    private ArrayList<String> successEmails = new ArrayList();
    private Integer pipelineLevel = null;
    private Integer pipelineExecId = null;
    private Integer queueLevel = 0;
    private String concurrentOption = "ignore";
    private String mailCreator = "default";
    private Map<String, String> flowParameters = new HashMap<String, String>();
    private FailureAction failureAction = FailureAction.FINISH_CURRENTLY_RUNNING;
    private List<Object> initiallyDisabledJobs = new ArrayList<Object>();

    public void addAllFlowParameters(Map<String, String> flowParam) {
        this.flowParameters.putAll(flowParam);
    }

    public Map<String, String> getFlowParameters() {
        return this.flowParameters;
    }

    public void setFailureEmails(Collection<String> emails) {
        this.failureEmails = new ArrayList<String>(emails);
    }

    public boolean isFailureEmailsOverridden() {
        return this.failureEmailsOverride;
    }

    public boolean isSuccessEmailsOverridden() {
        return this.successEmailsOverride;
    }

    public void setSuccessEmailsOverridden(boolean override) {
        this.successEmailsOverride = override;
    }

    public void setFailureEmailsOverridden(boolean override) {
        this.failureEmailsOverride = override;
    }

    public List<String> getFailureEmails() {
        return this.failureEmails;
    }

    public void setSuccessEmails(Collection<String> emails) {
        this.successEmails = new ArrayList<String>(emails);
    }

    public List<String> getSuccessEmails() {
        return this.successEmails;
    }

    public boolean getNotifyOnFirstFailure() {
        return this.notifyOnFirstFailure;
    }

    public boolean getNotifyOnLastFailure() {
        return this.notifyOnLastFailure;
    }

    public void setNotifyOnFirstFailure(boolean notify) {
        this.notifyOnFirstFailure = notify;
    }

    public void setNotifyOnLastFailure(boolean notify) {
        this.notifyOnLastFailure = notify;
    }

    public FailureAction getFailureAction() {
        return this.failureAction;
    }

    public void setFailureAction(FailureAction action) {
        this.failureAction = action;
    }

    public void setConcurrentOption(String concurrentOption) {
        this.concurrentOption = concurrentOption;
    }

    public void setMailCreator(String mailCreator) {
        this.mailCreator = mailCreator;
    }

    public String getConcurrentOption() {
        return this.concurrentOption;
    }

    public String getMailCreator() {
        return this.mailCreator;
    }

    public Integer getPipelineLevel() {
        return this.pipelineLevel;
    }

    public Integer getPipelineExecutionId() {
        return this.pipelineExecId;
    }

    public void setPipelineLevel(Integer level) {
        this.pipelineLevel = level;
    }

    public void setPipelineExecutionId(Integer id) {
        this.pipelineExecId = id;
    }

    public Integer getQueueLevel() {
        return this.queueLevel;
    }

    public List<Object> getDisabledJobs() {
        return new ArrayList<Object>(this.initiallyDisabledJobs);
    }

    public void setDisabledJobs(List<Object> disabledJobs) {
        this.initiallyDisabledJobs = disabledJobs;
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> flowOptionObj = new HashMap<String, Object>();
        flowOptionObj.put(FLOW_PARAMETERS, this.flowParameters);
        flowOptionObj.put(NOTIFY_ON_FIRST_FAILURE, this.notifyOnFirstFailure);
        flowOptionObj.put(NOTIFY_ON_LAST_FAILURE, this.notifyOnLastFailure);
        flowOptionObj.put(SUCCESS_EMAILS, this.successEmails);
        flowOptionObj.put(FAILURE_EMAILS, this.failureEmails);
        flowOptionObj.put(FAILURE_ACTION, this.failureAction.toString());
        flowOptionObj.put(PIPELINE_LEVEL, this.pipelineLevel);
        flowOptionObj.put(PIPELINE_EXECID, this.pipelineExecId);
        flowOptionObj.put(QUEUE_LEVEL, this.queueLevel);
        flowOptionObj.put(CONCURRENT_OPTION, this.concurrentOption);
        flowOptionObj.put(DISABLE, this.initiallyDisabledJobs);
        flowOptionObj.put(FAILURE_EMAILS_OVERRIDE, this.failureEmailsOverride);
        flowOptionObj.put(SUCCESS_EMAILS_OVERRIDE, this.successEmailsOverride);
        flowOptionObj.put(MAIL_CREATOR, this.mailCreator);
        return flowOptionObj;
    }

    public static ExecutionOptions createFromObject(Object obj) {
        if (obj == null || !(obj instanceof Map)) {
            return null;
        }
        Map optionsMap = (Map)obj;
        TypedMapWrapper wrapper = new TypedMapWrapper(optionsMap);
        ExecutionOptions options = new ExecutionOptions();
        if (optionsMap.containsKey(FLOW_PARAMETERS)) {
            options.flowParameters = new HashMap<String, String>();
            options.flowParameters.putAll(wrapper.getMap(FLOW_PARAMETERS));
        }
        options.notifyOnFirstFailure = wrapper.getBool(NOTIFY_ON_FIRST_FAILURE, options.notifyOnFirstFailure);
        options.notifyOnLastFailure = wrapper.getBool(NOTIFY_ON_LAST_FAILURE, options.notifyOnLastFailure);
        options.concurrentOption = wrapper.getString(CONCURRENT_OPTION, options.concurrentOption);
        if (wrapper.containsKey(DISABLE)) {
            options.initiallyDisabledJobs = wrapper.getList(DISABLE);
        }
        if (optionsMap.containsKey(MAIL_CREATOR)) {
            options.mailCreator = (String)optionsMap.get(MAIL_CREATOR);
        }
        options.failureAction = FailureAction.valueOf(wrapper.getString(FAILURE_ACTION, options.failureAction.toString()));
        options.pipelineLevel = wrapper.getInt(PIPELINE_LEVEL, options.pipelineLevel);
        options.pipelineExecId = wrapper.getInt(PIPELINE_EXECID, options.pipelineExecId);
        options.queueLevel = wrapper.getInt(QUEUE_LEVEL, options.queueLevel);
        options.setSuccessEmails(wrapper.getList(SUCCESS_EMAILS, Collections.emptyList()));
        options.setFailureEmails(wrapper.getList(FAILURE_EMAILS, Collections.emptyList()));
        options.setSuccessEmailsOverridden(wrapper.getBool(SUCCESS_EMAILS_OVERRIDE, false));
        options.setFailureEmailsOverridden(wrapper.getBool(FAILURE_EMAILS_OVERRIDE, false));
        return options;
    }

    public static enum FailureAction {
        FINISH_CURRENTLY_RUNNING,
        CANCEL_ALL,
        FINISH_ALL_POSSIBLE;

    }
}

