/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.FixedTargetTaskAssignmentCalculator;
import org.apache.helix.task.GenericTaskAssignmentCalculator;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskAssignmentCalculator;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskRebalancer;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;

public class JobRebalancer
extends TaskRebalancer {
    private static final Logger LOG = Logger.getLogger(JobRebalancer.class);
    private static TaskAssignmentCalculator _fixTaskAssignmentCal = new FixedTargetTaskAssignmentCalculator();
    private static TaskAssignmentCalculator _genericTaskAssignmentCal = new GenericTaskAssignmentCalculator();
    private static final String PREV_RA_NODE = "PreviousResourceAssignment";

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache clusterData, IdealState taskIs, Resource resource, CurrentStateOutput currStateOutput) {
        Set<String> liveInstances;
        ResourceAssignment prevAssignment;
        String jobName = resource.getResourceName();
        LOG.debug((Object)("Computer Best Partition for job: " + jobName));
        JobConfig jobCfg = TaskUtil.getJobConfig(this._manager, jobName);
        if (jobCfg == null) {
            LOG.error((Object)("Job configuration is NULL for " + jobName));
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        String workflowResource = jobCfg.getWorkflow();
        WorkflowConfig workflowCfg = TaskUtil.getWorkflowConfig(this._manager, workflowResource);
        if (workflowCfg == null) {
            LOG.error((Object)("Workflow configuration is NULL for " + jobName));
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        WorkflowContext workflowCtx = TaskUtil.getWorkflowContext(this._manager, workflowResource);
        if (workflowCtx == null) {
            LOG.error((Object)("Workflow context is NULL for " + jobName));
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        TargetState targetState = workflowCfg.getTargetState();
        if (targetState != TargetState.START && targetState != TargetState.STOP) {
            LOG.info((Object)("Target state is " + targetState.name() + " for workflow " + workflowResource + ".Stop scheduling job " + jobName));
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        TaskState workflowState = workflowCtx.getWorkflowState();
        TaskState jobState = workflowCtx.getJobState(jobName);
        if (workflowState == TaskState.FAILED || workflowState == TaskState.COMPLETED || jobState == TaskState.FAILED || jobState == TaskState.COMPLETED) {
            LOG.info((Object)String.format("Workflow %s or job %s is already failed or completed, workflow state (%s), job state (%s), clean up job IS.", new Object[]{workflowResource, jobName, workflowState, jobState}));
            TaskUtil.cleanupJobIdealStateExtView(this._manager.getHelixDataAccessor(), jobName);
            _scheduledRebalancer.removeScheduledRebalance(jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        if (!this.isWorkflowReadyForSchedule(workflowCfg)) {
            LOG.info((Object)("Job is not ready to be run since workflow is not ready " + jobName));
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        if (!this.isJobStarted(jobName, workflowCtx) && !this.isJobReadyToSchedule(jobName, workflowCfg, workflowCtx)) {
            LOG.info((Object)("Job is not ready to run " + jobName));
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        JobContext jobCtx = TaskUtil.getJobContext(this._manager, jobName);
        if (jobCtx == null) {
            jobCtx = new JobContext(new ZNRecord("TaskContext"));
            jobCtx.setStartTime(System.currentTimeMillis());
        }
        if ((prevAssignment = this.getPrevResourceAssignment(jobName)) == null) {
            prevAssignment = new ResourceAssignment(jobName);
        }
        Set<String> set = liveInstances = jobCfg.getInstanceGroupTag() == null ? clusterData.getEnabledLiveInstances() : clusterData.getEnabledLiveInstancesWithTag(jobCfg.getInstanceGroupTag());
        if (liveInstances.isEmpty()) {
            LOG.error((Object)"No available instance found for job!");
        }
        TreeSet<Integer> partitionsToDrop = new TreeSet<Integer>();
        ResourceAssignment newAssignment = this.computeResourceMapping(jobName, workflowCfg, jobCfg, prevAssignment, liveInstances, currStateOutput, workflowCtx, jobCtx, partitionsToDrop, clusterData);
        if (!partitionsToDrop.isEmpty()) {
            for (Integer pId : partitionsToDrop) {
                taskIs.getRecord().getMapFields().remove(this.pName(jobName, pId));
            }
            HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
            PropertyKey propertyKey = accessor.keyBuilder().idealStates(jobName);
            accessor.setProperty(propertyKey, taskIs);
        }
        TaskUtil.setJobContext(this._manager, jobName, jobCtx);
        TaskUtil.setWorkflowContext(this._manager, workflowResource, workflowCtx);
        this.setPrevResourceAssignment(jobName, newAssignment);
        LOG.debug((Object)("Job " + jobName + " new assignment " + Arrays.toString(newAssignment.getMappedPartitions().toArray())));
        return newAssignment;
    }

    private Set<String> getExcludedInstances(String currentJobName, WorkflowConfig workflowCfg) {
        HashSet<String> ret = new HashSet<String>();
        if (!workflowCfg.isAllowOverlapJobAssignment()) {
            for (String jobName : workflowCfg.getJobDag().getAllNodes()) {
                JobContext jobContext;
                if (jobName.equals(currentJobName) || (jobContext = TaskUtil.getJobContext(this._manager, jobName)) == null) continue;
                for (int partition : jobContext.getPartitionSet()) {
                    TaskPartitionState partitionState = jobContext.getPartitionState(partition);
                    if (partitionState != TaskPartitionState.INIT && partitionState != TaskPartitionState.RUNNING) continue;
                    ret.add(jobContext.getAssignedParticipant(partition));
                }
            }
        }
        return ret;
    }

    private ResourceAssignment computeResourceMapping(String jobResource, WorkflowConfig workflowConfig, JobConfig jobCfg, ResourceAssignment prevAssignment, Collection<String> liveInstances, CurrentStateOutput currStateOutput, WorkflowContext workflowCtx, JobContext jobCtx, Set<Integer> partitionsToDropFromIs, ClusterDataCache cache) {
        TargetState jobTgtState = workflowConfig.getTargetState();
        if (jobTgtState == TargetState.STOP) {
            if (this.checkJobStopped(jobCtx)) {
                workflowCtx.setJobState(jobResource, TaskState.STOPPED);
            } else {
                workflowCtx.setJobState(jobResource, TaskState.STOPPING);
            }
            if (this.isWorkflowStopped(workflowCtx, workflowConfig)) {
                workflowCtx.setWorkflowState(TaskState.STOPPED);
            } else {
                workflowCtx.setWorkflowState(TaskState.STOPPING);
            }
        } else {
            workflowCtx.setJobState(jobResource, TaskState.IN_PROGRESS);
            workflowCtx.setWorkflowState(TaskState.IN_PROGRESS);
        }
        HashSet<Integer> assignedPartitions = new HashSet<Integer>();
        HashSet<Integer> skippedPartitions = new HashSet<Integer>();
        TreeMap<Integer, PartitionAssignment> paMap = new TreeMap<Integer, PartitionAssignment>();
        Set<String> excludedInstances = this.getExcludedInstances(jobResource, workflowConfig);
        TaskAssignmentCalculator taskAssignmentCal = this.getAssignmentCalulator(jobCfg);
        Set<Integer> allPartitions = taskAssignmentCal.getAllTaskPartitions(jobCfg, jobCtx, workflowConfig, workflowCtx, cache.getIdealStates());
        if (allPartitions == null || allPartitions.isEmpty()) {
            String failureMsg = "Empty task partition mapping for job " + jobResource + ", marked the job as FAILED!";
            LOG.info((Object)failureMsg);
            jobCtx.setInfo(failureMsg);
            this.markJobFailed(jobResource, jobCtx, workflowConfig, workflowCtx);
            JobRebalancer.markAllPartitionsError(jobCtx, TaskPartitionState.ERROR, false);
            this._clusterStatusMonitor.updateJobCounters(jobCfg, TaskState.FAILED);
            return new ResourceAssignment(jobResource);
        }
        Map<String, SortedSet<Integer>> taskAssignments = JobRebalancer.getTaskPartitionAssignments(liveInstances, prevAssignment, allPartitions);
        long currentTime = System.currentTimeMillis();
        LOG.debug((Object)("All partitions: " + allPartitions + " taskAssignment: " + taskAssignments + " excludedInstances: " + excludedInstances));
        for (String instance : taskAssignments.keySet()) {
            if (excludedInstances.contains(instance)) continue;
            Set pSet = taskAssignments.get(instance);
            TreeSet<Integer> donePartitions = new TreeSet<Integer>();
            Iterator i$ = pSet.iterator();
            block7: while (i$.hasNext()) {
                int pId = (Integer)i$.next();
                String pName = this.pName(jobResource, pId);
                TaskPartitionState currState = this.updateJobContextAndGetTaskCurrentState(currStateOutput, jobResource, pId, pName, instance, jobCtx);
                Message pendingMessage = currStateOutput.getPendingState(jobResource, new Partition(pName), instance);
                if (pendingMessage != null) {
                    Map<String, String> stateMap = prevAssignment.getReplicaMap(new Partition(pName));
                    if (stateMap == null) continue;
                    String prevState = stateMap.get(instance);
                    paMap.put(pId, new PartitionAssignment(instance, prevState));
                    assignedPartitions.add(pId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)String.format("Task partition %s has a pending state transition on instance %s. Using the previous ideal state which was %s.", pName, instance, prevState));
                    continue;
                }
                String requestedStateStr = currStateOutput.getRequestedState(jobResource, new Partition(pName), instance);
                if (requestedStateStr != null && !requestedStateStr.isEmpty()) {
                    TaskPartitionState requestedState = TaskPartitionState.valueOf(requestedStateStr);
                    if (requestedState.equals((Object)currState)) {
                        LOG.warn((Object)String.format("Requested state %s is the same as the current state for instance %s.", new Object[]{requestedState, instance}));
                    }
                    paMap.put(pId, new PartitionAssignment(instance, requestedState.name()));
                    assignedPartitions.add(pId);
                    LOG.debug((Object)String.format("Instance %s requested a state transition to %s for partition %s.", new Object[]{instance, requestedState, pName}));
                    continue;
                }
                switch (currState) {
                    case RUNNING: 
                    case STOPPED: {
                        TaskPartitionState nextState = jobTgtState == TargetState.START ? TaskPartitionState.RUNNING : TaskPartitionState.STOPPED;
                        paMap.put(pId, new PartitionAssignment(instance, nextState.name()));
                        assignedPartitions.add(pId);
                        LOG.debug((Object)String.format("Setting task partition %s state to %s on instance %s.", new Object[]{pName, nextState, instance}));
                        continue block7;
                    }
                    case COMPLETED: {
                        donePartitions.add(pId);
                        LOG.debug((Object)String.format("Task partition %s has completed with state %s. Marking as such in rebalancer context.", new Object[]{pName, currState}));
                        partitionsToDropFromIs.add(pId);
                        JobRebalancer.markPartitionCompleted(jobCtx, pId);
                        continue block7;
                    }
                    case TIMED_OUT: 
                    case TASK_ERROR: 
                    case TASK_ABORTED: 
                    case ERROR: {
                        donePartitions.add(pId);
                        LOG.debug((Object)String.format("Task partition %s has error state %s with msg %s. Marking as such in rebalancer context.", new Object[]{pName, currState, jobCtx.getPartitionInfo(pId)}));
                        JobRebalancer.markPartitionError(jobCtx, pId, currState, true);
                        if (jobCtx.getPartitionNumAttempts(pId) >= jobCfg.getMaxAttemptsPerTask() || currState.equals((Object)TaskPartitionState.TASK_ABORTED)) {
                            if (skippedPartitions.size() >= jobCfg.getFailureThreshold()) {
                                this.markJobFailed(jobResource, jobCtx, workflowConfig, workflowCtx);
                                this._clusterStatusMonitor.updateJobCounters(jobCfg, TaskState.FAILED);
                                JobRebalancer.markAllPartitionsError(jobCtx, currState, false);
                                JobRebalancer.addAllPartitions(allPartitions, partitionsToDropFromIs);
                                TaskUtil.cleanupJobIdealStateExtView(this._manager.getHelixDataAccessor(), jobResource);
                                return this.buildEmptyAssignment(jobResource, currStateOutput);
                            }
                            skippedPartitions.add(pId);
                            partitionsToDropFromIs.add(pId);
                            LOG.debug((Object)("skippedPartitions:" + skippedPartitions));
                            continue block7;
                        }
                        JobRebalancer.markPartitionDelayed(jobCfg, jobCtx, pId);
                        continue block7;
                    }
                    case INIT: 
                    case DROPPED: {
                        donePartitions.add(pId);
                        LOG.debug((Object)String.format("Task partition %s has state %s. It will be dropped from the current ideal state.", new Object[]{pName, currState}));
                        continue block7;
                    }
                }
                throw new AssertionError((Object)("Unknown enum symbol: " + (Object)((Object)currState)));
            }
            pSet.removeAll(donePartitions);
        }
        this.scheduleForNextTask(jobResource, jobCtx, currentTime);
        if (JobRebalancer.isJobComplete(jobCtx, allPartitions, skippedPartitions, jobCfg)) {
            this.markJobComplete(jobResource, jobCtx, workflowConfig, workflowCtx);
            this._clusterStatusMonitor.updateJobCounters(jobCfg, TaskState.COMPLETED);
            TaskUtil.cleanupJobIdealStateExtView(this._manager.getHelixDataAccessor(), jobResource);
        }
        if (jobTgtState == TargetState.START) {
            TreeSet excludeSet = Sets.newTreeSet(assignedPartitions);
            JobRebalancer.addCompletedTasks(excludeSet, jobCtx, allPartitions);
            JobRebalancer.addGiveupPartitions(excludeSet, jobCtx, allPartitions, jobCfg);
            excludeSet.addAll(skippedPartitions);
            excludeSet.addAll(JobRebalancer.getNonReadyPartitions(jobCtx, currentTime));
            Map<String, SortedSet<Integer>> tgtPartitionAssignments = taskAssignmentCal.getTaskAssignment(currStateOutput, prevAssignment, liveInstances, jobCfg, jobCtx, workflowConfig, workflowCtx, allPartitions, cache.getIdealStates());
            if (!this.isGenericTaskJob(jobCfg) || jobCfg.isRebalanceRunningTask()) {
                this.dropRebalancedRunningTasks(tgtPartitionAssignments, taskAssignments, paMap, jobCtx);
            }
            for (Map.Entry<String, SortedSet<Integer>> entry : taskAssignments.entrySet()) {
                String instance = entry.getKey();
                if (!tgtPartitionAssignments.containsKey(instance) || excludedInstances.contains(instance)) continue;
                Set pSet = entry.getValue();
                int jobCfgLimitation = jobCfg.getNumConcurrentTasksPerInstance() - pSet.size();
                int participantCapacity = cache.getInstanceConfigMap().get(instance).getMaxConcurrentTask();
                if (participantCapacity == -1) {
                    participantCapacity = cache.getClusterConfig().getMaxConcurrentTaskPerInstance();
                }
                int participantLimitation = participantCapacity - cache.getParticipantActiveTaskCount(instance);
                int numToAssign = Math.min(jobCfgLimitation, participantLimitation);
                LOG.debug((Object)String.format("Throttle tasks to be assigned to instance %s using limitation: Job Concurrent Task(%d), Participant Max Task(%d). Remaining capacity %d.", instance, jobCfgLimitation, participantCapacity, numToAssign));
                if (numToAssign <= 0) continue;
                HashSet<Integer> throttledSet = new HashSet<Integer>();
                List<Integer> nextPartitions = JobRebalancer.getNextPartitions(tgtPartitionAssignments.get(instance), excludeSet, throttledSet, numToAssign);
                for (Integer pId : nextPartitions) {
                    String pName = this.pName(jobResource, pId);
                    paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.RUNNING.name()));
                    excludeSet.add(pId);
                    jobCtx.setAssignedParticipant(pId, instance);
                    jobCtx.setPartitionState(pId, TaskPartitionState.INIT);
                    jobCtx.setPartitionStartTime(pId, System.currentTimeMillis());
                    LOG.debug((Object)String.format("Setting task partition %s state to %s on instance %s.", new Object[]{pName, TaskPartitionState.RUNNING, instance}));
                }
                cache.setParticipantActiveTaskCount(instance, cache.getParticipantActiveTaskCount(instance) + nextPartitions.size());
                if (throttledSet.isEmpty()) continue;
                LOG.debug((Object)(throttledSet.size() + "tasks are ready but throttled when assigned to participant."));
            }
        }
        ResourceAssignment ra = new ResourceAssignment(jobResource);
        for (Map.Entry e : paMap.entrySet()) {
            PartitionAssignment pa = (PartitionAssignment)e.getValue();
            ra.addReplicaMap(new Partition(this.pName(jobResource, (Integer)e.getKey())), (Map<String, String>)ImmutableMap.of((Object)pa._instance, (Object)pa._state));
        }
        return ra;
    }

    private void dropRebalancedRunningTasks(Map<String, SortedSet<Integer>> newAssignment, Map<String, SortedSet<Integer>> oldAssignment, Map<Integer, PartitionAssignment> paMap, JobContext jobContext) {
        for (String instance : oldAssignment.keySet()) {
            for (Integer pId : oldAssignment.get(instance)) {
                if (jobContext.getPartitionState(pId) != TaskPartitionState.RUNNING || newAssignment.get(instance).contains(pId)) continue;
                paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.DROPPED.name()));
                jobContext.setPartitionState(pId, TaskPartitionState.DROPPED);
            }
        }
    }

    private TaskPartitionState updateJobContextAndGetTaskCurrentState(CurrentStateOutput currentStateOutput, String jobResource, Integer pId, String pName, String instance, JobContext jobCtx) {
        String currentStateString = currentStateOutput.getCurrentState(jobResource, new Partition(pName), instance);
        if (currentStateString == null) {
            return jobCtx.getPartitionState(pId);
        }
        TaskPartitionState currentState = TaskPartitionState.valueOf(currentStateString);
        jobCtx.setPartitionState(pId, currentState);
        String taskMsg = currentStateOutput.getInfo(jobResource, new Partition(pName), instance);
        if (taskMsg != null) {
            jobCtx.setPartitionInfo(pId, taskMsg);
        }
        return currentState;
    }

    private void markJobComplete(String jobName, JobContext jobContext, WorkflowConfig workflowConfig, WorkflowContext workflowContext) {
        long currentTime = System.currentTimeMillis();
        workflowContext.setJobState(jobName, TaskState.COMPLETED);
        jobContext.setFinishTime(currentTime);
        if (this.isWorkflowFinished(workflowContext, workflowConfig)) {
            workflowContext.setFinishTime(currentTime);
        }
        this.scheduleJobCleanUp(jobName, workflowConfig, currentTime);
    }

    private void scheduleForNextTask(String job, JobContext jobCtx, long now) {
        long currentTime = now;
        long scheduledTime = _scheduledRebalancer.getRebalanceTime(job);
        if (scheduledTime > 0L && currentTime > scheduledTime) {
            _scheduledRebalancer.removeScheduledRebalance(job);
        }
        boolean shouldSchedule = false;
        long earliestTime = Long.MAX_VALUE;
        for (int p : jobCtx.getPartitionSet()) {
            long retryTime = jobCtx.getNextRetryTime(p);
            TaskPartitionState state = jobCtx.getPartitionState(p);
            TaskPartitionState taskPartitionState = state = state != null ? state : TaskPartitionState.INIT;
            HashSet errorStates = Sets.newHashSet((Object[])new TaskPartitionState[]{TaskPartitionState.ERROR, TaskPartitionState.TASK_ERROR, TaskPartitionState.TIMED_OUT});
            if (!errorStates.contains((Object)state) || retryTime <= currentTime || retryTime >= earliestTime) continue;
            earliestTime = retryTime;
            shouldSchedule = true;
        }
        if (shouldSchedule) {
            _scheduledRebalancer.scheduleRebalance(this._manager, job, earliestTime);
        }
    }

    private ResourceAssignment getPrevResourceAssignment(String resourceName) {
        ZNRecord r = (ZNRecord)this._manager.getHelixPropertyStore().get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resourceName, new Object[]{PREV_RA_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new ResourceAssignment(r) : null;
    }

    private void setPrevResourceAssignment(String resourceName, ResourceAssignment ra) {
        this._manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resourceName, new Object[]{PREV_RA_NODE}), ra.getRecord(), AccessOption.PERSISTENT);
    }

    private static boolean isJobComplete(JobContext ctx, Set<Integer> allPartitions, Set<Integer> skippedPartitions, JobConfig cfg) {
        for (Integer pId : allPartitions) {
            TaskPartitionState state = ctx.getPartitionState(pId);
            if (skippedPartitions.contains(pId) || state == TaskPartitionState.COMPLETED || JobRebalancer.isTaskGivenup(ctx, cfg, pId)) continue;
            return false;
        }
        return true;
    }

    private static void addAllPartitions(Set<Integer> toAdd, Set<Integer> destination) {
        for (Integer pId : toAdd) {
            destination.add(pId);
        }
    }

    private static void addCompletedTasks(Set<Integer> set, JobContext ctx, Iterable<Integer> pIds) {
        for (Integer pId : pIds) {
            TaskPartitionState state = ctx.getPartitionState(pId);
            if (state != TaskPartitionState.COMPLETED) continue;
            set.add(pId);
        }
    }

    private static boolean isTaskGivenup(JobContext ctx, JobConfig cfg, int pId) {
        TaskPartitionState state = ctx.getPartitionState(pId);
        if (state != null && state.equals((Object)TaskPartitionState.TASK_ABORTED) | state.equals((Object)TaskPartitionState.ERROR)) {
            return true;
        }
        return ctx.getPartitionNumAttempts(pId) >= cfg.getMaxAttemptsPerTask();
    }

    private static void addGiveupPartitions(Set<Integer> set, JobContext ctx, Iterable<Integer> pIds, JobConfig cfg) {
        for (Integer pId : pIds) {
            if (!JobRebalancer.isTaskGivenup(ctx, cfg, pId)) continue;
            set.add(pId);
        }
    }

    private static List<Integer> getNextPartitions(SortedSet<Integer> candidatePartitions, Set<Integer> excluded, Set<Integer> throttled, int n) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer pId : candidatePartitions) {
            if (excluded.contains(pId)) continue;
            if (result.size() < n) {
                result.add(pId);
                continue;
            }
            throttled.add(pId);
        }
        return result;
    }

    private static void markPartitionDelayed(JobConfig cfg, JobContext ctx, int p) {
        long delayInterval = cfg.getTaskRetryDelay();
        if (delayInterval <= 0L) {
            return;
        }
        long nextStartTime = ctx.getPartitionFinishTime(p) + delayInterval;
        ctx.setNextRetryTime(p, nextStartTime);
    }

    private static void markPartitionCompleted(JobContext ctx, int pId) {
        ctx.setPartitionState(pId, TaskPartitionState.COMPLETED);
        ctx.setPartitionFinishTime(pId, System.currentTimeMillis());
        ctx.incrementNumAttempts(pId);
    }

    private static void markPartitionError(JobContext ctx, int pId, TaskPartitionState state, boolean incrementAttempts) {
        ctx.setPartitionState(pId, state);
        ctx.setPartitionFinishTime(pId, System.currentTimeMillis());
        if (incrementAttempts) {
            ctx.incrementNumAttempts(pId);
        }
    }

    private static void markAllPartitionsError(JobContext ctx, TaskPartitionState state, boolean incrementAttempts) {
        for (int pId : ctx.getPartitionSet()) {
            JobRebalancer.markPartitionError(ctx, pId, state, incrementAttempts);
        }
    }

    private static Map<String, SortedSet<Integer>> getTaskPartitionAssignments(Iterable<String> instanceList, ResourceAssignment assignment, Set<Integer> includeSet) {
        HashMap<String, SortedSet<Integer>> result = new HashMap<String, SortedSet<Integer>>();
        for (String instance : instanceList) {
            result.put(instance, new TreeSet());
        }
        for (Partition partition : assignment.getMappedPartitions()) {
            int pId = JobRebalancer.getPartitionId(partition.getPartitionName());
            if (!includeSet.contains(pId)) continue;
            Map<String, String> replicaMap = assignment.getReplicaMap(partition);
            for (String instance : replicaMap.keySet()) {
                SortedSet pList = (SortedSet)result.get(instance);
                if (pList == null) continue;
                pList.add(pId);
            }
        }
        return result;
    }

    private static int getPartitionId(String pName) {
        int index = pName.lastIndexOf("_");
        if (index == -1) {
            throw new HelixException("Invalid partition name " + pName);
        }
        return Integer.valueOf(pName.substring(index + 1));
    }

    private static Set<Integer> getNonReadyPartitions(JobContext ctx, long now) {
        HashSet nonReadyPartitions = Sets.newHashSet();
        for (int p : ctx.getPartitionSet()) {
            long toStart = ctx.getNextRetryTime(p);
            if (now >= toStart) continue;
            nonReadyPartitions.add(p);
        }
        return nonReadyPartitions;
    }

    private TaskAssignmentCalculator getAssignmentCalulator(JobConfig jobConfig) {
        return this.isGenericTaskJob(jobConfig) ? _genericTaskAssignmentCal : _fixTaskAssignmentCal;
    }

    private boolean isGenericTaskJob(JobConfig jobConfig) {
        Map<String, TaskConfig> taskConfigMap = jobConfig.getTaskConfigMap();
        return taskConfigMap != null && !taskConfigMap.isEmpty();
    }

    private boolean checkJobStopped(JobContext jobContext) {
        for (int partition : jobContext.getPartitionSet()) {
            TaskPartitionState taskState = jobContext.getPartitionState(partition);
            if (taskState == null || !taskState.equals((Object)TaskPartitionState.RUNNING)) continue;
            return false;
        }
        return true;
    }

    private String pName(String resource, int pId) {
        return resource + "_" + pId;
    }

    private static class PartitionAssignment {
        private final String _instance;
        private final String _state;

        private PartitionAssignment(String instance, String state) {
            this._instance = instance;
            this._state = state;
        }
    }
}

