/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionCallback<T>
implements TransportCallback<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionCallback.class);
    private final ExecutorService _executor;
    private AtomicReference<TransportCallback<T>> _callbackRef;

    public ExecutionCallback(ExecutorService executor, TransportCallback<T> callback) {
        this._executor = executor;
        this._callbackRef = new AtomicReference<TransportCallback<T>>(callback);
    }

    public void onResponse(final TransportResponse<T> response) {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                TransportCallback callback = ExecutionCallback.this._callbackRef.getAndSet(null);
                if (callback != null) {
                    callback.onResponse(response);
                } else {
                    LOG.warn("Received response {} while _callback is null. Ignored.", response.getResponse());
                }
            }
        });
    }
}

