/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.MessageType;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.ChannelPoolHandler;
import com.linkedin.r2.transport.http.client.ChannelPoolLifecycle;
import com.linkedin.r2.transport.http.client.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.ExecutionCallback;
import com.linkedin.r2.transport.http.client.ExponentialBackOffRateLimiter;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.PoolStatsProvider;
import com.linkedin.r2.transport.http.client.RAPClientCodec;
import com.linkedin.r2.transport.http.client.RAPResponseHandler;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.transport.http.client.SslRequestHandler;
import com.linkedin.r2.transport.http.client.TimeoutCallback;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import com.linkedin.r2.transport.http.common.HttpBridge;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.util.Cancellable;
import com.linkedin.r2.util.TimeoutRunnable;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelGroupFutureListener;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpNettyClient
implements TransportClient {
    static final Logger LOG = LoggerFactory.getLogger(HttpNettyClient.class);
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private final ChannelPoolManager _channelPoolManager;
    private final ChannelGroup _allChannels;
    private final ChannelPoolHandler _handler = new ChannelPoolHandler();
    private final RAPResponseHandler _responseHandler = new RAPResponseHandler();
    private final AtomicReference<State> _state = new AtomicReference<State>(State.RUNNING);
    private final ScheduledExecutorService _scheduler;
    private final ExecutorService _callbackExecutors;
    private final long _requestTimeout;
    private final long _shutdownTimeout;
    private final int _maxResponseSize;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final int _maxConcurrentConnections;
    private final String _requestTimeoutMessage;
    private final AbstractJmxManager _jmxManager;

    public HttpNettyClient(NioEventLoopGroup eventLoopGroup, ScheduledExecutorService executor, int poolSize, long requestTimeout, long idleTimeout, long shutdownTimeout, int maxResponseSize, SSLContext sslContext, SSLParameters sslParameters, ExecutorService callbackExecutors, int poolWaiterSize, String name, AbstractJmxManager jmxManager, AsyncPoolImpl.Strategy strategy, int minPoolSize, int maxHeaderSize, int maxChunkSize, int maxConcurrentConnections) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new HttpClientPipelineInitializer(sslContext, sslParameters));
        this._channelPoolManager = new ChannelPoolManager(new ChannelPoolFactoryImpl(bootstrap, poolSize, idleTimeout, poolWaiterSize, strategy, minPoolSize), name + "ChannelPools");
        this._maxResponseSize = maxResponseSize;
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxConcurrentConnections = maxConcurrentConnections;
        this._scheduler = executor;
        this._callbackExecutors = callbackExecutors == null ? eventLoopGroup : callbackExecutors;
        this._requestTimeout = requestTimeout;
        this._shutdownTimeout = shutdownTimeout;
        this._requestTimeoutMessage = "Exceeded request timeout of " + this._requestTimeout + "ms";
        this._jmxManager = jmxManager;
        this._allChannels = new DefaultChannelGroup("R2 client channels", (EventExecutor)eventLoopGroup.next());
        this._jmxManager.onProviderCreate((PoolStatsProvider)this._channelPoolManager);
    }

    HttpNettyClient(ChannelPoolFactory factory, ScheduledExecutorService executor, int requestTimeout, int shutdownTimeout, int maxResponseSize) {
        this._maxResponseSize = maxResponseSize;
        this._channelPoolManager = new ChannelPoolManager(factory);
        this._scheduler = executor;
        this._callbackExecutors = new DefaultEventExecutorGroup(1);
        this._requestTimeout = requestTimeout;
        this._shutdownTimeout = shutdownTimeout;
        this._requestTimeoutMessage = "Exceeded request timeout of " + this._requestTimeout + "ms";
        this._jmxManager = AbstractJmxManager.NULL_JMX_MANAGER;
        this._jmxManager.onProviderCreate((PoolStatsProvider)this._channelPoolManager);
        this._maxHeaderSize = 8192;
        this._maxChunkSize = 8192;
        this._maxConcurrentConnections = Integer.MAX_VALUE;
        this._allChannels = new DefaultChannelGroup("R2 client channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        MessageType.setMessageType((MessageType.Type)MessageType.Type.REST, wireAttrs);
        this.writeRequestWithTimeout(request, requestContext, wireAttrs, (TransportCallback<RestResponse>)HttpBridge.restToHttpCallback(callback, (RestRequest)request));
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        throw new UnsupportedOperationException("stream is not supported.");
    }

    public void shutdown(final Callback<None> callback) {
        LOG.info("Shutdown requested");
        if (this._state.compareAndSet(State.RUNNING, State.SHUTTING_DOWN)) {
            LOG.info("Shutting down");
            final long deadline = System.currentTimeMillis() + this._shutdownTimeout;
            TimeoutCallback closeChannels = new TimeoutCallback(this._scheduler, this._shutdownTimeout, TimeUnit.MILLISECONDS, (Callback)new Callback<None>(){

                private void finishShutdown() {
                    HttpNettyClient.this._state.set(State.REQUESTS_STOPPING);
                    for (Callback<Channel> callback2 : HttpNettyClient.this._channelPoolManager.cancelWaiters()) {
                        callback2.onError((Throwable)new TimeoutException("Operation did not complete before shutdown"));
                    }
                    for (Channel c : HttpNettyClient.this._allChannels) {
                        TransportCallback callback3 = (TransportCallback)c.attr(RAPResponseHandler.CALLBACK_ATTR_KEY).getAndRemove();
                        if (callback3 == null) continue;
                        HttpNettyClient.errorResponse(callback3, new TimeoutException("Operation did not complete before shutdown"));
                    }
                    final TimeoutRunnable afterClose = new TimeoutRunnable(HttpNettyClient.this._scheduler, deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS, new Runnable(){

                        @Override
                        public void run() {
                            HttpNettyClient.this._state.set(State.SHUTDOWN);
                            LOG.info("Shutdown complete");
                            callback.onSuccess((Object)None.none());
                        }
                    }, "Timed out waiting for channels to close, continuing shutdown");
                    HttpNettyClient.this._allChannels.close().addListener((GenericFutureListener)new ChannelGroupFutureListener(){

                        public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                            if (!channelGroupFuture.isSuccess()) {
                                LOG.warn("Failed to close some connections, ignoring");
                            }
                            afterClose.run();
                        }
                    });
                }

                public void onSuccess(None none) {
                    LOG.info("All connection pools shut down, closing all channels");
                    this.finishShutdown();
                }

                public void onError(Throwable e) {
                    LOG.warn("Error shutting down HTTP connection pools, ignoring and continuing shutdown", e);
                    this.finishShutdown();
                }
            }, "Connection pool shutdown timeout exceeded (" + this._shutdownTimeout + "ms)");
            this._channelPoolManager.shutdown((Callback<None>)closeChannels);
            this._jmxManager.onProviderShutdown((PoolStatsProvider)this._channelPoolManager);
        } else {
            callback.onError((Throwable)new IllegalStateException("Shutdown has already been requested."));
        }
    }

    private void writeRequestWithTimeout(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        ExecutionCallback<RestResponse> executionCallback = new ExecutionCallback<RestResponse>(this._callbackExecutors, callback);
        TimeoutTransportCallback timeoutCallback = new TimeoutTransportCallback(this._scheduler, this._requestTimeout, TimeUnit.MILLISECONDS, executionCallback, this._requestTimeoutMessage);
        this.writeRequest(request, requestContext, wireAttrs, (TimeoutTransportCallback<RestResponse>)timeoutCallback);
    }

    private void writeRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, final TimeoutTransportCallback<RestResponse> callback) {
        AsyncPool<Channel> pool;
        InetSocketAddress address;
        State state = this._state.get();
        if (state != State.RUNNING) {
            HttpNettyClient.errorResponse(callback, new IllegalStateException("Client is " + (Object)((Object)state)));
            return;
        }
        URI uri = request.getURI();
        String scheme = uri.getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            HttpNettyClient.errorResponse(callback, new IllegalArgumentException("Unknown scheme: " + scheme + " (only http/https is supported)"));
            return;
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = "http".equalsIgnoreCase(scheme) ? 80 : 443;
        }
        final RestRequest newRequest = ((RestRequestBuilder)new RestRequestBuilder(request).overwriteHeaders(WireAttributeHelper.toWireAttributes(wireAttrs))).build();
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            address = new InetSocketAddress(inetAddress, port);
            requestContext.putLocalAttr("REMOTE_SERVER_ADDR", (Object)inetAddress.getHostAddress());
        }
        catch (UnknownHostException e) {
            HttpNettyClient.errorResponse(callback, e);
            return;
        }
        requestContext.putLocalAttr("HTTP_PROTOCOL_VERSION", (Object)HttpProtocolVersion.HTTP_1_1);
        try {
            pool = this._channelPoolManager.getPoolForAddress(address);
        }
        catch (IllegalStateException e) {
            HttpNettyClient.errorResponse(callback, e);
            return;
        }
        final Cancellable pendingGet = pool.get((Callback)new Callback<Channel>(){

            public void onSuccess(final Channel channel) {
                channel.attr(ChannelPoolHandler.CHANNEL_POOL_ATTR_KEY).set((Object)pool);
                callback.addTimeoutTask(new Runnable(){

                    @Override
                    public void run() {
                        AsyncPool pool = (AsyncPool)channel.attr(ChannelPoolHandler.CHANNEL_POOL_ATTR_KEY).getAndRemove();
                        if (pool != null) {
                            pool.dispose((Object)channel);
                        }
                    }
                });
                channel.attr(RAPResponseHandler.CALLBACK_ATTR_KEY).set((Object)callback);
                State state = (State)((Object)HttpNettyClient.this._state.get());
                if (state == State.REQUESTS_STOPPING || state == State.SHUTDOWN) {
                    HttpNettyClient.errorResponse(callback, new TimeoutException("Operation did not complete before shutdown"));
                    return;
                }
                channel.writeAndFlush((Object)newRequest).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }

            public void onError(Throwable e) {
                HttpNettyClient.errorResponse(callback, e);
            }
        });
        if (pendingGet != null) {
            callback.addTimeoutTask(new Runnable(){

                @Override
                public void run() {
                    pendingGet.cancel();
                }
            });
        }
    }

    static <T> void errorResponse(TransportCallback<T> callback, Throwable e) {
        callback.onResponse(TransportResponseImpl.error((Throwable)e));
    }

    static Exception toException(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new Exception("Wrapped Throwable", t);
    }

    public Map<String, PoolStats> getPoolStats() {
        return this._channelPoolManager.getPoolStats();
    }

    public long getRequestTimeout() {
        return this._requestTimeout;
    }

    public long getShutdownTimeout() {
        return this._shutdownTimeout;
    }

    public long getMaxResponseSize() {
        return this._maxResponseSize;
    }

    private class ChannelPoolFactoryImpl
    implements ChannelPoolFactory {
        private final Bootstrap _bootstrap;
        private final int _maxPoolSize;
        private final long _idleTimeout;
        private final int _maxPoolWaiterSize;
        private final AsyncPoolImpl.Strategy _strategy;
        private final int _minPoolSize;

        private ChannelPoolFactoryImpl(Bootstrap bootstrap, int maxPoolSize, long idleTimeout, int maxPoolWaiterSize, AsyncPoolImpl.Strategy strategy, int minPoolSize) {
            this._bootstrap = bootstrap;
            this._maxPoolSize = maxPoolSize;
            this._idleTimeout = idleTimeout;
            this._maxPoolWaiterSize = maxPoolWaiterSize;
            this._strategy = strategy;
            this._minPoolSize = minPoolSize;
        }

        @Override
        public AsyncPool<Channel> getPool(SocketAddress address) {
            return new AsyncPoolImpl(address.toString() + " HTTP connection pool", (AsyncPool.Lifecycle)new ChannelPoolLifecycle(address, this._bootstrap, HttpNettyClient.this._allChannels, false), this._maxPoolSize, this._idleTimeout, HttpNettyClient.this._scheduler, this._maxPoolWaiterSize, this._strategy, this._minPoolSize, (RateLimiter)new ExponentialBackOffRateLimiter(0L, HttpNettyClient.this._requestTimeout / 2L, Math.max(10L, HttpNettyClient.this._requestTimeout / 32L), HttpNettyClient.this._scheduler, HttpNettyClient.this._maxConcurrentConnections));
        }
    }

    private class HttpClientPipelineInitializer
    extends ChannelInitializer<NioSocketChannel> {
        private final SSLContext _sslContext;
        private final SSLParameters _sslParameters;

        public HttpClientPipelineInitializer(SSLContext sslContext, SSLParameters sslParameters) {
            if (sslParameters != null) {
                if (sslContext == null) {
                    throw new IllegalArgumentException("SSLParameters passed with no SSLContext");
                }
                SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
                if (sslParameters.getCipherSuites() != null) {
                    this.checkContained(supportedSSLParameters.getCipherSuites(), sslParameters.getCipherSuites(), "cipher suite");
                }
                if (sslParameters.getProtocols() != null) {
                    this.checkContained(supportedSSLParameters.getProtocols(), sslParameters.getProtocols(), "protocol");
                }
            }
            this._sslContext = sslContext;
            this._sslParameters = sslParameters;
        }

        private void checkContained(String[] containingArray, String[] containedArray, String valueName) {
            HashSet<String> containingSet = new HashSet<String>(Arrays.asList(containingArray));
            HashSet<String> containedSet = new HashSet<String>(Arrays.asList(containedArray));
            boolean changed = containedSet.removeAll(containingSet);
            if (!changed) {
                throw new IllegalArgumentException("None of the requested " + valueName + "s: " + containedSet + " are found in SSLContext");
            }
            if (!containedSet.isEmpty()) {
                for (String paramValue : containedSet) {
                    LOG.warn("{} {} requested but not found in SSLContext", (Object)valueName, (Object)paramValue);
                }
            }
        }

        protected void initChannel(NioSocketChannel ch) throws Exception {
            ch.pipeline().addLast("codec", (ChannelHandler)new HttpClientCodec(4096, HttpNettyClient.this._maxHeaderSize, HttpNettyClient.this._maxChunkSize));
            ch.pipeline().addLast("dechunker", (ChannelHandler)new HttpObjectAggregator(HttpNettyClient.this._maxResponseSize));
            ch.pipeline().addLast("rapiCodec", (ChannelHandler)new RAPClientCodec());
            ch.pipeline().addLast("responseHandler", (ChannelHandler)HttpNettyClient.this._responseHandler);
            if (this._sslContext != null) {
                ch.pipeline().addLast("sslRequestHandler", (ChannelHandler)new SslRequestHandler(this._sslContext, this._sslParameters));
            }
            ch.pipeline().addLast("channelManager", (ChannelHandler)HttpNettyClient.this._handler);
        }
    }

    private static enum State {
        RUNNING,
        SHUTTING_DOWN,
        REQUESTS_STOPPING,
        SHUTDOWN;

    }
}

