/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.AbstractNettyStreamClient;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.ChannelPoolLifecycle;
import com.linkedin.r2.transport.http.client.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.ChannelPoolStreamHandler;
import com.linkedin.r2.transport.http.client.ExponentialBackOffRateLimiter;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.PoolStatsProvider;
import com.linkedin.r2.transport.http.client.RAPClientPipelineInitializer;
import com.linkedin.r2.transport.http.client.RAPResponseDecoder;
import com.linkedin.r2.transport.http.client.RAPStreamResponseHandler;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.transport.http.client.TimeoutCallback;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.util.Cancellable;
import com.linkedin.r2.util.Timeout;
import com.linkedin.r2.util.TimeoutRunnable;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelGroupFutureListener;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpNettyStreamClient
extends AbstractNettyStreamClient {
    static final Logger LOG = LoggerFactory.getLogger(HttpNettyStreamClient.class);
    private final ChannelPoolManager _channelPoolManager;

    public HttpNettyStreamClient(NioEventLoopGroup eventLoopGroup, ScheduledExecutorService executor, int poolSize, long requestTimeout, long idleTimeout, long shutdownTimeout, long maxResponseSize, SSLContext sslContext, SSLParameters sslParameters, ExecutorService callbackExecutors, int poolWaiterSize, String name, AbstractJmxManager jmxManager, AsyncPoolImpl.Strategy strategy, int minPoolSize, int maxHeaderSize, int maxChunkSize, int maxConcurrentConnections, boolean tcpNoDelay) {
        super(eventLoopGroup, executor, requestTimeout, shutdownTimeout, maxResponseSize, callbackExecutors, jmxManager, maxConcurrentConnections);
        RAPClientPipelineInitializer initializer = new RAPClientPipelineInitializer(sslContext, sslParameters, maxHeaderSize, maxChunkSize, maxResponseSize);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)initializer);
        this._channelPoolManager = new ChannelPoolManager(new ChannelPoolFactoryImpl(bootstrap, poolSize, idleTimeout, poolWaiterSize, strategy, minPoolSize, tcpNoDelay), name + "ChannelPools");
        this._jmxManager.onProviderCreate((PoolStatsProvider)this._channelPoolManager);
    }

    HttpNettyStreamClient(ChannelPoolFactory factory, ScheduledExecutorService executor, int requestTimeout, int shutdownTimeout, long maxResponseSize) {
        super(factory, executor, requestTimeout, shutdownTimeout, maxResponseSize);
        this._channelPoolManager = new ChannelPoolManager(factory);
        this._jmxManager.onProviderCreate((PoolStatsProvider)this._channelPoolManager);
    }

    @Override
    public Map<String, PoolStats> getPoolStats() {
        return this._channelPoolManager.getPoolStats();
    }

    @Override
    protected void doShutdown(Callback<None> callback) {
        long deadline = System.currentTimeMillis() + this._shutdownTimeout;
        ChannelPoolShutdownCallback closeChannelsCallback = new ChannelPoolShutdownCallback(this._scheduler, this._shutdownTimeout, TimeUnit.MILLISECONDS, deadline, callback);
        this._channelPoolManager.shutdown((Callback<None>)closeChannelsCallback);
        this._jmxManager.onProviderShutdown((PoolStatsProvider)this._channelPoolManager);
    }

    @Override
    protected void doWriteRequest(Request request, RequestContext context, SocketAddress address, TimeoutTransportCallback<StreamResponse> callback) {
        AsyncPool<Channel> pool;
        try {
            pool = this._channelPoolManager.getPoolForAddress(address);
        }
        catch (IllegalStateException e) {
            HttpNettyStreamClient.errorResponse(callback, e);
            return;
        }
        context.putLocalAttr("HTTP_PROTOCOL_VERSION", (Object)HttpProtocolVersion.HTTP_1_1);
        ChannelPoolGetCallback getCallback = new ChannelPoolGetCallback(pool, request, callback);
        Cancellable pendingGet = pool.get((Callback)getCallback);
        if (pendingGet != null) {
            callback.addTimeoutTask(() -> pendingGet.cancel());
        }
    }

    private class ChannelPoolShutdownCallback
    extends TimeoutCallback<None> {
        public ChannelPoolShutdownCallback(final ScheduledExecutorService scheduler, long timeout, TimeUnit timeoutUnit, final long deadline, final Callback<None> callback) {
            super(scheduler, timeout, timeoutUnit, (Callback)new Callback<None>(){

                private void finishShutdown() {
                    HttpNettyStreamClient.this._state.set(AbstractNettyStreamClient.State.REQUESTS_STOPPING);
                    for (Callback<Channel> callback2 : HttpNettyStreamClient.this._channelPoolManager.cancelWaiters()) {
                        callback2.onError((Throwable)new TimeoutException("Operation did not complete before shutdown"));
                    }
                    for (Channel c : HttpNettyStreamClient.this._allChannels) {
                        TransportCallback callback3 = (TransportCallback)c.attr(RAPStreamResponseHandler.CALLBACK_ATTR_KEY).getAndRemove();
                        if (callback3 == null) continue;
                        AbstractNettyStreamClient.errorResponse(callback3, new TimeoutException("Operation did not complete before shutdown"));
                    }
                    final TimeoutRunnable afterClose = new TimeoutRunnable(scheduler, deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS, () -> {
                        HttpNettyStreamClient.this._state.set(AbstractNettyStreamClient.State.SHUTDOWN);
                        LOG.info("Shutdown complete");
                        callback.onSuccess((Object)None.none());
                    }, "Timed out waiting for channels to close, continuing shutdown");
                    HttpNettyStreamClient.this._allChannels.close().addListener((GenericFutureListener)new ChannelGroupFutureListener(){

                        public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                            if (!channelGroupFuture.isSuccess()) {
                                LOG.warn("Failed to close some connections, ignoring");
                            }
                            afterClose.run();
                        }
                    });
                }

                public void onSuccess(None none) {
                    LOG.info("All connection pools shut down, closing all channels");
                    this.finishShutdown();
                }

                public void onError(Throwable e) {
                    LOG.warn("Error shutting down HTTP connection pools, ignoring and continuing shutdown", e);
                    this.finishShutdown();
                }
            }, "Connection pool shutdown timeout exceeded (" + HttpNettyStreamClient.this._shutdownTimeout + "ms)");
        }
    }

    private class ChannelPoolGetCallback
    implements Callback<Channel> {
        private final AsyncPool<Channel> _pool;
        private final Request _request;
        private final TimeoutTransportCallback<StreamResponse> _callback;

        ChannelPoolGetCallback(AsyncPool<Channel> pool, Request request, TimeoutTransportCallback<StreamResponse> callback) {
            this._pool = pool;
            this._request = request;
            this._callback = callback;
        }

        public void onSuccess(Channel channel) {
            channel.attr(ChannelPoolStreamHandler.CHANNEL_POOL_ATTR_KEY).set(this._pool);
            this._callback.addTimeoutTask(() -> {
                AsyncPool pool = (AsyncPool)channel.attr(ChannelPoolStreamHandler.CHANNEL_POOL_ATTR_KEY).getAndRemove();
                if (pool != null) {
                    pool.dispose((Object)channel);
                }
            });
            Timeout streamingTimeout = new Timeout(HttpNettyStreamClient.this._scheduler, HttpNettyStreamClient.this._requestTimeout, TimeUnit.MILLISECONDS, (Object)None.none());
            this._callback.addTimeoutTask(() -> {
                Timeout timeout = (Timeout)channel.attr(RAPResponseDecoder.TIMEOUT_ATTR_KEY).getAndRemove();
                if (timeout != null) {
                    timeout.getItem();
                }
            });
            channel.attr(RAPStreamResponseHandler.CALLBACK_ATTR_KEY).set(this._callback);
            channel.attr(RAPResponseDecoder.TIMEOUT_ATTR_KEY).set((Object)streamingTimeout);
            AbstractNettyStreamClient.State state = (AbstractNettyStreamClient.State)((Object)HttpNettyStreamClient.this._state.get());
            if (state == AbstractNettyStreamClient.State.REQUESTS_STOPPING || state == AbstractNettyStreamClient.State.SHUTDOWN) {
                this._callback.onResponse(TransportResponseImpl.error((Throwable)new TimeoutException("Operation did not complete before shutdown")));
                return;
            }
            channel.writeAndFlush((Object)this._request).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }

        public void onError(Throwable e) {
            this._callback.onResponse(TransportResponseImpl.error((Throwable)e));
        }
    }

    private class ChannelPoolFactoryImpl
    implements ChannelPoolFactory {
        private final Bootstrap _bootstrap;
        private final int _maxPoolSize;
        private final long _idleTimeout;
        private final int _maxPoolWaiterSize;
        private final AsyncPoolImpl.Strategy _strategy;
        private final int _minPoolSize;
        private final boolean _tcpNoDelay;

        private ChannelPoolFactoryImpl(Bootstrap bootstrap, int maxPoolSize, long idleTimeout, int maxPoolWaiterSize, AsyncPoolImpl.Strategy strategy, int minPoolSize, boolean tcpNoDelay) {
            this._bootstrap = bootstrap;
            this._maxPoolSize = maxPoolSize;
            this._idleTimeout = idleTimeout;
            this._maxPoolWaiterSize = maxPoolWaiterSize;
            this._strategy = strategy;
            this._minPoolSize = minPoolSize;
            this._tcpNoDelay = tcpNoDelay;
        }

        @Override
        public AsyncPool<Channel> getPool(SocketAddress address) {
            return new AsyncPoolImpl(address.toString() + " HTTP connection pool", (AsyncPool.Lifecycle)new ChannelPoolLifecycle(address, this._bootstrap, HttpNettyStreamClient.this._allChannels, this._tcpNoDelay), this._maxPoolSize, this._idleTimeout, HttpNettyStreamClient.this._scheduler, this._maxPoolWaiterSize, this._strategy, this._minPoolSize, (RateLimiter)new ExponentialBackOffRateLimiter(0L, HttpNettyStreamClient.this._requestTimeout / 2L, Math.max(10L, HttpNettyStreamClient.this._requestTimeout / 32L), HttpNettyStreamClient.this._scheduler, HttpNettyStreamClient.this._maxConcurrentConnections));
        }
    }
}

