/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;

public class ConfigClientCache {
    private static final Cache<VersionStabilityPolicy, ConfigClient> CONFIG_CLIENTS_CACHE = CacheBuilder.newBuilder().maximumSize((long)VersionStabilityPolicy.values().length).build();

    public static ConfigClient getClient(final VersionStabilityPolicy policy) {
        try {
            return (ConfigClient)CONFIG_CLIENTS_CACHE.get((Object)policy, (Callable)new Callable<ConfigClient>(){

                @Override
                public ConfigClient call() throws Exception {
                    return ConfigClient.createConfigClient(policy);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get Config client", e);
        }
    }
}

