/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.converter.AvroHttpJoinConverter;
import org.apache.gobblin.http.ApacheHttpAsyncClient;
import org.apache.gobblin.http.ApacheHttpRequestBuilder;
import org.apache.gobblin.http.ApacheHttpResponseHandler;
import org.apache.gobblin.http.ApacheHttpResponseStatus;
import org.apache.gobblin.http.HttpRequestResponseRecord;
import org.apache.gobblin.http.ResponseStatus;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroApacheHttpJoinConverter
extends AvroHttpJoinConverter<HttpUriRequest, HttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(AvroApacheHttpJoinConverter.class);

    public ApacheHttpAsyncClient createHttpClient(Config config, SharedResourcesBroker<GobblinScopeTypes> broker) {
        return new ApacheHttpAsyncClient(HttpAsyncClientBuilder.create(), config, broker);
    }

    public ApacheHttpResponseHandler createResponseHandler(Config config) {
        return new ApacheHttpResponseHandler();
    }

    protected ApacheHttpRequestBuilder createRequestBuilder(Config config) {
        String urlTemplate = config.getString("urlTemplate");
        String verb = config.getString("verb");
        String contentType = config.getString("contentType");
        return new ApacheHttpRequestBuilder(urlTemplate, verb, contentType);
    }

    @Override
    protected void fillHttpOutputData(Schema httpOutputSchema, GenericRecord outputRecord, HttpUriRequest rawRequest, ResponseStatus status) throws IOException {
        ApacheHttpResponseStatus apacheStatus = (ApacheHttpResponseStatus)status;
        HttpRequestResponseRecord record = new HttpRequestResponseRecord();
        record.setRequestUrl(rawRequest.getURI().toASCIIString());
        record.setMethod(rawRequest.getMethod());
        record.setStatusCode(apacheStatus.getStatusCode());
        record.setContentType(apacheStatus.getContentType());
        record.setBody(apacheStatus.getContent() == null ? null : ByteBuffer.wrap(apacheStatus.getContent()));
        outputRecord.put("HttpRequestResponse", (Object)record);
    }
}

