/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.http;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.http.ThrottledHttpClient;
import org.apache.gobblin.utils.HttpUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClient
extends ThrottledHttpClient<HttpUriRequest, CloseableHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpClient.class);
    public static final String HTTP_CONN_MANAGER = "connMgrType";
    public static final String POOLING_CONN_MANAGER_MAX_TOTAL_CONN = "connMgr.pooling.maxTotalConn";
    public static final String POOLING_CONN_MANAGER_MAX_PER_CONN = "connMgr.pooling.maxPerConn";
    public static final String REQUEST_TIME_OUT_MS_KEY = "reqTimeout";
    public static final String CONNECTION_TIME_OUT_MS_KEY = "connTimeout";
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"reqTimeout", (Object)TimeUnit.SECONDS.toMillis(10L)).put((Object)"connTimeout", (Object)TimeUnit.SECONDS.toMillis(10L)).put((Object)"connMgrType", (Object)ConnManager.BASIC.name()).put((Object)"connMgr.pooling.maxTotalConn", (Object)20).put((Object)"connMgr.pooling.maxPerConn", (Object)2).build());
    private final CloseableHttpClient client;

    public ApacheHttpClient(HttpClientBuilder builder, Config config, SharedResourcesBroker<GobblinScopeTypes> broker) {
        super(broker, HttpUtils.createApacheHttpClientLimiterKey(config));
        config = config.withFallback((ConfigMergeable)FALLBACK);
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(config.getInt(REQUEST_TIME_OUT_MS_KEY)).setConnectTimeout(config.getInt(CONNECTION_TIME_OUT_MS_KEY)).setConnectionRequestTimeout(config.getInt(CONNECTION_TIME_OUT_MS_KEY)).build();
        builder.disableCookieManagement().useSystemProperties().setDefaultRequestConfig(requestConfig);
        builder.setConnectionManager(this.getHttpConnManager(config));
        this.client = builder.build();
    }

    @Override
    public CloseableHttpResponse sendRequestImpl(HttpUriRequest request) throws IOException {
        return this.client.execute(request);
    }

    @Override
    public void sendAsyncRequestImpl(HttpUriRequest request, Callback<CloseableHttpResponse> callback) throws IOException {
        throw new UnsupportedOperationException("ApacheHttpClient doesn't support asynchronous send");
    }

    private HttpClientConnectionManager getHttpConnManager(Config config) {
        BasicHttpClientConnectionManager httpConnManager;
        String connMgrStr = config.getString(HTTP_CONN_MANAGER);
        switch (ConnManager.valueOf(connMgrStr.toUpperCase())) {
            case BASIC: {
                httpConnManager = new BasicHttpClientConnectionManager();
                break;
            }
            case POOLING: {
                PoolingHttpClientConnectionManager poolingConnMgr = new PoolingHttpClientConnectionManager();
                poolingConnMgr.setMaxTotal(config.getInt(POOLING_CONN_MANAGER_MAX_TOTAL_CONN));
                poolingConnMgr.setDefaultMaxPerRoute(config.getInt(POOLING_CONN_MANAGER_MAX_PER_CONN));
                httpConnManager = poolingConnMgr;
                break;
            }
            default: {
                throw new IllegalArgumentException(connMgrStr + " is not supported");
            }
        }
        LOG.info("Using " + httpConnManager.getClass().getSimpleName());
        return httpConnManager;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public static enum ConnManager {
        POOLING,
        BASIC;

    }
}

