/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.r2;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.D2ClientBuilder;
import com.linkedin.d2.balancer.Facilities;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class D2ClientProxy
implements D2Client {
    private final D2Client d2Client;
    private final Collection<TransportClientFactory> clientFactories;

    D2ClientProxy(D2ClientBuilder builder, boolean isSSLEnabled) {
        if (isSSLEnabled) {
            Map<String, TransportClientFactory> factoryMap = D2ClientProxy.createTransportClientFactories();
            builder.setClientFactories(factoryMap);
            this.clientFactories = factoryMap.values();
        } else {
            this.clientFactories = new ArrayList<TransportClientFactory>();
        }
        this.d2Client = this.buildClient(builder);
    }

    public Facilities getFacilities() {
        return this.d2Client.getFacilities();
    }

    public void start(Callback<None> callback) {
        this.d2Client.start(callback);
    }

    public Future<RestResponse> restRequest(RestRequest request) {
        return this.d2Client.restRequest(request);
    }

    public Future<RestResponse> restRequest(RestRequest request, RequestContext requestContext) {
        return this.d2Client.restRequest(request, requestContext);
    }

    public void restRequest(RestRequest request, Callback<RestResponse> callback) {
        this.d2Client.restRequest(request, callback);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        this.d2Client.restRequest(request, requestContext, callback);
    }

    public void streamRequest(StreamRequest request, Callback<StreamResponse> callback) {
        this.d2Client.streamRequest(request, callback);
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
        this.d2Client.streamRequest(request, requestContext, callback);
    }

    public Map<String, Object> getMetadata(URI uri) {
        return this.d2Client.getMetadata(uri);
    }

    public void shutdown(Callback<None> callback) {
        this.d2Client.shutdown(callback);
        for (TransportClientFactory clientFactory : this.clientFactories) {
            clientFactory.shutdown((Callback)new FutureCallback());
        }
    }

    private D2Client buildClient(D2ClientBuilder builder) {
        D2Client d2 = builder.build();
        final SettableFuture d2ClientFuture = SettableFuture.create();
        d2.start((Callback)new Callback<None>(){

            public void onError(Throwable e) {
                d2ClientFuture.setException(e);
            }

            public void onSuccess(None none) {
                d2ClientFuture.set((Object)none);
            }
        });
        try {
            d2ClientFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return d2;
    }

    private static Map<String, TransportClientFactory> createTransportClientFactories() {
        return ImmutableMap.builder().put((Object)"http", (Object)new HttpClientFactory()).put((Object)"https", (Object)new HttpClientFactory()).build();
    }
}

