/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.collect.ImmutableMap;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.transport.common.Client;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.r2.R2Client;
import org.apache.gobblin.r2.R2ClientFactory;
import org.apache.gobblin.r2.R2RestRequestBuilder;
import org.apache.gobblin.r2.R2RestResponseHandler;
import org.apache.gobblin.utils.HttpUtils;
import org.apache.gobblin.writer.AsyncHttpWriterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RestWriterBuilder
extends AsyncHttpWriterBuilder<GenericRecord, RestRequest, RestResponse> {
    private static final Logger log = LoggerFactory.getLogger(R2RestWriterBuilder.class);
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"protocolVersion", (Object)"2.0.0").build());

    public R2RestWriterBuilder fromConfig(Config config) {
        config = config.withFallback((ConfigMergeable)FALLBACK);
        this.client = this.createClient(config);
        String urlTemplate = config.getString("urlTemplate");
        String verb = config.getString("verb");
        String protocolVersion = config.getString("protocolVersion");
        this.asyncRequestBuilder = new R2RestRequestBuilder(urlTemplate, verb, protocolVersion);
        Set<String> errorCodeWhitelist = HttpUtils.getErrorCodeWhitelist(config);
        this.responseHandler = new R2RestResponseHandler(errorCodeWhitelist, this.metricContext);
        return this;
    }

    protected R2Client createClient(Config config) {
        String urlTemplate = config.getString("urlTemplate");
        R2ClientFactory.Schema schema = R2ClientFactory.Schema.HTTP;
        if (urlTemplate.startsWith("d2://")) {
            schema = R2ClientFactory.Schema.D2;
        }
        R2ClientFactory factory = new R2ClientFactory(schema);
        Client client = factory.createInstance(config);
        return new R2Client(client, config, this.getBroker());
    }
}

