/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.google.common.collect.Sets;
import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.transport.common.Client;
import com.linkedin.r2.transport.common.bridge.client.TransportClientAdapter;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.restli.client.BatchGetKVRequest;
import com.linkedin.restli.client.ErrorHandlingBehavior;
import com.linkedin.restli.client.GetRequest;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestClient;
import com.linkedin.restli.client.response.BatchKVResponse;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.EmptyRecord;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.gobblin.rest.JobExecutionQuery;
import org.apache.gobblin.rest.JobExecutionQueryResult;
import org.apache.gobblin.rest.JobExecutionsBatchGetBuilder;
import org.apache.gobblin.rest.JobExecutionsBuilders;
import org.apache.gobblin.rest.JobExecutionsGetBuilder;

public class JobExecutionInfoClient
implements Closeable {
    private final HttpClientFactory httpClientFactory = new HttpClientFactory();
    protected final RestClient restClient;

    public JobExecutionInfoClient(String serverUri) {
        TransportClientAdapter r2Client = new TransportClientAdapter(this.httpClientFactory.getClient(Collections.emptyMap()));
        this.restClient = new RestClient((Client)r2Client, serverUri);
    }

    public JobExecutionQueryResult get(JobExecutionQuery query) throws RemoteInvocationException {
        GetRequest getRequest = ((JobExecutionsGetBuilder)new JobExecutionsBuilders().get().id((Object)new ComplexResourceKey((RecordTemplate)query, (RecordTemplate)new EmptyRecord()))).build();
        Response response = this.restClient.sendRequest((Request)getRequest, ErrorHandlingBehavior.TREAT_SERVER_ERROR_AS_SUCCESS).getResponse();
        return (JobExecutionQueryResult)response.getEntity();
    }

    public Collection<JobExecutionQueryResult> batchGet(Collection<JobExecutionQuery> queries) throws RemoteInvocationException {
        HashSet ids = Sets.newHashSet();
        for (JobExecutionQuery query : queries) {
            ids.add(new ComplexResourceKey((RecordTemplate)query, (RecordTemplate)new EmptyRecord()));
        }
        BatchGetKVRequest batchGetRequest = ((JobExecutionsBatchGetBuilder)new JobExecutionsBuilders().batchGet().ids((Collection)ids)).buildKV();
        BatchKVResponse response = (BatchKVResponse)this.restClient.sendRequest((Request)batchGetRequest, ErrorHandlingBehavior.TREAT_SERVER_ERROR_AS_SUCCESS).getResponseEntity();
        return response.getResults().values();
    }

    @Override
    public void close() throws IOException {
        this.restClient.shutdown((Callback)new FutureCallback());
        this.httpClientFactory.shutdown((Callback)new FutureCallback());
    }
}

