/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.Tuple3Task;
import com.linkedin.parseq.function.Tuple3;
import com.linkedin.parseq.function.Tuples;
import com.linkedin.parseq.internal.InternalUtil;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;

public class Par3Task<T1, T2, T3>
extends BaseTask<Tuple3<T1, T2, T3>>
implements Tuple3Task<T1, T2, T3> {
    private final Tuple3<Task<T1>, Task<T2>, Task<T3>> _tasks;

    public Par3Task(String name, Task<T1> task1, Task<T2> task2, Task<T3> task3) {
        super(name);
        this._tasks = Tuples.tuple(task1, task2, task3);
    }

    @Override
    protected Promise<Tuple3<T1, T2, T3>> run(Context context) throws Exception {
        SettablePromise<Tuple3<T1, T2, T3>> result = Promises.settable();
        InternalUtil.fastFailAfter(p -> {
            if (p.isFailed()) {
                result.fail(p.getError());
            } else {
                result.done(Tuples.tuple(this._tasks._1().get(), this._tasks._2().get(), this._tasks._3().get()));
            }
        }, this._tasks._1(), this._tasks._2(), this._tasks._3());
        this._tasks.forEach(t -> context.run((Task)t));
        return result;
    }
}

