/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace;

import com.linkedin.parseq.trace.Relationship;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceRelationship;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class TraceBuilder {
    static final long UNKNOWN_PLAN_ID = -1L;
    static final String UNKNOWN_PLAN_CLASS = "unknown";
    private final int _maxRelationshipsPerTrace;
    private final String _planClass;
    private final Long _planId;
    private final LinkedHashSet<TraceRelationship> _relationships = new LinkedHashSet();
    private final Map<Long, RefCounted<ShallowTraceBuilder>> _traceBuilders = new HashMap<Long, RefCounted<ShallowTraceBuilder>>();

    public TraceBuilder(int maxRelationshipsCount) {
        this(maxRelationshipsCount, UNKNOWN_PLAN_CLASS, -1L);
    }

    public TraceBuilder(int maxRelationshipsCount, String planClass, Long planId) {
        this._maxRelationshipsPerTrace = maxRelationshipsCount;
        this._planClass = planClass;
        this._planId = planId;
    }

    public synchronized void addShallowTrace(ShallowTraceBuilder shallowTrace) {
        this._traceBuilders.putIfAbsent(shallowTrace.getId(), new RefCounted<ShallowTraceBuilder>(0, shallowTrace));
    }

    public synchronized void addRelationship(Relationship relationship, ShallowTraceBuilder from, ShallowTraceBuilder to) {
        if (this._relationships.size() == this._maxRelationshipsPerTrace) {
            TraceRelationship r = (TraceRelationship)this._relationships.iterator().next();
            this._relationships.remove(r);
            this.decreaseRefCount(r.getFrom());
            this.decreaseRefCount(r.getTo());
        }
        this.addShallowTrace(from);
        this.addShallowTrace(to);
        TraceRelationship rel = new TraceRelationship(from.getId(), to.getId(), relationship);
        this._relationships.add(rel);
        this.increaseRefCount(from.getId());
        this.increaseRefCount(to.getId());
    }

    private void decreaseRefCount(Long id) {
        RefCounted<ShallowTraceBuilder> traceBuilderRefCount = this._traceBuilders.get(id);
        --traceBuilderRefCount._refCount;
        if (traceBuilderRefCount._refCount == 0) {
            this._traceBuilders.remove(id);
        }
    }

    private void increaseRefCount(Long id) {
        ++this._traceBuilders.get((Object)id)._refCount;
    }

    public synchronized boolean containsRelationship(TraceRelationship relationship) {
        return this._relationships.contains(relationship);
    }

    public synchronized Trace build() {
        HashMap<Long, ShallowTrace> traceMap = new HashMap<Long, ShallowTrace>();
        HashSet<TraceRelationship> relationships = new HashSet<TraceRelationship>();
        for (Map.Entry<Long, RefCounted<ShallowTraceBuilder>> entry : this._traceBuilders.entrySet()) {
            traceMap.put(entry.getKey(), ((ShallowTraceBuilder)entry.getValue()._value).build());
        }
        block9: for (TraceRelationship rel : this._relationships) {
            switch (rel.getRelationhsip()) {
                case SUCCESSOR_OF: {
                    relationships.remove(new TraceRelationship(rel.getFrom(), rel.getTo(), Relationship.POSSIBLE_SUCCESSOR_OF));
                    relationships.add(rel);
                    continue block9;
                }
                case POSSIBLE_SUCCESSOR_OF: {
                    if (relationships.contains(new TraceRelationship(rel.getFrom(), rel.getTo(), Relationship.SUCCESSOR_OF))) continue block9;
                    relationships.add(rel);
                    continue block9;
                }
                case CHILD_OF: {
                    relationships.remove(new TraceRelationship(rel.getTo(), rel.getFrom(), Relationship.POTENTIAL_PARENT_OF));
                    relationships.add(new TraceRelationship(rel.getTo(), rel.getFrom(), Relationship.PARENT_OF));
                    continue block9;
                }
                case POTENTIAL_CHILD_OF: {
                    if (relationships.contains(new TraceRelationship(rel.getTo(), rel.getFrom(), Relationship.PARENT_OF))) continue block9;
                    relationships.add(new TraceRelationship(rel.getTo(), rel.getFrom(), Relationship.POTENTIAL_PARENT_OF));
                    continue block9;
                }
                case POTENTIAL_PARENT_OF: {
                    if (relationships.contains(new TraceRelationship(rel.getFrom(), rel.getTo(), Relationship.PARENT_OF))) continue block9;
                    relationships.add(rel);
                    continue block9;
                }
                case PARENT_OF: {
                    relationships.remove(new TraceRelationship(rel.getFrom(), rel.getTo(), Relationship.POTENTIAL_PARENT_OF));
                    relationships.add(rel);
                    continue block9;
                }
            }
            throw new IllegalStateException("Unknown relationship type: " + rel);
        }
        return new Trace(traceMap, relationships, this._planClass, this._planId);
    }

    private static class RefCounted<T> {
        int _refCount;
        T _value;

        public RefCounted(int refCount, T value) {
            this._refCount = refCount;
            this._value = value;
        }
    }
}

