/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.filter;

import com.linkedin.restli.internal.server.RestLiCallback;
import com.linkedin.restli.internal.server.filter.FilterChainCallback;
import com.linkedin.restli.internal.server.filter.RestLiFilterChainIterator;
import com.linkedin.restli.internal.server.filter.RestLiFilterResponseContextFactory;
import com.linkedin.restli.server.RestLiResponseAttachments;
import com.linkedin.restli.server.filter.Filter;
import com.linkedin.restli.server.filter.FilterRequestContext;
import com.linkedin.restli.server.filter.FilterResponseContext;
import java.util.Collections;
import java.util.List;

public class RestLiFilterChain {
    private final List<Filter> _filters;
    private final RestLiFilterChainIterator _filterChainIterator;

    public RestLiFilterChain(List<Filter> filters, FilterChainCallback filterChainCallback) {
        this._filters = filters == null ? Collections.emptyList() : filters;
        this._filterChainIterator = new RestLiFilterChainIterator(this._filters, filterChainCallback);
    }

    public RestLiFilterChain(FilterChainCallback filterChainCallback) {
        this(null, filterChainCallback);
    }

    public void onRequest(FilterRequestContext requestContext, RestLiFilterResponseContextFactory filterResponseContextFactory) {
        this._filterChainIterator.onRequest(requestContext, filterResponseContextFactory, new RestLiCallback<Object>(requestContext, filterResponseContextFactory, this));
    }

    public void onResponse(FilterRequestContext requestContext, FilterResponseContext responseContext, RestLiResponseAttachments responseAttachments) {
        this._filterChainIterator.onResponse(requestContext, responseContext, responseAttachments);
    }

    public void onError(Throwable th, FilterRequestContext requestContext, FilterResponseContext responseContext, RestLiResponseAttachments responseAttachments) {
        this._filterChainIterator.onError(th, requestContext, responseContext, responseAttachments);
    }
}

