/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.filter;

import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.common.HeaderUtil;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.response.RestLiResponseHandler;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.RoutingException;
import com.linkedin.restli.server.filter.FilterResponseContext;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class RestLiFilterResponseContextFactory<T> {
    private final RoutingResult _method;
    private final RestLiResponseHandler _responseHandler;
    private final RestRequest _request;

    public RestLiFilterResponseContextFactory(RestRequest request, RoutingResult method, RestLiResponseHandler responseHandler) {
        this._request = request;
        this._method = method;
        this._responseHandler = responseHandler;
    }

    public FilterResponseContext fromResult(T result) throws IOException {
        final RestLiResponseData responseData = this._responseHandler.buildRestLiResponseData(this._request, this._method, result);
        return new FilterResponseContext(){

            @Override
            public RestLiResponseData getResponseData() {
                return responseData;
            }
        };
    }

    public FilterResponseContext fromThrowable(Throwable throwable) {
        RestLiServiceException restLiServiceException;
        if (throwable instanceof RestLiServiceException) {
            restLiServiceException = (RestLiServiceException)throwable;
        } else if (throwable instanceof RoutingException) {
            RoutingException routingException = (RoutingException)throwable;
            restLiServiceException = new RestLiServiceException(HttpStatus.fromCode((int)routingException.getStatus()), routingException.getMessage(), routingException);
        } else {
            restLiServiceException = new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, throwable.getMessage(), throwable);
        }
        Map requestHeaders = this._request.getHeaders();
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        headers.put("X-RestLi-Protocol-Version", ProtocolVersionUtil.extractProtocolVersion((Map)requestHeaders).toString());
        headers.put(HeaderUtil.getErrorResponseHeaderName((Map)requestHeaders), "true");
        final RestLiResponseData responseData = this._responseHandler.buildExceptionResponseData(this._request, this._method, restLiServiceException, headers, Collections.emptyList());
        return new FilterResponseContext(){

            @Override
            public RestLiResponseData getResponseData() {
                return responseData;
            }
        };
    }
}

