/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.BatchResponse;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.UpdateStatus;
import com.linkedin.restli.internal.common.URIParamUtils;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.methods.AnyRecord;
import com.linkedin.restli.internal.server.response.BatchResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchUpdateResponseEnvelope;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.ResponseUtils;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.server.BatchUpdateResult;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BatchUpdateResponseBuilder
implements RestLiResponseBuilder {
    private final ErrorResponseBuilder _errorResponseBuilder;

    public BatchUpdateResponseBuilder(ErrorResponseBuilder errorResponseBuilder) {
        this._errorResponseBuilder = errorResponseBuilder;
    }

    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        HashMap<Object, UpdateStatus> mergedResults = new HashMap<Object, UpdateStatus>();
        Map<Object, BatchResponseEnvelope.BatchResponseEntry> responses = responseData.getBatchResponseEnvelope().getBatchResponseMap();
        this.generateResultEntityResponse(routingResult, responses, mergedResults);
        PartialRestResponse.Builder builder = new PartialRestResponse.Builder();
        ProtocolVersion protocolVersion = ((ServerResourceContext)routingResult.getContext()).getRestliProtocolVersion();
        BatchResponse<AnyRecord> response = BatchUpdateResponseBuilder.toBatchResponse(mergedResults, protocolVersion);
        return builder.entity((RecordTemplate)response).headers(responseData.getHeaders()).cookies(responseData.getCookies()).build();
    }

    private void generateResultEntityResponse(RoutingResult routingResult, Map<Object, BatchResponseEnvelope.BatchResponseEntry> responses, Map<Object, UpdateStatus> mergedResults) {
        for (Map.Entry<Object, BatchResponseEnvelope.BatchResponseEntry> entry : responses.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null errors Map found inside of the result returned by the resource method: " + routingResult.getResourceMethod());
            }
            UpdateStatus status = entry.getValue().getRecord() instanceof UpdateStatus ? (UpdateStatus)entry.getValue().getRecord() : new UpdateStatus();
            status.setStatus(entry.getValue().getStatus().getCode());
            if (entry.getValue().hasException()) {
                status.setError(this._errorResponseBuilder.buildErrorResponse(entry.getValue().getException()));
            }
            mergedResults.put(entry.getKey(), status);
        }
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object result, Map<String, String> headers, List<HttpCookie> cookies) {
        Object finalKey;
        BatchUpdateResult updateResult = (BatchUpdateResult)result;
        Map results = updateResult.getResults();
        if (results == null) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null Map found inside of the BatchUpdateResult returned by the resource method: " + routingResult.getResourceMethod());
        }
        Map serviceErrors = updateResult.getErrors();
        if (serviceErrors == null) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null errors Map found inside of the BatchUpdateResult returned by the resource method: " + routingResult.getResourceMethod());
        }
        HashMap<Object, BatchResponseEnvelope.BatchResponseEntry> batchResponseMap = new HashMap<Object, BatchResponseEnvelope.BatchResponseEntry>();
        for (Map.Entry entry : results.entrySet()) {
            if (entry.getKey() == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null key inside of the Map returned inside of the BatchUpdateResult returned by the resource method: " + routingResult.getResourceMethod());
            }
            if (serviceErrors.containsKey(entry.getKey())) continue;
            finalKey = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(entry.getKey(), routingResult);
            batchResponseMap.put(finalKey, new BatchResponseEnvelope.BatchResponseEntry(entry.getValue().getStatus(), (RecordTemplate)new UpdateStatus()));
        }
        for (Map.Entry entry : serviceErrors.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null key or value inside of the Map returned inside of the BatchUpdateResult returned by the resource method: " + routingResult.getResourceMethod());
            }
            finalKey = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(entry.getKey(), routingResult);
            batchResponseMap.put(finalKey, new BatchResponseEnvelope.BatchResponseEntry(((RestLiServiceException)entry.getValue()).getStatus(), (RestLiServiceException)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : ((ServerResourceContext)routingResult.getContext()).getBatchKeyErrors().entrySet()) {
            finalKey = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(entry.getKey(), routingResult);
            batchResponseMap.put(finalKey, new BatchResponseEnvelope.BatchResponseEntry(((RestLiServiceException)entry.getValue()).getStatus(), (RestLiServiceException)entry.getValue()));
        }
        RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(HttpStatus.S_200_OK, headers, cookies);
        responseData.setResponseEnvelope(new BatchUpdateResponseEnvelope(batchResponseMap, responseData));
        return responseData;
    }

    private static <K> BatchResponse<AnyRecord> toBatchResponse(Map<K, UpdateStatus> statuses, ProtocolVersion protocolVersion) {
        DataMap splitResponseData = new DataMap();
        DataMap splitStatuses = new DataMap();
        DataMap splitErrors = new DataMap();
        for (Map.Entry<K, UpdateStatus> statusEntry : statuses.entrySet()) {
            DataMap statusData = statusEntry.getValue().data();
            String stringKey = URIParamUtils.encodeKeyForBody(statusEntry.getKey(), (boolean)false, (ProtocolVersion)protocolVersion);
            DataMap error = statusData.getDataMap("error");
            if (error == null) {
                CheckedUtil.putWithoutChecking((CheckedMap)splitStatuses, (Object)stringKey, (Object)statusData);
                continue;
            }
            CheckedUtil.putWithoutChecking((CheckedMap)splitErrors, (Object)stringKey, (Object)error);
        }
        CheckedUtil.putWithoutChecking((CheckedMap)splitResponseData, (Object)"results", (Object)splitStatuses);
        CheckedUtil.putWithoutChecking((CheckedMap)splitResponseData, (Object)"errors", (Object)splitErrors);
        return new BatchResponse(splitResponseData, AnyRecord.class);
    }
}

