/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.util;

import com.linkedin.common.Version;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.InvalidAlternativeKeyException;
import com.linkedin.data.template.KeyCoercer;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.IllegalMaskException;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.URIElementParser;
import com.linkedin.restli.internal.common.URIMaskUtil;
import com.linkedin.restli.internal.common.URLEscaper;
import com.linkedin.restli.internal.common.ValueConverter;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.util.AlternativeKeyCoercerException;
import com.linkedin.restli.internal.server.util.RestLiSyntaxException;
import com.linkedin.restli.server.AlternativeKey;
import com.linkedin.restli.server.Key;
import com.linkedin.restli.server.RoutingException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentUtils {
    private static final Logger _log = LoggerFactory.getLogger(ArgumentUtils.class);
    private static final Pattern SIMPLE_KEY_DELIMETER_PATTERN = Pattern.compile(Pattern.quote(String.valueOf('&')));
    private static final Pattern LEGACY_SIMPLE_KEY_DELIMETER_PATTERN = Pattern.compile(Pattern.quote(";"));
    private static final Pattern KEY_VALUE_DELIMETER_PATTERN = Pattern.compile(Pattern.quote(String.valueOf('=')));
    private static final Pattern LEGACY_KEY_VALUE_DELIMETER_PATTERN = Pattern.compile(Pattern.quote(":"));

    public static Object getResourceKey(RoutingResult routingResult) {
        String keyName = routingResult.getResourceMethod().getResourceModel().getKeyName();
        return routingResult.getContext().getPathKeys().get(keyName);
    }

    public static boolean hasResourceKey(RoutingResult routingResult) {
        return routingResult.getResourceMethod().getResourceModel().getPrimaryKey() != null;
    }

    public static Class<? extends RecordTemplate> getValueClass(RoutingResult routingResult) {
        return routingResult.getResourceMethod().getResourceModel().getValueClass();
    }

    public static Class<?> getKeyClass(RoutingResult invocableMethod) {
        return invocableMethod.getResourceMethod().getResourceModel().getKeyClass();
    }

    public static Map<String, List<String>> getQueryParameters(URI uri) {
        return UriComponent.decodeQuery((URI)uri, (boolean)true);
    }

    public static MaskTree parseProjectionParameter(String projectionParam) throws RestLiSyntaxException {
        if (projectionParam == null) {
            return new MaskTree();
        }
        return ArgumentUtils.decodeMaskUriFormat(projectionParam);
    }

    public static MaskTree decodeMaskUriFormat(String uriParam) throws RestLiSyntaxException {
        try {
            return URIMaskUtil.decodeMaskUriFormat((StringBuilder)new StringBuilder(uriParam));
        }
        catch (IllegalMaskException e) {
            throw new RestLiSyntaxException("error parsing mask", e);
        }
    }

    public static CompoundKey parseCompoundKey(String urlString, Collection<Key> keys, ProtocolVersion version) throws IllegalArgumentException, PathSegment.PathSegmentSyntaxException {
        if (urlString == null || urlString.trim().isEmpty()) {
            return null;
        }
        if (version.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
            return ArgumentUtils.parseCompoundKeyV2(urlString, keys);
        }
        StringBuilder legacyParseError = new StringBuilder();
        StringBuilder currentParseError = new StringBuilder();
        CompoundKey legacyParsedKey = ArgumentUtils.parseCompoundKey(urlString, keys, legacyParseError, LEGACY_SIMPLE_KEY_DELIMETER_PATTERN, LEGACY_KEY_VALUE_DELIMETER_PATTERN);
        CompoundKey currentParsedKey = ArgumentUtils.parseCompoundKey(urlString, keys, currentParseError, SIMPLE_KEY_DELIMETER_PATTERN, KEY_VALUE_DELIMETER_PATTERN);
        if (legacyParsedKey != null && currentParsedKey != null) {
            boolean legacy = legacyParsedKey.getNumParts() > currentParsedKey.getNumParts();
            _log.warn("Ambiguous compound key syntax, using heuristic decision for '{}', legacy: {}", (Object)urlString, (Object)String.valueOf(legacy));
            return legacy ? legacyParsedKey : currentParsedKey;
        }
        if (legacyParsedKey == null && currentParsedKey == null) {
            throw new IllegalArgumentException(currentParseError.toString());
        }
        return currentParsedKey == null ? legacyParsedKey : currentParsedKey;
    }

    private static CompoundKey parseCompoundKeyV2(String urlString, Collection<Key> keys) throws PathSegment.PathSegmentSyntaxException, IllegalArgumentException {
        Object parsedObject = URIElementParser.parse((String)urlString);
        if (parsedObject instanceof DataMap) {
            DataMap dataMap = (DataMap)parsedObject;
            return ArgumentUtils.dataMapToCompoundKey(dataMap, keys);
        }
        throw new PathSegment.PathSegmentSyntaxException(String.format("input '%s' is not a valid CompoundKey", urlString));
    }

    public static CompoundKey dataMapToCompoundKey(DataMap dataMap, Collection<Key> keys) throws IllegalArgumentException {
        CompoundKey compoundKey = new CompoundKey();
        for (Key key : keys) {
            String name = key.getName();
            String value = dataMap.getString(name);
            if (value == null) continue;
            dataMap.remove((Object)name);
            compoundKey.append(name, ArgumentUtils.convertSimpleValue(value, key.getDataSchema(), key.getType()));
        }
        if (!dataMap.isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder();
            for (String leftOverKey : dataMap.keySet()) {
                errorMessageBuilder.append("Unknown key part named '");
                errorMessageBuilder.append(leftOverKey);
                errorMessageBuilder.append("'");
            }
            throw new IllegalArgumentException(errorMessageBuilder.toString());
        }
        return compoundKey;
    }

    public static CompoundKey parseCompoundKey(String urlString, Collection<Key> keys, StringBuilder errorMessageBuilder, Pattern simpleKeyDelimiterPattern, Pattern keyValueDelimiterPattern) throws RoutingException {
        String[] simpleKeys = simpleKeyDelimiterPattern.split(urlString.trim());
        CompoundKey compoundKey = new CompoundKey();
        for (String simpleKey : simpleKeys) {
            String decodedStringValue;
            String name;
            String[] nameValuePair = keyValueDelimiterPattern.split(simpleKey.trim());
            if (simpleKey.trim().length() == 0 || nameValuePair.length != 2) {
                errorMessageBuilder.append("Bad key format '");
                errorMessageBuilder.append(urlString);
                errorMessageBuilder.append("'");
                return null;
            }
            try {
                name = URLDecoder.decode(nameValuePair[0], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RestLiInternalException(e);
            }
            Key currentKey = ArgumentUtils.getKeyWithName(keys, name);
            if (currentKey == null) {
                errorMessageBuilder.append("Unknown key part named '");
                errorMessageBuilder.append(name);
                errorMessageBuilder.append("'");
                return null;
            }
            try {
                decodedStringValue = URLDecoder.decode(nameValuePair[1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RestLiInternalException(e);
            }
            compoundKey.append(name, ArgumentUtils.convertSimpleValue(decodedStringValue, currentKey.getDataSchema(), currentKey.getType()));
        }
        return compoundKey;
    }

    private static Key getKeyWithName(Collection<Key> keys, String keyName) {
        for (Key key : keys) {
            if (!key.getName().equals(keyName)) continue;
            return key;
        }
        return null;
    }

    public static Object parseSimplePathKey(String value, ResourceModel resource, ProtocolVersion version) throws IllegalArgumentException {
        Key key = resource.getPrimaryKey();
        String decodedValue = version.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0 ? UriComponent.decode((String)value, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT) : URLEscaper.unescape((String)value, (URLEscaper.Escaping)URLEscaper.Escaping.URL_ESCAPING);
        return ArgumentUtils.convertSimpleValue(decodedValue, key.getDataSchema(), key.getType());
    }

    public static <K> Object parseAlternativeKey(String value, String altKeyName, ResourceModel resource, ProtocolVersion version) throws IllegalArgumentException {
        if (!resource.getAlternativeKeys().containsKey(altKeyName)) {
            throw new IllegalArgumentException("Resource '" + resource.getName() + "' does not contain alternative key named '" + altKeyName + "'.");
        }
        AlternativeKey<?, ?> alternativeKey = resource.getAlternativeKeys().get(altKeyName);
        String decodedValue = version.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0 ? UriComponent.decode((String)value, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT) : URLEscaper.unescape((String)value, (URLEscaper.Escaping)URLEscaper.Escaping.URL_ESCAPING);
        return ArgumentUtils.convertSimpleValue(decodedValue, alternativeKey.getDataSchema(), alternativeKey.getType());
    }

    public static <T, K> K translateFromAlternativeKey(T altKey, String altKeyName, ResourceModel resource) throws InvalidAlternativeKeyException, AlternativeKeyCoercerException {
        AlternativeKey<T, K> alternativeKey = ArgumentUtils.getAltKeyOrError(altKeyName, resource);
        KeyCoercer<T, K> keyCoercer = alternativeKey.getKeyCoercer();
        try {
            return (K)keyCoercer.coerceToKey(altKey);
        }
        catch (InvalidAlternativeKeyException invalidAlternativeKeyException) {
            throw invalidAlternativeKeyException;
        }
        catch (Exception e) {
            throw new AlternativeKeyCoercerException(e);
        }
    }

    public static <T, K> T translateToAlternativeKey(K key, String altKeyName, ResourceModel resource) throws AlternativeKeyCoercerException {
        AlternativeKey<T, K> alternativeKey = ArgumentUtils.getAltKeyOrError(altKeyName, resource);
        KeyCoercer<T, K> keyCoercer = alternativeKey.getKeyCoercer();
        try {
            return (T)keyCoercer.coerceFromKey(key);
        }
        catch (Exception e) {
            throw new AlternativeKeyCoercerException(e);
        }
    }

    private static <T, K> AlternativeKey<T, K> getAltKeyOrError(String altKeyName, ResourceModel resource) throws IllegalArgumentException {
        if (!resource.getAlternativeKeys().containsKey(altKeyName)) {
            throw new IllegalArgumentException(String.format("Resource '%s' does not contain alternative key named '%s'.", resource.getName(), altKeyName));
        }
        AlternativeKey<?, ?> alternativeKey = resource.getAlternativeKeys().get(altKeyName);
        return alternativeKey;
    }

    public static Object convertSimpleValue(String value, DataSchema schema, Class<?> type) {
        DataSchema.Type dereferencedType = schema.getDereferencedType();
        Object underlyingValue = schema.getDereferencedDataSchema().isComplex() ? value : ValueConverter.coerceString((String)value, (Class)DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)dereferencedType));
        return DataTemplateUtil.coerceOutput((Object)underlyingValue, type);
    }

    public static String argumentAsString(Object obj, String paramName) {
        if (obj != null && !(obj instanceof String)) {
            throw new RestLiInternalException("Invalid value type for parameter " + paramName);
        }
        return (String)obj;
    }
}

