/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.parseq.Engine;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.Tasks;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.restli.common.HttpMethod;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.multiplexer.IndividualRequest;
import com.linkedin.restli.common.multiplexer.IndividualRequestMap;
import com.linkedin.restli.common.multiplexer.IndividualResponseMap;
import com.linkedin.restli.common.multiplexer.MultiplexedRequestContent;
import com.linkedin.restli.common.multiplexer.MultiplexedResponseContent;
import com.linkedin.restli.internal.common.ContentTypeUtil;
import com.linkedin.restli.internal.common.CookieUtil;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.server.multiplexer.IndividualResponseConversionTask;
import com.linkedin.restli.server.multiplexer.IndividualResponseWithCookies;
import com.linkedin.restli.server.multiplexer.InheritEnvelopeRequestTask;
import com.linkedin.restli.server.multiplexer.MultiplexedRequestHandler;
import com.linkedin.restli.server.multiplexer.MultiplexerRunMode;
import com.linkedin.restli.server.multiplexer.MultiplexerSingletonFilter;
import com.linkedin.restli.server.multiplexer.RequestFilterTask;
import com.linkedin.restli.server.multiplexer.RequestHandlingTask;
import com.linkedin.restli.server.multiplexer.RequestSanitizationTask;
import com.linkedin.restli.server.multiplexer.ResponseFilterTask;
import com.linkedin.restli.server.multiplexer.SyntheticRequestCreationTask;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.activation.MimeTypeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexedRequestHandlerImpl
implements MultiplexedRequestHandler {
    private static final String MUX_PLAN_CLASS = "mux";
    private static final String MUX_URI_PATH = "/mux";
    private final Logger _log = LoggerFactory.getLogger(MultiplexedRequestHandlerImpl.class);
    private final RestRequestHandler _requestHandler;
    private final Engine _engine;
    private final int _maximumRequestsNumber;
    private final MultiplexerSingletonFilter _multiplexerSingletonFilter;
    private final Set<String> _individualRequestHeaderWhitelist;
    private final MultiplexerRunMode _multiplexerRunMode;

    public MultiplexedRequestHandlerImpl(RestRequestHandler requestHandler, Engine engine, int maximumRequestsNumber, Set<String> individualRequestHeaderWhitelist, MultiplexerSingletonFilter multiplexerSingletonFilter, MultiplexerRunMode multiplexerRunMode) {
        this._requestHandler = requestHandler;
        this._engine = engine;
        this._maximumRequestsNumber = maximumRequestsNumber;
        this._individualRequestHeaderWhitelist = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (individualRequestHeaderWhitelist != null) {
            this._individualRequestHeaderWhitelist.addAll(individualRequestHeaderWhitelist);
        }
        this._multiplexerSingletonFilter = multiplexerSingletonFilter;
        this._multiplexerRunMode = multiplexerRunMode;
    }

    @Override
    public boolean isMultiplexedRequest(Request request) {
        return MUX_URI_PATH.equals(request.getURI().getPath());
    }

    public void handleRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        IndividualRequestMap individualRequests;
        if (HttpMethod.POST != HttpMethod.valueOf((String)request.getMethod())) {
            this._log.error("POST is expected, but " + request.getMethod() + " received");
            callback.onError((Throwable)RestException.forError((int)HttpStatus.S_405_METHOD_NOT_ALLOWED.getCode(), (String)"Invalid method"));
            return;
        }
        try {
            individualRequests = this.extractIndividualRequests(request);
        }
        catch (RestException e) {
            this._log.error("Invalid multiplexed request", (Throwable)e);
            callback.onError((Throwable)e);
            return;
        }
        catch (Exception e) {
            this._log.error("Invalid multiplexed request", (Throwable)e);
            callback.onError((Throwable)RestException.forError((int)HttpStatus.S_400_BAD_REQUEST.getCode(), (Throwable)e));
            return;
        }
        IndividualResponseMap individualResponses = new IndividualResponseMap(individualRequests.size());
        HashMap<String, HttpCookie> responseCookies = new HashMap<String, HttpCookie>();
        Task<?> requestProcessingTask = this.createParallelRequestsTask(request, requestContext, individualRequests, individualResponses, responseCookies);
        Task responseAggregationTask = Task.action((String)"send aggregated response", () -> {
            RestResponse aggregatedResponse = MultiplexedRequestHandlerImpl.aggregateResponses(individualResponses, responseCookies);
            callback.onSuccess((Object)aggregatedResponse);
        });
        this._engine.run(requestProcessingTask.andThen(responseAggregationTask), MUX_PLAN_CLASS);
    }

    private IndividualRequestMap extractIndividualRequests(RestRequest restRequest) throws RestException {
        MultiplexedRequestHandlerImpl.validateHeaders(restRequest);
        DataMap data = DataMapUtils.readMap((RestMessage)restRequest);
        MultiplexedRequestContent multiplexedRequestContent = (MultiplexedRequestContent)DataTemplateUtil.wrap((Object)data, MultiplexedRequestContent.class);
        IndividualRequestMap individualRequests = multiplexedRequestContent.getRequests();
        int totalCount = this.totalRequestCount(individualRequests);
        if (totalCount == 0) {
            throw RestException.forError((int)HttpStatus.S_400_BAD_REQUEST.getCode(), (String)"No individual requests to process");
        }
        if (totalCount > this._maximumRequestsNumber) {
            throw RestException.forError((int)HttpStatus.S_400_BAD_REQUEST.getCode(), (String)("The server is configured to serve up to " + this._maximumRequestsNumber + " requests, but received " + totalCount));
        }
        return individualRequests;
    }

    private int totalRequestCount(IndividualRequestMap individualRequests) {
        int count = individualRequests.size();
        for (IndividualRequest individualRequest : individualRequests.values()) {
            count += this.totalRequestCount(individualRequest.getDependentRequests());
        }
        return count;
    }

    private static void validateHeaders(RestRequest request) throws RestException {
        boolean supported;
        try {
            supported = ContentTypeUtil.ContentType.JSON == ContentTypeUtil.getContentType((String)request.getHeader("Content-Type"));
        }
        catch (MimeTypeParseException e) {
            throw RestException.forError((int)HttpStatus.S_400_BAD_REQUEST.getCode(), (String)"Invalid content type");
        }
        if (!supported) {
            throw RestException.forError((int)HttpStatus.S_415_UNSUPPORTED_MEDIA_TYPE.getCode(), (String)"Unsupported content type");
        }
    }

    private Task<?> createParallelRequestsTask(RestRequest envelopeRequest, RequestContext requestContext, IndividualRequestMap individualRequests, IndividualResponseMap individualResponses, Map<String, HttpCookie> responseCookies) {
        ArrayList<Object> tasks = new ArrayList<Object>(individualRequests.size());
        for (Map.Entry individualRequestMapEntry : individualRequests.entrySet()) {
            String id = (String)individualRequestMapEntry.getKey();
            IndividualRequest individualRequest = (IndividualRequest)individualRequestMapEntry.getValue();
            Task<Void> individualRequestTask = this.createRequestHandlingTask(id, envelopeRequest, requestContext, individualRequest, individualResponses, responseCookies);
            IndividualRequestMap dependentRequests = individualRequest.getDependentRequests();
            if (dependentRequests.isEmpty()) {
                tasks.add(individualRequestTask);
                continue;
            }
            Task<?> dependentRequestsTask = this.createParallelRequestsTask(envelopeRequest, requestContext, dependentRequests, individualResponses, responseCookies);
            tasks.add(individualRequestTask.andThen(dependentRequestsTask));
        }
        return Tasks.par(tasks);
    }

    private Task<Void> createRequestHandlingTask(String id, RestRequest envelopeRequest, RequestContext requestContext, IndividualRequest individualRequest, IndividualResponseMap individualResponses, Map<String, HttpCookie> responseCookies) {
        RequestSanitizationTask requestSanitizationTask = new RequestSanitizationTask(individualRequest, this._individualRequestHeaderWhitelist);
        InheritEnvelopeRequestTask inheritEnvelopeRequestTask = new InheritEnvelopeRequestTask(envelopeRequest, requestSanitizationTask);
        RequestFilterTask requestFilterTask = new RequestFilterTask(this._multiplexerSingletonFilter, inheritEnvelopeRequestTask);
        SyntheticRequestCreationTask syntheticRequestCreationTask = new SyntheticRequestCreationTask(id, envelopeRequest, requestFilterTask);
        RequestHandlingTask requestHandlingTask = new RequestHandlingTask(this._requestHandler, syntheticRequestCreationTask, requestContext, this._multiplexerRunMode);
        IndividualResponseConversionTask toIndividualResponseTask = new IndividualResponseConversionTask(id, requestHandlingTask);
        ResponseFilterTask responseFilterTask = new ResponseFilterTask(this._multiplexerSingletonFilter, toIndividualResponseTask);
        Task addResponseTask = Task.action((String)"add response", () -> {
            IndividualResponseWithCookies individualResponseWithCookies = (IndividualResponseWithCookies)responseFilterTask.get();
            individualResponses.put(id, (DataTemplate)individualResponseWithCookies.getIndividualResponse());
            MultiplexedRequestHandlerImpl.addResponseCookies(responseCookies, individualResponseWithCookies.getCookies());
        });
        return Tasks.seq((Task)requestSanitizationTask, (Task)inheritEnvelopeRequestTask, (Task)requestFilterTask, (Task)syntheticRequestCreationTask, (Task)requestHandlingTask, (Task)toIndividualResponseTask, (Task)responseFilterTask, (Task)addResponseTask);
    }

    private static void addResponseCookies(Map<String, HttpCookie> responseCookies, List<String> setCookieHeaders) {
        List newCookies = CookieUtil.decodeSetCookies(setCookieHeaders);
        for (HttpCookie newCookie : newCookies) {
            String key = newCookie.getName() + ";" + (newCookie.getDomain() != null ? newCookie.getDomain().toLowerCase() : "") + ";" + (newCookie.getPath() != null ? newCookie.getPath() : "");
            responseCookies.put(key, newCookie);
        }
    }

    private static RestResponse aggregateResponses(IndividualResponseMap responses, Map<String, HttpCookie> responseCookies) {
        MultiplexedResponseContent aggregatedResponseContent = new MultiplexedResponseContent();
        aggregatedResponseContent.setResponses(responses);
        byte[] aggregatedResponseData = DataMapUtils.mapToBytes(aggregatedResponseContent.data());
        return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setEntity(aggregatedResponseData).setCookies(CookieUtil.encodeSetCookies(new ArrayList<HttpCookie>(responseCookies.values())))).build();
    }
}

