/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.influxdb;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.influxdb.InfluxDBConnectionType;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;

public class InfluxDBPusher {
    private static final String DEFAULT_RETENTION_POLICY = "default";
    private final InfluxDB influxDB;
    private final String database;

    private InfluxDBPusher(Builder builder) {
        this.influxDB = builder.influxDB;
        this.database = builder.database;
    }

    public void push(Point point) {
        BatchPoints.Builder batchPointsBuilder = BatchPoints.database((String)this.database).retentionPolicy(DEFAULT_RETENTION_POLICY);
        batchPointsBuilder.point(point);
        this.influxDB.write(batchPointsBuilder.build());
    }

    public void push(List<Point> points) {
        BatchPoints.Builder batchPointsBuilder = BatchPoints.database((String)this.database).retentionPolicy(DEFAULT_RETENTION_POLICY);
        for (Point point : points) {
            batchPointsBuilder.point(point);
        }
        this.influxDB.write(batchPointsBuilder.build());
    }

    public static class Builder {
        private final InfluxDB influxDB;
        private final String database;

        public Builder(String url, String username, String password, String database, InfluxDBConnectionType connectionType) {
            this.influxDB = connectionType.createConnection(url, username, password);
            this.database = database;
        }

        public Builder withConnectTimeout(long connectTimeout, TimeUnit timeUnit) {
            this.influxDB.setConnectTimeout(connectTimeout, timeUnit);
            return this;
        }

        public Builder withWriteTimeout(long writeTimeout, TimeUnit timeUnit) {
            this.influxDB.setWriteTimeout(writeTimeout, timeUnit);
            return this;
        }

        public InfluxDBPusher build() {
            return new InfluxDBPusher(this);
        }
    }
}

