/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.hive.HivePartition;
import org.apache.gobblin.hive.HiveRegProps;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRegisterStep
implements CommitStep {
    private static final Logger log = LoggerFactory.getLogger(HiveRegisterStep.class);
    private final Optional<String> metastoreURI;
    private final HiveSpec hiveSpec;
    private final HiveRegProps props;
    private final boolean verifyBeforeRegistering;

    public HiveRegisterStep(Optional<String> metastoreURI, HiveSpec hiveSpec, HiveRegProps props) {
        this(metastoreURI, hiveSpec, props, true);
    }

    public boolean isCompleted() throws IOException {
        return false;
    }

    public void execute() throws IOException {
        if (this.verifyBeforeRegistering) {
            if (!this.hiveSpec.getTable().getLocation().isPresent()) {
                throw this.getException("Table does not have a location parameter.");
            }
            Path tablePath = new Path((String)this.hiveSpec.getTable().getLocation().get());
            FileSystem fs = this.hiveSpec.getPath().getFileSystem(new Configuration());
            if (!fs.exists(tablePath)) {
                throw this.getException(String.format("Table location %s does not exist.", tablePath));
            }
            if (this.hiveSpec.getPartition().isPresent()) {
                if (!((HivePartition)this.hiveSpec.getPartition().get()).getLocation().isPresent()) {
                    throw this.getException("Partition does not have a location parameter.");
                }
                Path partitionPath = new Path((String)((HivePartition)this.hiveSpec.getPartition().get()).getLocation().get());
                if (!fs.exists(this.hiveSpec.getPath())) {
                    throw this.getException(String.format("Partition location %s does not exist.", partitionPath));
                }
            }
        }
        try (HiveRegister hiveRegister = HiveRegister.get(this.props, this.metastoreURI);){
            log.info("Registering Hive Spec " + this.hiveSpec);
            ListenableFuture<Void> future = hiveRegister.register(this.hiveSpec);
            future.get();
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new IOException("Hive registration was interrupted.", ie);
        }
    }

    private IOException getException(String message) {
        return new IOException(String.format("Failed to register Hive Spec %s. %s", this.hiveSpec, message));
    }

    public String toString() {
        String table = this.hiveSpec.getTable().getDbName() + "." + this.hiveSpec.getTable().getTableName();
        String partitionInfo = this.hiveSpec.getPartition().isPresent() ? " partition " + Arrays.toString(((HivePartition)this.hiveSpec.getPartition().get()).getValues().toArray()) : "";
        String location = this.hiveSpec.getPartition().isPresent() ? (String)((HivePartition)this.hiveSpec.getPartition().get()).getLocation().get() : (String)this.hiveSpec.getTable().getLocation().get();
        return String.format("Register %s%s with location %s in Hive metastore %s.", table, partitionInfo, location, this.metastoreURI.isPresent() ? this.metastoreURI.get() : "default");
    }

    @ConstructorProperties(value={"metastoreURI", "hiveSpec", "props", "verifyBeforeRegistering"})
    public HiveRegisterStep(Optional<String> metastoreURI, HiveSpec hiveSpec, HiveRegProps props, boolean verifyBeforeRegistering) {
        this.metastoreURI = metastoreURI;
        this.hiveSpec = hiveSpec;
        this.props = props;
        this.verifyBeforeRegistering = verifyBeforeRegistering;
    }
}

