/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.spec;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.hive.HivePartition;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.HiveTable;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.hive.spec.HiveSpecWithPostActivities;
import org.apache.gobblin.hive.spec.HiveSpecWithPreActivities;
import org.apache.gobblin.hive.spec.HiveSpecWithPredicates;
import org.apache.gobblin.hive.spec.activity.Activity;
import org.apache.hadoop.fs.Path;

@Alpha
public class SimpleHiveSpec
implements HiveSpec,
HiveSpecWithPreActivities,
HiveSpecWithPostActivities,
HiveSpecWithPredicates {
    protected final Path path;
    protected final HiveTable table;
    protected final Optional<HivePartition> partition;
    protected final Collection<Activity> preActivities;
    protected final Collection<Activity> postActivities;
    protected final Collection<Predicate<HiveRegister>> predicates;

    protected SimpleHiveSpec(Builder<?> builder) {
        this.path = ((Builder)builder).path;
        this.table = ((Builder)builder).table;
        this.partition = ((Builder)builder).partition != null ? ((Builder)builder).partition : Optional.absent();
        this.preActivities = ((Builder)builder).preActivities;
        this.postActivities = ((Builder)builder).postActivities;
        this.predicates = ((Builder)builder).predicates;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("path", (Object)this.path.toString()).add("db", (Object)this.table.getDbName()).add("table", (Object)this.table.getTableName()).add("partition", this.partition.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public HiveTable getTable() {
        return this.table;
    }

    @Override
    public Optional<HivePartition> getPartition() {
        return this.partition;
    }

    @Override
    public Collection<Activity> getPreActivities() {
        return this.preActivities;
    }

    @Override
    public Collection<Activity> getPostActivities() {
        return this.postActivities;
    }

    @Override
    public Collection<Predicate<HiveRegister>> getPredicates() {
        return this.predicates;
    }

    public static class Builder<T extends Builder<?>> {
        private ArrayList<Activity> preActivities;
        private ArrayList<Activity> postActivities;
        private ArrayList<Predicate<HiveRegister>> predicates;
        private Path path;
        private HiveTable table;
        private Optional<HivePartition> partition;

        private Builder() {
            this.path = null;
        }

        public Builder(Path path) {
            this.path = path;
            this.preActivities = Lists.newArrayList();
            this.postActivities = Lists.newArrayList();
            this.predicates = Lists.newArrayList();
        }

        public T withTable(HiveTable table) {
            this.table = table;
            return (T)this;
        }

        public T withPartition(Optional<HivePartition> partition) {
            this.partition = partition;
            return (T)this;
        }

        public SimpleHiveSpec build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.table);
            return new SimpleHiveSpec(this);
        }

        public Builder<T> path(Path path) {
            this.path = path;
            return this;
        }

        public Builder<T> table(HiveTable table) {
            this.table = table;
            return this;
        }

        public Builder<T> partition(Optional<HivePartition> partition) {
            this.partition = partition;
            return this;
        }

        public Builder<T> preActivity(Activity preActivity) {
            if (this.preActivities == null) {
                this.preActivities = new ArrayList();
            }
            this.preActivities.add(preActivity);
            return this;
        }

        public Builder<T> preActivities(Collection<? extends Activity> preActivities) {
            if (this.preActivities == null) {
                this.preActivities = new ArrayList();
            }
            this.preActivities.addAll(preActivities);
            return this;
        }

        public Builder<T> clearPreActivities() {
            if (this.preActivities != null) {
                this.preActivities.clear();
            }
            return this;
        }

        public Builder<T> postActivity(Activity postActivity) {
            if (this.postActivities == null) {
                this.postActivities = new ArrayList();
            }
            this.postActivities.add(postActivity);
            return this;
        }

        public Builder<T> postActivities(Collection<? extends Activity> postActivities) {
            if (this.postActivities == null) {
                this.postActivities = new ArrayList();
            }
            this.postActivities.addAll(postActivities);
            return this;
        }

        public Builder<T> clearPostActivities() {
            if (this.postActivities != null) {
                this.postActivities.clear();
            }
            return this;
        }

        public Builder<T> predicate(Predicate<HiveRegister> predicate) {
            if (this.predicates == null) {
                this.predicates = new ArrayList();
            }
            this.predicates.add(predicate);
            return this;
        }

        public Builder<T> predicates(Collection<? extends Predicate<HiveRegister>> predicates) {
            if (this.predicates == null) {
                this.predicates = new ArrayList();
            }
            this.predicates.addAll(predicates);
            return this;
        }

        public Builder<T> clearPredicates() {
            if (this.predicates != null) {
                this.predicates.clear();
            }
            return this;
        }

        public String toString() {
            return "SimpleHiveSpec.Builder(path=" + this.path + ", table=" + this.table + ", partition=" + this.partition + ", preActivities=" + this.preActivities + ", postActivities=" + this.postActivities + ", predicates=" + this.predicates + ")";
        }

        public Path getPath() {
            return this.path;
        }

        public HiveTable getTable() {
            return this.table;
        }

        public Optional<HivePartition> getPartition() {
            return this.partition;
        }
    }
}

