/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.d2.HttpProtocolVersionType;
import com.linkedin.d2.poolStrategyType;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;

public class D2TransportClientProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"D2TransportClientProperties\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"The properties that is applied when creating transport client to talk to this particular D2 service\",\"fields\":[{\"name\":\"queryPostThreshold\",\"type\":\"int\",\"doc\":\"The minimum size of GET requests parameters before we start converting it to POST request.\",\"optional\":true},{\"name\":\"requestTimeout\",\"type\":\"long\",\"doc\":\"Timeout in ms for this transport client. Defaults to 10s.\",\"optional\":true},{\"name\":\"maxResponseSize\",\"type\":\"long\",\"doc\":\"Max payload that this transport client can carry in bytes. Defaults to 2MB.\",\"optional\":true},{\"name\":\"maxHeaderSize\",\"type\":\"int\",\"doc\":\"Maximum size, in bytes, of all headers for a single HTTP request/response. Defaults to 8KB.\",\"optional\":true},{\"name\":\"maxChunkSize\",\"type\":\"int\",\"doc\":\"Maximum chunk size, in bytes, of HTTP chunked encoding. Defaults to 8KB.\",\"optional\":true},{\"name\":\"poolSize\",\"type\":\"int\",\"doc\":\"Maximum size of the underlying HTTP connection pool. Defaults to 200.\",\"optional\":true},{\"name\":\"poolWaiterSize\",\"type\":\"int\",\"doc\":\"Maximum waiters waiting on the HTTP connection pool.\",\"optional\":true},{\"name\":\"poolStrategy\",\"type\":{\"type\":\"enum\",\"name\":\"poolStrategyType\",\"symbols\":[\"MRU\",\"LRU\"],\"symbolDocs\":{\"MRU\":\"Select most recently used connection\",\"LRU\":\"Select least recently used connection\"}},\"doc\":\"The strategy HTTP connection pool uses to select connections. Defaults to MRU.\",\"optional\":true},{\"name\":\"minPoolSize\",\"type\":\"int\",\"doc\":\"Minimum size of the HTTP connection pool\",\"optional\":true},{\"name\":\"maxConcurrentConnections\",\"type\":\"int\",\"doc\":\"Maximum connection requests this transport client can send to an endpoint concurrently.\",\"optional\":true},{\"name\":\"idleTimeout\",\"type\":\"long\",\"doc\":\"interval after which idle connections will be automatically closed. Defaults to 25s.\",\"optional\":true},{\"name\":\"shutdownTimeout\",\"type\":\"long\",\"doc\":\"timeout, in ms, the client should wait after shutdown is initiated before terminating outstanding requests. Defaults to 5s\",\"optional\":true},{\"name\":\"responseCompressionOperations\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"operations where compression should be used\",\"optional\":true},{\"name\":\"responseContentEncodings\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"preferred content encodings for responses, used to construct Accept-Encoding header\",\"optional\":true},{\"name\":\"requestContentEncodings\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"supported content encodings for requests\",\"optional\":true},{\"name\":\"useResponseCompression\",\"type\":\"boolean\",\"doc\":\"whether to enable response compression or not\",\"default\":false},{\"name\":\"allowedClientOverrideKeys\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"a list of keys in D2TransportClientProperties which client can override\",\"default\":[]},{\"name\":\"protocolVersion\",\"type\":{\"type\":\"enum\",\"name\":\"HttpProtocolVersionType\",\"symbols\":[\"HTTP_1_1\",\"HTTP_2\"],\"symbolDocs\":{\"HTTP_1_1\":\"HTTP/1.1\",\"HTTP_2\":\"HTTP/2\"}},\"doc\":\"service desired transport client protocol version e.g. HTTP/1.1, HTTP/2\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_QueryPostThreshold = SCHEMA.getField("queryPostThreshold");
    private static final RecordDataSchema.Field FIELD_RequestTimeout = SCHEMA.getField("requestTimeout");
    private static final RecordDataSchema.Field FIELD_MaxResponseSize = SCHEMA.getField("maxResponseSize");
    private static final RecordDataSchema.Field FIELD_MaxHeaderSize = SCHEMA.getField("maxHeaderSize");
    private static final RecordDataSchema.Field FIELD_MaxChunkSize = SCHEMA.getField("maxChunkSize");
    private static final RecordDataSchema.Field FIELD_PoolSize = SCHEMA.getField("poolSize");
    private static final RecordDataSchema.Field FIELD_PoolWaiterSize = SCHEMA.getField("poolWaiterSize");
    private static final RecordDataSchema.Field FIELD_PoolStrategy = SCHEMA.getField("poolStrategy");
    private static final RecordDataSchema.Field FIELD_MinPoolSize = SCHEMA.getField("minPoolSize");
    private static final RecordDataSchema.Field FIELD_MaxConcurrentConnections = SCHEMA.getField("maxConcurrentConnections");
    private static final RecordDataSchema.Field FIELD_IdleTimeout = SCHEMA.getField("idleTimeout");
    private static final RecordDataSchema.Field FIELD_ShutdownTimeout = SCHEMA.getField("shutdownTimeout");
    private static final RecordDataSchema.Field FIELD_ResponseCompressionOperations = SCHEMA.getField("responseCompressionOperations");
    private static final RecordDataSchema.Field FIELD_ResponseContentEncodings = SCHEMA.getField("responseContentEncodings");
    private static final RecordDataSchema.Field FIELD_RequestContentEncodings = SCHEMA.getField("requestContentEncodings");
    private static final RecordDataSchema.Field FIELD_UseResponseCompression = SCHEMA.getField("useResponseCompression");
    private static final RecordDataSchema.Field FIELD_AllowedClientOverrideKeys = SCHEMA.getField("allowedClientOverrideKeys");
    private static final RecordDataSchema.Field FIELD_ProtocolVersion = SCHEMA.getField("protocolVersion");

    public D2TransportClientProperties() {
        super(new DataMap(), SCHEMA);
    }

    public D2TransportClientProperties(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasQueryPostThreshold() {
        return this.contains(FIELD_QueryPostThreshold);
    }

    public void removeQueryPostThreshold() {
        this.remove(FIELD_QueryPostThreshold);
    }

    public Integer getQueryPostThreshold(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_QueryPostThreshold, Integer.class, mode);
    }

    public Integer getQueryPostThreshold() {
        return (Integer)this.obtainDirect(FIELD_QueryPostThreshold, Integer.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setQueryPostThreshold(Integer value, SetMode mode) {
        this.putDirect(FIELD_QueryPostThreshold, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setQueryPostThreshold(Integer value) {
        this.putDirect(FIELD_QueryPostThreshold, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setQueryPostThreshold(int value) {
        this.putDirect(FIELD_QueryPostThreshold, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasRequestTimeout() {
        return this.contains(FIELD_RequestTimeout);
    }

    public void removeRequestTimeout() {
        this.remove(FIELD_RequestTimeout);
    }

    public Long getRequestTimeout(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_RequestTimeout, Long.class, mode);
    }

    public Long getRequestTimeout() {
        return (Long)this.obtainDirect(FIELD_RequestTimeout, Long.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setRequestTimeout(Long value, SetMode mode) {
        this.putDirect(FIELD_RequestTimeout, Long.class, Long.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setRequestTimeout(Long value) {
        this.putDirect(FIELD_RequestTimeout, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setRequestTimeout(long value) {
        this.putDirect(FIELD_RequestTimeout, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMaxResponseSize() {
        return this.contains(FIELD_MaxResponseSize);
    }

    public void removeMaxResponseSize() {
        this.remove(FIELD_MaxResponseSize);
    }

    public Long getMaxResponseSize(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_MaxResponseSize, Long.class, mode);
    }

    public Long getMaxResponseSize() {
        return (Long)this.obtainDirect(FIELD_MaxResponseSize, Long.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setMaxResponseSize(Long value, SetMode mode) {
        this.putDirect(FIELD_MaxResponseSize, Long.class, Long.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setMaxResponseSize(Long value) {
        this.putDirect(FIELD_MaxResponseSize, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setMaxResponseSize(long value) {
        this.putDirect(FIELD_MaxResponseSize, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMaxHeaderSize() {
        return this.contains(FIELD_MaxHeaderSize);
    }

    public void removeMaxHeaderSize() {
        this.remove(FIELD_MaxHeaderSize);
    }

    public Integer getMaxHeaderSize(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_MaxHeaderSize, Integer.class, mode);
    }

    public Integer getMaxHeaderSize() {
        return (Integer)this.obtainDirect(FIELD_MaxHeaderSize, Integer.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setMaxHeaderSize(Integer value, SetMode mode) {
        this.putDirect(FIELD_MaxHeaderSize, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setMaxHeaderSize(Integer value) {
        this.putDirect(FIELD_MaxHeaderSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setMaxHeaderSize(int value) {
        this.putDirect(FIELD_MaxHeaderSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMaxChunkSize() {
        return this.contains(FIELD_MaxChunkSize);
    }

    public void removeMaxChunkSize() {
        this.remove(FIELD_MaxChunkSize);
    }

    public Integer getMaxChunkSize(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_MaxChunkSize, Integer.class, mode);
    }

    public Integer getMaxChunkSize() {
        return (Integer)this.obtainDirect(FIELD_MaxChunkSize, Integer.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setMaxChunkSize(Integer value, SetMode mode) {
        this.putDirect(FIELD_MaxChunkSize, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setMaxChunkSize(Integer value) {
        this.putDirect(FIELD_MaxChunkSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setMaxChunkSize(int value) {
        this.putDirect(FIELD_MaxChunkSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPoolSize() {
        return this.contains(FIELD_PoolSize);
    }

    public void removePoolSize() {
        this.remove(FIELD_PoolSize);
    }

    public Integer getPoolSize(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_PoolSize, Integer.class, mode);
    }

    public Integer getPoolSize() {
        return (Integer)this.obtainDirect(FIELD_PoolSize, Integer.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setPoolSize(Integer value, SetMode mode) {
        this.putDirect(FIELD_PoolSize, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setPoolSize(Integer value) {
        this.putDirect(FIELD_PoolSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setPoolSize(int value) {
        this.putDirect(FIELD_PoolSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPoolWaiterSize() {
        return this.contains(FIELD_PoolWaiterSize);
    }

    public void removePoolWaiterSize() {
        this.remove(FIELD_PoolWaiterSize);
    }

    public Integer getPoolWaiterSize(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_PoolWaiterSize, Integer.class, mode);
    }

    public Integer getPoolWaiterSize() {
        return (Integer)this.obtainDirect(FIELD_PoolWaiterSize, Integer.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setPoolWaiterSize(Integer value, SetMode mode) {
        this.putDirect(FIELD_PoolWaiterSize, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setPoolWaiterSize(Integer value) {
        this.putDirect(FIELD_PoolWaiterSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setPoolWaiterSize(int value) {
        this.putDirect(FIELD_PoolWaiterSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPoolStrategy() {
        return this.contains(FIELD_PoolStrategy);
    }

    public void removePoolStrategy() {
        this.remove(FIELD_PoolStrategy);
    }

    public poolStrategyType getPoolStrategy(GetMode mode) {
        return (poolStrategyType)((Object)this.obtainDirect(FIELD_PoolStrategy, poolStrategyType.class, mode));
    }

    public poolStrategyType getPoolStrategy() {
        return (poolStrategyType)((Object)this.obtainDirect(FIELD_PoolStrategy, poolStrategyType.class, GetMode.STRICT));
    }

    public D2TransportClientProperties setPoolStrategy(poolStrategyType value, SetMode mode) {
        this.putDirect(FIELD_PoolStrategy, poolStrategyType.class, String.class, (Object)value, mode);
        return this;
    }

    public D2TransportClientProperties setPoolStrategy(poolStrategyType value) {
        this.putDirect(FIELD_PoolStrategy, poolStrategyType.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMinPoolSize() {
        return this.contains(FIELD_MinPoolSize);
    }

    public void removeMinPoolSize() {
        this.remove(FIELD_MinPoolSize);
    }

    public Integer getMinPoolSize(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_MinPoolSize, Integer.class, mode);
    }

    public Integer getMinPoolSize() {
        return (Integer)this.obtainDirect(FIELD_MinPoolSize, Integer.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setMinPoolSize(Integer value, SetMode mode) {
        this.putDirect(FIELD_MinPoolSize, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setMinPoolSize(Integer value) {
        this.putDirect(FIELD_MinPoolSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setMinPoolSize(int value) {
        this.putDirect(FIELD_MinPoolSize, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMaxConcurrentConnections() {
        return this.contains(FIELD_MaxConcurrentConnections);
    }

    public void removeMaxConcurrentConnections() {
        this.remove(FIELD_MaxConcurrentConnections);
    }

    public Integer getMaxConcurrentConnections(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_MaxConcurrentConnections, Integer.class, mode);
    }

    public Integer getMaxConcurrentConnections() {
        return (Integer)this.obtainDirect(FIELD_MaxConcurrentConnections, Integer.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setMaxConcurrentConnections(Integer value, SetMode mode) {
        this.putDirect(FIELD_MaxConcurrentConnections, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setMaxConcurrentConnections(Integer value) {
        this.putDirect(FIELD_MaxConcurrentConnections, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setMaxConcurrentConnections(int value) {
        this.putDirect(FIELD_MaxConcurrentConnections, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasIdleTimeout() {
        return this.contains(FIELD_IdleTimeout);
    }

    public void removeIdleTimeout() {
        this.remove(FIELD_IdleTimeout);
    }

    public Long getIdleTimeout(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_IdleTimeout, Long.class, mode);
    }

    public Long getIdleTimeout() {
        return (Long)this.obtainDirect(FIELD_IdleTimeout, Long.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setIdleTimeout(Long value, SetMode mode) {
        this.putDirect(FIELD_IdleTimeout, Long.class, Long.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setIdleTimeout(Long value) {
        this.putDirect(FIELD_IdleTimeout, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setIdleTimeout(long value) {
        this.putDirect(FIELD_IdleTimeout, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasShutdownTimeout() {
        return this.contains(FIELD_ShutdownTimeout);
    }

    public void removeShutdownTimeout() {
        this.remove(FIELD_ShutdownTimeout);
    }

    public Long getShutdownTimeout(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_ShutdownTimeout, Long.class, mode);
    }

    public Long getShutdownTimeout() {
        return (Long)this.obtainDirect(FIELD_ShutdownTimeout, Long.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setShutdownTimeout(Long value, SetMode mode) {
        this.putDirect(FIELD_ShutdownTimeout, Long.class, Long.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setShutdownTimeout(Long value) {
        this.putDirect(FIELD_ShutdownTimeout, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setShutdownTimeout(long value) {
        this.putDirect(FIELD_ShutdownTimeout, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasResponseCompressionOperations() {
        return this.contains(FIELD_ResponseCompressionOperations);
    }

    public void removeResponseCompressionOperations() {
        this.remove(FIELD_ResponseCompressionOperations);
    }

    public StringArray getResponseCompressionOperations(GetMode mode) {
        return (StringArray)this.obtainWrapped(FIELD_ResponseCompressionOperations, StringArray.class, mode);
    }

    public StringArray getResponseCompressionOperations() {
        return (StringArray)this.obtainWrapped(FIELD_ResponseCompressionOperations, StringArray.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setResponseCompressionOperations(StringArray value, SetMode mode) {
        this.putWrapped(FIELD_ResponseCompressionOperations, StringArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2TransportClientProperties setResponseCompressionOperations(StringArray value) {
        this.putWrapped(FIELD_ResponseCompressionOperations, StringArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasResponseContentEncodings() {
        return this.contains(FIELD_ResponseContentEncodings);
    }

    public void removeResponseContentEncodings() {
        this.remove(FIELD_ResponseContentEncodings);
    }

    public StringArray getResponseContentEncodings(GetMode mode) {
        return (StringArray)this.obtainWrapped(FIELD_ResponseContentEncodings, StringArray.class, mode);
    }

    public StringArray getResponseContentEncodings() {
        return (StringArray)this.obtainWrapped(FIELD_ResponseContentEncodings, StringArray.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setResponseContentEncodings(StringArray value, SetMode mode) {
        this.putWrapped(FIELD_ResponseContentEncodings, StringArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2TransportClientProperties setResponseContentEncodings(StringArray value) {
        this.putWrapped(FIELD_ResponseContentEncodings, StringArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasRequestContentEncodings() {
        return this.contains(FIELD_RequestContentEncodings);
    }

    public void removeRequestContentEncodings() {
        this.remove(FIELD_RequestContentEncodings);
    }

    public StringArray getRequestContentEncodings(GetMode mode) {
        return (StringArray)this.obtainWrapped(FIELD_RequestContentEncodings, StringArray.class, mode);
    }

    public StringArray getRequestContentEncodings() {
        return (StringArray)this.obtainWrapped(FIELD_RequestContentEncodings, StringArray.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setRequestContentEncodings(StringArray value, SetMode mode) {
        this.putWrapped(FIELD_RequestContentEncodings, StringArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2TransportClientProperties setRequestContentEncodings(StringArray value) {
        this.putWrapped(FIELD_RequestContentEncodings, StringArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasUseResponseCompression() {
        return this.contains(FIELD_UseResponseCompression);
    }

    public void removeUseResponseCompression() {
        this.remove(FIELD_UseResponseCompression);
    }

    public Boolean isUseResponseCompression(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_UseResponseCompression, Boolean.class, mode);
    }

    public Boolean isUseResponseCompression() {
        return (Boolean)this.obtainDirect(FIELD_UseResponseCompression, Boolean.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setUseResponseCompression(Boolean value, SetMode mode) {
        this.putDirect(FIELD_UseResponseCompression, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public D2TransportClientProperties setUseResponseCompression(Boolean value) {
        this.putDirect(FIELD_UseResponseCompression, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties setUseResponseCompression(boolean value) {
        this.putDirect(FIELD_UseResponseCompression, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasAllowedClientOverrideKeys() {
        return this.contains(FIELD_AllowedClientOverrideKeys);
    }

    public void removeAllowedClientOverrideKeys() {
        this.remove(FIELD_AllowedClientOverrideKeys);
    }

    public StringArray getAllowedClientOverrideKeys(GetMode mode) {
        return (StringArray)this.obtainWrapped(FIELD_AllowedClientOverrideKeys, StringArray.class, mode);
    }

    public StringArray getAllowedClientOverrideKeys() {
        return (StringArray)this.obtainWrapped(FIELD_AllowedClientOverrideKeys, StringArray.class, GetMode.STRICT);
    }

    public D2TransportClientProperties setAllowedClientOverrideKeys(StringArray value, SetMode mode) {
        this.putWrapped(FIELD_AllowedClientOverrideKeys, StringArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2TransportClientProperties setAllowedClientOverrideKeys(StringArray value) {
        this.putWrapped(FIELD_AllowedClientOverrideKeys, StringArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasProtocolVersion() {
        return this.contains(FIELD_ProtocolVersion);
    }

    public void removeProtocolVersion() {
        this.remove(FIELD_ProtocolVersion);
    }

    public HttpProtocolVersionType getProtocolVersion(GetMode mode) {
        return (HttpProtocolVersionType)((Object)this.obtainDirect(FIELD_ProtocolVersion, HttpProtocolVersionType.class, mode));
    }

    public HttpProtocolVersionType getProtocolVersion() {
        return (HttpProtocolVersionType)((Object)this.obtainDirect(FIELD_ProtocolVersion, HttpProtocolVersionType.class, GetMode.STRICT));
    }

    public D2TransportClientProperties setProtocolVersion(HttpProtocolVersionType value, SetMode mode) {
        this.putDirect(FIELD_ProtocolVersion, HttpProtocolVersionType.class, String.class, (Object)value, mode);
        return this;
    }

    public D2TransportClientProperties setProtocolVersion(HttpProtocolVersionType value) {
        this.putDirect(FIELD_ProtocolVersion, HttpProtocolVersionType.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2TransportClientProperties clone() throws CloneNotSupportedException {
        return (D2TransportClientProperties)super.clone();
    }

    public D2TransportClientProperties copy() throws CloneNotSupportedException {
        return (D2TransportClientProperties)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec queryPostThreshold() {
            return new PathSpec(this.getPathComponents(), "queryPostThreshold");
        }

        public PathSpec requestTimeout() {
            return new PathSpec(this.getPathComponents(), "requestTimeout");
        }

        public PathSpec maxResponseSize() {
            return new PathSpec(this.getPathComponents(), "maxResponseSize");
        }

        public PathSpec maxHeaderSize() {
            return new PathSpec(this.getPathComponents(), "maxHeaderSize");
        }

        public PathSpec maxChunkSize() {
            return new PathSpec(this.getPathComponents(), "maxChunkSize");
        }

        public PathSpec poolSize() {
            return new PathSpec(this.getPathComponents(), "poolSize");
        }

        public PathSpec poolWaiterSize() {
            return new PathSpec(this.getPathComponents(), "poolWaiterSize");
        }

        public PathSpec poolStrategy() {
            return new PathSpec(this.getPathComponents(), "poolStrategy");
        }

        public PathSpec minPoolSize() {
            return new PathSpec(this.getPathComponents(), "minPoolSize");
        }

        public PathSpec maxConcurrentConnections() {
            return new PathSpec(this.getPathComponents(), "maxConcurrentConnections");
        }

        public PathSpec idleTimeout() {
            return new PathSpec(this.getPathComponents(), "idleTimeout");
        }

        public PathSpec shutdownTimeout() {
            return new PathSpec(this.getPathComponents(), "shutdownTimeout");
        }

        public PathSpec responseCompressionOperations() {
            return new PathSpec(this.getPathComponents(), "responseCompressionOperations");
        }

        public PathSpec responseContentEncodings() {
            return new PathSpec(this.getPathComponents(), "responseContentEncodings");
        }

        public PathSpec requestContentEncodings() {
            return new PathSpec(this.getPathComponents(), "requestContentEncodings");
        }

        public PathSpec useResponseCompression() {
            return new PathSpec(this.getPathComponents(), "useResponseCompression");
        }

        public PathSpec allowedClientOverrideKeys() {
            return new PathSpec(this.getPathComponents(), "allowedClientOverrideKeys");
        }

        public PathSpec protocolVersion() {
            return new PathSpec(this.getPathComponents(), "protocolVersion");
        }
    }
}

