/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.broker;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.NoSuchScopeException;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.RootMetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.broker.MetricContextKey;
import org.apache.gobblin.metrics.broker.SubTaggedMetricContextKey;
import org.apache.gobblin.util.ConfigUtils;

public class MetricContextFactory<S extends ScopeType<S>>
implements SharedResourceFactory<MetricContext, MetricContextKey, S> {
    public static final String NAME = "metricContext";
    public static final String TAG_KEY = "tag";

    public String getName() {
        return NAME;
    }

    public SharedResourceFactoryResponse<MetricContext> createResource(SharedResourcesBroker<S> broker, ScopedConfigView<S, MetricContextKey> config) throws NotConfiguredException {
        try {
            if (config.getKey() instanceof SubTaggedMetricContextKey) {
                SubTaggedMetricContextKey key = (SubTaggedMetricContextKey)config.getKey();
                MetricContext parent = (MetricContext)broker.getSharedResource((SharedResourceFactory)this, (SharedResourceKey)new MetricContextKey());
                MetricContext.Builder builder = parent.childBuilder(key.getMetricContextName());
                for (Map.Entry entry : key.getTags().entrySet()) {
                    builder.addTag(new Tag((String)entry.getKey(), entry.getValue()));
                }
                return new ResourceInstance((Object)builder.build());
            }
            MetricContext parentMetricContext = RootMetricContext.get();
            Collection parents = config.getScope().parentScopes();
            if (parents != null && !parents.isEmpty()) {
                ScopeType parentScope = (ScopeType)parents.iterator().next();
                parentMetricContext = (MetricContext)broker.getSharedResourceAtScope((SharedResourceFactory)this, config.getKey(), parentScope);
            }
            String metricContextName = parents == null ? config.getScope().name() + "_" + UUID.randomUUID().toString() : broker.selfScope().getScopeId();
            MetricContext.Builder builder = parentMetricContext.childBuilder(metricContextName);
            builder.addTag(new Tag<String>(config.getScope().name(), broker.getScope(config.getScope()).getScopeId()));
            for (Map.Entry entry : ConfigUtils.getConfigOrEmpty((Config)config.getConfig(), (String)TAG_KEY).entrySet()) {
                builder.addTag(new Tag<Object>((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped()));
            }
            return new ResourceInstance((Object)builder.build());
        }
        catch (NoSuchScopeException nsse) {
            throw new RuntimeException("Could not create MetricContext.", nsse);
        }
    }

    public S getAutoScope(SharedResourcesBroker<S> broker, ConfigView<S, MetricContextKey> config) {
        return (S)broker.selfScope().getType();
    }
}

