/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.data.ByteString;
import com.linkedin.multipart.MultiPartMIMEDataSourceIteratorCallback;
import com.linkedin.multipart.MultiPartMIMEDataSourceWriter;
import com.linkedin.multipart.MultiPartMIMEUtils;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import java.io.IOException;

final class MultiPartMIMEChainReaderCallback
implements MultiPartMIMEDataSourceIteratorCallback {
    private final WriteHandle _writeHandle;
    private MultiPartMIMEDataSourceWriter _currentDataSource;
    private final byte[] _normalEncapsulationBoundary;

    @Override
    public void onNewDataSource(MultiPartMIMEDataSourceWriter multiPartMIMEDataSourceWriter) {
        multiPartMIMEDataSourceWriter.onInit(new WriteHandle(){

            public void write(ByteString data) {
                MultiPartMIMEChainReaderCallback.this._writeHandle.write(data);
            }

            public void done() {
            }

            public void error(Throwable throwable) {
                MultiPartMIMEChainReaderCallback.this._writeHandle.error(throwable);
            }

            public int remaining() {
                return MultiPartMIMEChainReaderCallback.this._writeHandle.remaining();
            }
        });
        this._currentDataSource = multiPartMIMEDataSourceWriter;
        ByteString serializedBoundaryAndHeaders = null;
        try {
            serializedBoundaryAndHeaders = MultiPartMIMEUtils.serializeBoundaryAndHeaders(this._normalEncapsulationBoundary, multiPartMIMEDataSourceWriter);
        }
        catch (IOException ioException) {
            this.onStreamError(ioException);
        }
        this._writeHandle.write(serializedBoundaryAndHeaders);
        if (this._writeHandle.remaining() > 0) {
            multiPartMIMEDataSourceWriter.onWritePossible();
        }
    }

    @Override
    public void onFinished() {
        this._writeHandle.done();
    }

    @Override
    public void onAbandonComplete() {
    }

    @Override
    public void onStreamError(Throwable throwable) {
        this._writeHandle.error(throwable);
    }

    MultiPartMIMEChainReaderCallback(WriteHandle writeHandle, byte[] normalEncapsulationBoundary) {
        this._writeHandle = writeHandle;
        this._normalEncapsulationBoundary = normalEncapsulationBoundary;
    }

    MultiPartMIMEDataSourceWriter getCurrentDataSource() {
        return this._currentDataSource;
    }
}

