/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Splitter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.crypto.EncryptionConfigParser;
import org.apache.gobblin.crypto.EncryptionFactory;
import org.apache.gobblin.recordaccess.RecordAccessor;

public abstract class StringFieldEncryptorConverter<SCHEMA, DATA>
extends Converter<SCHEMA, SCHEMA, DATA, DATA> {
    public static final String FIELDS_TO_ENCRYPT_CONFIG_NAME = "converter.fieldsToEncrypt";
    private StreamCodec encryptor;
    private List<String> fieldsToEncrypt;

    public Converter<SCHEMA, SCHEMA, DATA, DATA> init(WorkUnitState workUnit) {
        super.init(workUnit);
        Map config = EncryptionConfigParser.getConfigForBranch((EncryptionConfigParser.EntityType)EncryptionConfigParser.EntityType.CONVERTER_ENCRYPT, (String)((Object)((Object)this)).getClass().getSimpleName(), (WorkUnitState)workUnit);
        this.encryptor = EncryptionFactory.buildStreamCryptoProvider((Map)config);
        String fieldsToEncryptConfig = workUnit.getProp(FIELDS_TO_ENCRYPT_CONFIG_NAME, null);
        if (fieldsToEncryptConfig == null) {
            throw new IllegalArgumentException("Must fill in the converter.fieldsToEncrypt config option!");
        }
        this.fieldsToEncrypt = Splitter.on((char)',').splitToList((CharSequence)fieldsToEncryptConfig);
        return this;
    }

    public SCHEMA convertSchema(SCHEMA inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }

    public Iterable<DATA> convertRecord(SCHEMA outputSchema, DATA inputRecord, WorkUnitState workUnit) throws DataConversionException {
        RecordAccessor accessor = this.getRecordAccessor(inputRecord);
        for (String field : this.fieldsToEncrypt) {
            Map stringsToEncrypt = accessor.getMultiAsString(field);
            for (Map.Entry entry : stringsToEncrypt.entrySet()) {
                byte[] bytes = ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    OutputStream cipherStream = this.encryptor.encodeOutputStream((OutputStream)outputStream);
                    cipherStream.write(bytes);
                    cipherStream.flush();
                    cipherStream.close();
                }
                catch (IOException | IllegalArgumentException | IllegalStateException e) {
                    throw new DataConversionException("Error while encrypting field " + field + ": " + e.getMessage(), (Throwable)e);
                }
                byte[] cipherBytes = outputStream.toByteArray();
                accessor.set((String)entry.getKey(), new String(cipherBytes, StandardCharsets.UTF_8));
            }
        }
        return Collections.singleton(inputRecord);
    }

    protected List<String> getFieldsToEncrypt() {
        return this.fieldsToEncrypt;
    }

    protected abstract RecordAccessor getRecordAccessor(DATA var1);
}

