/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.yarn;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.cluster.GobblinClusterUtils;
import org.apache.gobblin.cluster.HelixUtils;
import org.apache.gobblin.cluster.event.ClusterManagerShutdownRequest;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.JvmUtils;
import org.apache.gobblin.yarn.GobblinYarnTaskRunner;
import org.apache.gobblin.yarn.YarnHelixUtils;
import org.apache.gobblin.yarn.event.ContainerShutdownRequest;
import org.apache.gobblin.yarn.event.NewContainerRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnService
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnService.class);
    private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final String applicationName;
    private final String applicationId;
    private final Config config;
    private final EventBus eventBus;
    private final Configuration yarnConfiguration;
    private final FileSystem fs;
    private final Optional<GobblinMetrics> gobblinMetrics;
    private final Optional<EventSubmitter> eventSubmitter;
    private final AMRMClientAsync<AMRMClient.ContainerRequest> amrmClientAsync;
    private final NMClientAsync nmClientAsync;
    private final ExecutorService containerLaunchExecutor;
    private final int initialContainers;
    private final int requestedContainerMemoryMbs;
    private final int requestedContainerCores;
    private final boolean containerHostAffinityEnabled;
    private final int helixInstanceMaxRetries;
    private final Optional<String> containerJvmArgs;
    private volatile Optional<Resource> maxResourceCapacity = Optional.absent();
    private final ByteBuffer tokens;
    private final Closer closer = Closer.create();
    private final Object allContainersStopped = new Object();
    private final ConcurrentMap<ContainerId, Map.Entry<Container, String>> containerMap = Maps.newConcurrentMap();
    private final AtomicInteger helixInstanceIdGenerator = new AtomicInteger(0);
    private final ConcurrentMap<String, AtomicInteger> helixInstanceRetryCount = Maps.newConcurrentMap();
    private final ConcurrentLinkedQueue<String> unusedHelixInstanceNames = Queues.newConcurrentLinkedQueue();
    private volatile boolean shutdownInProgress = false;

    public YarnService(Config config, String applicationName, String applicationId, YarnConfiguration yarnConfiguration, FileSystem fs, EventBus eventBus) throws Exception {
        this.applicationName = applicationName;
        this.applicationId = applicationId;
        this.config = config;
        this.eventBus = eventBus;
        this.gobblinMetrics = config.getBoolean("metrics.enabled") ? Optional.of((Object)this.buildGobblinMetrics()) : Optional.absent();
        this.eventSubmitter = config.getBoolean("metrics.enabled") ? Optional.of((Object)this.buildEventSubmitter()) : Optional.absent();
        this.yarnConfiguration = yarnConfiguration;
        this.fs = fs;
        this.amrmClientAsync = (AMRMClientAsync)this.closer.register((Closeable)AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)new AMRMClientCallbackHandler()));
        this.amrmClientAsync.init(this.yarnConfiguration);
        this.nmClientAsync = (NMClientAsync)this.closer.register((Closeable)NMClientAsync.createNMClientAsync((NMClientAsync.CallbackHandler)new NMClientCallbackHandler()));
        this.nmClientAsync.init(this.yarnConfiguration);
        this.initialContainers = config.getInt("gobblin.yarn.initial.containers");
        this.requestedContainerMemoryMbs = config.getInt("gobblin.yarn.container.memory.mbs");
        this.requestedContainerCores = config.getInt("gobblin.yarn.container.cores");
        this.containerHostAffinityEnabled = config.getBoolean("gobblin.yarn.container.affinity.enabled");
        this.helixInstanceMaxRetries = config.getInt("gobblin.yarn.helix.instance.max.retries");
        this.containerJvmArgs = config.hasPath("gobblin.yarn.container.jvm.args") ? Optional.of((Object)config.getString("gobblin.yarn.container.jvm.args")) : Optional.absent();
        this.containerLaunchExecutor = Executors.newFixedThreadPool(10, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOGGER), (Optional)Optional.of((Object)"ContainerLaunchExecutor")));
        this.tokens = this.getSecurityTokens();
    }

    @Subscribe
    public void handleNewContainerRequest(NewContainerRequest newContainerRequest) {
        if (!this.maxResourceCapacity.isPresent()) {
            LOGGER.error(String.format("Unable to handle new container request as maximum resource capacity is not available: [memory (MBs) requested = %d, vcores requested = %d]", this.requestedContainerMemoryMbs, this.requestedContainerCores));
            return;
        }
        this.requestContainer((Optional<String>)newContainerRequest.getReplacedContainer().transform((Function)new Function<Container, String>(){

            public String apply(Container container) {
                return container.getNodeId().getHost();
            }
        }));
    }

    @Subscribe
    public void handleContainerShutdownRequest(ContainerShutdownRequest containerShutdownRequest) {
        for (Container container : containerShutdownRequest.getContainers()) {
            LOGGER.info(String.format("Stopping container %s running on %s", container.getId(), container.getNodeId()));
            this.nmClientAsync.stopContainerAsync(container.getId(), container.getNodeId());
        }
    }

    protected void startUp() throws Exception {
        LOGGER.info("Starting the YarnService");
        this.eventBus.register((Object)this);
        this.amrmClientAsync.start();
        this.nmClientAsync.start();
        RegisterApplicationMasterResponse response = this.amrmClientAsync.registerApplicationMaster(GobblinClusterUtils.getHostname(), -1, "");
        LOGGER.info("ApplicationMaster registration response: " + response);
        this.maxResourceCapacity = Optional.of((Object)response.getMaximumResourceCapability());
        LOGGER.info("Requesting initial containers");
        this.requestInitialContainers(this.initialContainers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws IOException {
        LOGGER.info("Stopping the YarnService");
        this.shutdownInProgress = true;
        try {
            ExecutorsUtils.shutdownExecutorService((ExecutorService)this.containerLaunchExecutor, (Optional)Optional.of((Object)LOGGER));
            for (Map.Entry entry : this.containerMap.values()) {
                LOGGER.info(String.format("Stopping container %s running participant %s", ((Container)entry.getKey()).getId(), entry.getValue()));
                this.nmClientAsync.stopContainerAsync(((Container)entry.getKey()).getId(), ((Container)entry.getKey()).getNodeId());
            }
            if (!this.containerMap.isEmpty()) {
                Object object = this.allContainersStopped;
                synchronized (object) {
                    try {
                        this.allContainersStopped.wait(300000L);
                        LOGGER.info("All of the containers have been stopped");
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            this.amrmClientAsync.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        }
        catch (IOException | YarnException e) {
            LOGGER.error("Failed to unregister the ApplicationMaster", e);
        }
        finally {
            try {
                this.closer.close();
            }
            finally {
                if (this.gobblinMetrics.isPresent()) {
                    ((GobblinMetrics)this.gobblinMetrics.get()).stopMetricsReporting();
                }
            }
        }
    }

    private GobblinMetrics buildGobblinMetrics() {
        ImmutableList.Builder tags = new ImmutableList.Builder();
        tags.add((Object)new Tag("application.id", (Object)this.applicationId));
        tags.add((Object)new Tag("application.name", (Object)this.applicationName));
        GobblinMetrics gobblinMetrics = GobblinMetrics.get((String)this.applicationId, null, (List)tags.build());
        gobblinMetrics.startMetricReporting(ConfigUtils.configToProperties((Config)this.config));
        return gobblinMetrics;
    }

    private EventSubmitter buildEventSubmitter() {
        return new EventSubmitter.Builder(((GobblinMetrics)this.gobblinMetrics.get()).getMetricContext(), "gobblin.yarn").build();
    }

    private void requestInitialContainers(int containersRequested) {
        for (int i = 0; i < containersRequested; ++i) {
            this.requestContainer((Optional<String>)Optional.absent());
        }
    }

    private void requestContainer(Optional<String> preferredNode) {
        String[] stringArray;
        Priority priority = (Priority)Records.newRecord(Priority.class);
        priority.setPriority(0);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        int maxMemoryCapacity = ((Resource)this.maxResourceCapacity.get()).getMemory();
        capability.setMemory(this.requestedContainerMemoryMbs <= maxMemoryCapacity ? this.requestedContainerMemoryMbs : maxMemoryCapacity);
        int maxCoreCapacity = ((Resource)this.maxResourceCapacity.get()).getVirtualCores();
        capability.setVirtualCores(this.requestedContainerCores <= maxCoreCapacity ? this.requestedContainerCores : maxCoreCapacity);
        if (preferredNode.isPresent()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = (String)preferredNode.get();
        } else {
            stringArray = null;
        }
        String[] preferredNodes = stringArray;
        this.amrmClientAsync.addContainerRequest(new AMRMClient.ContainerRequest(capability, preferredNodes, null, priority));
    }

    private ContainerLaunchContext newContainerLaunchContext(Container container, String helixInstanceName) throws IOException {
        Path appWorkDir = GobblinClusterUtils.getAppWorkDirPath((FileSystem)this.fs, (String)this.applicationName, (String)this.applicationId);
        Path containerWorkDir = new Path(appWorkDir, "container");
        HashMap resourceMap = Maps.newHashMap();
        this.addContainerLocalResources(new Path(appWorkDir, "_libjars"), resourceMap);
        this.addContainerLocalResources(new Path(containerWorkDir, "_appjars"), resourceMap);
        this.addContainerLocalResources(new Path(containerWorkDir, "_appfiles"), resourceMap);
        if (this.config.hasPath("gobblin.yarn.container.files.remote")) {
            this.addRemoteAppFiles(this.config.getString("gobblin.yarn.container.files.remote"), resourceMap);
        }
        ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        containerLaunchContext.setLocalResources((Map)resourceMap);
        containerLaunchContext.setEnvironment(YarnHelixUtils.getEnvironmentVariables(this.yarnConfiguration));
        containerLaunchContext.setCommands((List)Lists.newArrayList((Object[])new String[]{this.buildContainerCommand(container, helixInstanceName)}));
        if (UserGroupInformation.isSecurityEnabled()) {
            containerLaunchContext.setTokens(this.tokens.duplicate());
        }
        return containerLaunchContext;
    }

    private void addContainerLocalResources(Path destDir, Map<String, LocalResource> resourceMap) throws IOException {
        if (!this.fs.exists(destDir)) {
            LOGGER.warn(String.format("Path %s does not exist so no container LocalResource to add", destDir));
            return;
        }
        FileStatus[] statuses = this.fs.listStatus(destDir);
        if (statuses != null) {
            for (FileStatus status : statuses) {
                YarnHelixUtils.addFileAsLocalResource(this.fs, status.getPath(), LocalResourceType.FILE, resourceMap);
            }
        }
    }

    private void addRemoteAppFiles(String hdfsFileList, Map<String, LocalResource> resourceMap) throws IOException {
        for (String hdfsFilePath : SPLITTER.split((CharSequence)hdfsFileList)) {
            Path srcFilePath = new Path(hdfsFilePath);
            YarnHelixUtils.addFileAsLocalResource(srcFilePath.getFileSystem(this.yarnConfiguration), srcFilePath, LocalResourceType.FILE, resourceMap);
        }
    }

    private ByteBuffer getSecurityTokens() throws IOException {
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        try (Closer closer = Closer.create();){
            DataOutputBuffer dataOutputBuffer = (DataOutputBuffer)closer.register((Closeable)new DataOutputBuffer());
            credentials.writeTokenStorageToStream((DataOutputStream)dataOutputBuffer);
            Iterator tokenIterator = credentials.getAllTokens().iterator();
            while (tokenIterator.hasNext()) {
                Token token = (Token)tokenIterator.next();
                if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
                tokenIterator.remove();
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(dataOutputBuffer.getData(), 0, dataOutputBuffer.getLength());
            return byteBuffer;
        }
    }

    private String buildContainerCommand(Container container, String helixInstanceName) {
        String containerProcessName = GobblinYarnTaskRunner.class.getSimpleName();
        return ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java" + " -Xmx" + container.getResource().getMemory() + "M" + " " + JvmUtils.formatJvmArguments(this.containerJvmArgs) + " " + GobblinYarnTaskRunner.class.getName() + " --" + "app_name" + " " + this.applicationName + " --" + "helix_instance_name" + " " + helixInstanceName + " 1>" + "<LOG_DIR>" + File.separator + containerProcessName + "." + "stdout" + " 2>" + "<LOG_DIR>" + File.separator + containerProcessName + "." + "stderr";
    }

    private boolean shouldStickToTheSameNode(int containerExitStatus) {
        switch (containerExitStatus) {
            case -101: {
                return false;
            }
            case -100: {
                return false;
            }
        }
        return this.containerHostAffinityEnabled;
    }

    private void handleContainerCompletion(ContainerStatus containerStatus) {
        Map.Entry completedContainerEntry = (Map.Entry)this.containerMap.remove(containerStatus.getContainerId());
        String completedInstanceName = (String)completedContainerEntry.getValue();
        LOGGER.info(String.format("Container %s running Helix instance %s has completed with exit status %d", containerStatus.getContainerId(), completedInstanceName, containerStatus.getExitStatus()));
        if (!Strings.isNullOrEmpty((String)containerStatus.getDiagnostics())) {
            LOGGER.info(String.format("Received the following diagnostics information for container %s: %s", containerStatus.getContainerId(), containerStatus.getDiagnostics()));
        }
        if (this.shutdownInProgress) {
            return;
        }
        this.helixInstanceRetryCount.putIfAbsent(completedInstanceName, new AtomicInteger(0));
        int retryCount = ((AtomicInteger)this.helixInstanceRetryCount.get(completedInstanceName)).incrementAndGet();
        Optional eventMetadataBuilder = Optional.absent();
        if (this.eventSubmitter.isPresent()) {
            eventMetadataBuilder = Optional.of(this.buildContainerStatusEventMetadata(containerStatus));
            ((ImmutableMap.Builder)eventMetadataBuilder.get()).put((Object)"helixInstanceId", (Object)completedInstanceName);
            ((ImmutableMap.Builder)eventMetadataBuilder.get()).put((Object)"containerStatus.retryAttempt", (Object)(retryCount + ""));
        }
        if (this.helixInstanceMaxRetries > 0 && retryCount > this.helixInstanceMaxRetries) {
            if (this.eventSubmitter.isPresent()) {
                ((EventSubmitter)this.eventSubmitter.get()).submit("HelixInstanceCompletion", (Map)((ImmutableMap.Builder)eventMetadataBuilder.get()).build());
            }
            LOGGER.warn("Maximum number of retries has been achieved for Helix instance " + completedInstanceName);
            return;
        }
        this.unusedHelixInstanceNames.offer(completedInstanceName);
        if (this.eventSubmitter.isPresent()) {
            ((EventSubmitter)this.eventSubmitter.get()).submit("HelixInstanceCompletion", (Map)((ImmutableMap.Builder)eventMetadataBuilder.get()).build());
        }
        LOGGER.info(String.format("Requesting a new container to replace %s to run Helix instance %s", containerStatus.getContainerId(), completedInstanceName));
        this.eventBus.post((Object)new NewContainerRequest((Optional<Container>)(this.shouldStickToTheSameNode(containerStatus.getExitStatus()) ? Optional.of(completedContainerEntry.getKey()) : Optional.absent())));
    }

    private ImmutableMap.Builder<String, String> buildContainerStatusEventMetadata(ContainerStatus containerStatus) {
        ImmutableMap.Builder eventMetadataBuilder = new ImmutableMap.Builder();
        eventMetadataBuilder.put((Object)"yarn.container.id", (Object)containerStatus.getContainerId().toString());
        eventMetadataBuilder.put((Object)"containerStatus.state", (Object)containerStatus.getState().toString());
        if (-1000 != containerStatus.getExitStatus()) {
            eventMetadataBuilder.put((Object)"containerStatus.exitStatus", (Object)(containerStatus.getExitStatus() + ""));
        }
        if (!Strings.isNullOrEmpty((String)containerStatus.getDiagnostics())) {
            eventMetadataBuilder.put((Object)"containerStatus.diagnostics", (Object)containerStatus.getDiagnostics());
        }
        return eventMetadataBuilder;
    }

    private class NMClientCallbackHandler
    implements NMClientAsync.CallbackHandler {
        private NMClientCallbackHandler() {
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ContainerStarted", new String[]{"yarn.container.id", containerId.toString()});
            }
            LOGGER.info(String.format("Container %s has been started", containerId));
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ContainerStatusReceived", (Map)YarnService.this.buildContainerStatusEventMetadata(containerStatus).build());
            }
            LOGGER.info(String.format("Received container status for container %s: %s", containerId, containerStatus));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onContainerStopped(ContainerId containerId) {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ContainerStopped", new String[]{"yarn.container.id", containerId.toString()});
            }
            LOGGER.info(String.format("Container %s has been stopped", containerId));
            YarnService.this.containerMap.remove(containerId);
            if (YarnService.this.containerMap.isEmpty()) {
                Object object = YarnService.this.allContainersStopped;
                synchronized (object) {
                    YarnService.this.allContainersStopped.notify();
                }
            }
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ContainerStartError", new String[]{"yarn.container.id", containerId.toString(), "errorException", Throwables.getStackTraceAsString((Throwable)t)});
            }
            LOGGER.error(String.format("Failed to start container %s due to error %s", containerId, t));
            YarnService.this.containerMap.remove(containerId);
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ContainerGetStatusError", new String[]{"yarn.container.id", containerId.toString(), "errorException", Throwables.getStackTraceAsString((Throwable)t)});
            }
            LOGGER.error(String.format("Failed to get status for container %s due to error %s", containerId, t));
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ContainerStopError", new String[]{"yarn.container.id", containerId.toString(), "errorException", Throwables.getStackTraceAsString((Throwable)t)});
            }
            LOGGER.error(String.format("Failed to stop container %s due to error %s", containerId, t));
        }
    }

    private class AMRMClientCallbackHandler
    implements AMRMClientAsync.CallbackHandler {
        private volatile boolean done = false;

        private AMRMClientCallbackHandler() {
        }

        public void onContainersCompleted(List<ContainerStatus> statuses) {
            for (ContainerStatus containerStatus : statuses) {
                YarnService.this.handleContainerCompletion(containerStatus);
            }
        }

        public void onContainersAllocated(List<Container> containers) {
            for (final Container container : containers) {
                if (YarnService.this.eventSubmitter.isPresent()) {
                    ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ContainerAllocation", new String[]{"yarn.container.id", container.getId().toString()});
                }
                LOGGER.info(String.format("Container %s has been allocated", container.getId()));
                String instanceName = (String)YarnService.this.unusedHelixInstanceNames.poll();
                if (Strings.isNullOrEmpty((String)instanceName)) {
                    instanceName = HelixUtils.getHelixInstanceName((String)GobblinYarnTaskRunner.class.getSimpleName(), (int)YarnService.this.helixInstanceIdGenerator.incrementAndGet());
                }
                final String finalInstanceName = instanceName;
                YarnService.this.containerMap.put(container.getId(), new AbstractMap.SimpleImmutableEntry<Container, String>(container, finalInstanceName));
                YarnService.this.containerLaunchExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOGGER.info("Starting container " + container.getId());
                            YarnService.this.nmClientAsync.startContainerAsync(container, YarnService.this.newContainerLaunchContext(container, finalInstanceName));
                        }
                        catch (IOException ioe) {
                            LOGGER.error("Failed to start container " + container.getId(), (Throwable)ioe);
                        }
                    }
                });
            }
        }

        public void onShutdownRequest() {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("ShutdownRequest");
            }
            LOGGER.info("Received shutdown request from the ResourceManager");
            this.done = true;
            YarnService.this.eventBus.post((Object)new ClusterManagerShutdownRequest());
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
            for (NodeReport nodeReport : updatedNodes) {
                LOGGER.info("Received node update report: " + nodeReport);
            }
        }

        public float getProgress() {
            return this.done ? 1.0f : 0.0f;
        }

        public void onError(Throwable t) {
            if (YarnService.this.eventSubmitter.isPresent()) {
                ((EventSubmitter)YarnService.this.eventSubmitter.get()).submit("Error", new String[]{"errorException", Throwables.getStackTraceAsString((Throwable)t)});
            }
            LOGGER.error("Received error: " + t, t);
            this.done = true;
            YarnService.this.eventBus.post((Object)new ClusterManagerShutdownRequest());
        }
    }
}

