/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive;

import java.io.IOException;
import org.apache.gobblin.compaction.hive.HdfsIO;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsWriter
extends HdfsIO {
    public HdfsWriter(String filePathInHdfs) throws IOException {
        super(filePathInHdfs);
    }

    public void write(String text) throws IOException {
        String dirInHdfs = this.getDirInHdfs();
        this.fileSystem.mkdirs(new Path(dirInHdfs));
        try (FSDataOutputStream fout = this.fileSystem.create(new Path(this.filePathInHdfs));){
            fout.writeChars(text);
        }
    }

    private String getDirInHdfs() {
        return new Path(this.filePathInHdfs).getParent().toString();
    }

    public boolean delete() throws IllegalArgumentException, IOException {
        return this.fileSystem.delete(new Path(this.filePathInHdfs), true);
    }

    public static void moveSelectFiles(String extension, String source, String destination) throws IOException {
        FileStatus[] fileStatuses;
        FileSystem fs = HdfsWriter.getFileSystem();
        fs.mkdirs(new Path(destination));
        for (FileStatus fileStatus : fileStatuses = fs.listStatus(new Path(source))) {
            Path path = fileStatus.getPath();
            if (fileStatus.isDirectory() || !path.toString().toLowerCase().endsWith(extension.toLowerCase())) continue;
            HadoopUtils.deleteIfExists((FileSystem)fs, (Path)new Path(destination), (boolean)true);
            HadoopUtils.copyPath((FileSystem)fs, (Path)path, (FileSystem)fs, (Path)new Path(destination), (Configuration)HdfsWriter.getConfiguration());
        }
    }
}

