/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.specific.SpecificRecord;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.metrics.reporter.util.AvroBinarySerializer;
import org.apache.gobblin.metrics.reporter.util.AvroSerializer;
import org.apache.gobblin.metrics.reporter.util.FixedSchemaVersionWriter;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.runtime.job_spec.AvroJobSpec;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.AsyncDataWriter;
import org.apache.gobblin.writer.WriteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SimpleKafkaSpecProducer
implements SpecProducer<Spec>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(SimpleKafkaSpecProducer.class);
    private static final String KAFKA_DATA_WRITER_CLASS_KEY = "spec.kafka.dataWriterClass";
    private static final String DEFAULT_KAFKA_DATA_WRITER_CLASS = "org.apache.gobblin.kafka.writer.Kafka08DataWriter";
    protected AsyncDataWriter<byte[]> _kafkaProducer;
    private final AvroSerializer<AvroJobSpec> _serializer;
    private Config _config;
    private final String _kafkaProducerClassName;

    public SimpleKafkaSpecProducer(Config config, Optional<Logger> log) {
        this._kafkaProducerClassName = ConfigUtils.getString((Config)config, (String)KAFKA_DATA_WRITER_CLASS_KEY, (String)DEFAULT_KAFKA_DATA_WRITER_CLASS);
        try {
            this._serializer = new AvroBinarySerializer(AvroJobSpec.SCHEMA$, (SchemaVersionWriter)new FixedSchemaVersionWriter());
            this._config = config;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create AvroBinarySerializer", e);
        }
    }

    public SimpleKafkaSpecProducer(Config config, Logger log) {
        this(config, (Optional<Logger>)Optional.of((Object)log));
    }

    public SimpleKafkaSpecProducer(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public Future<?> addSpec(Spec addedSpec) {
        AvroJobSpec avroJobSpec = this.convertToAvroJobSpec(addedSpec, SpecExecutor.Verb.ADD);
        log.info("Adding Spec: " + addedSpec + " using Kafka.");
        return this.getKafkaProducer().write((Object)this._serializer.serializeRecord((SpecificRecord)avroJobSpec), WriteCallback.EMPTY);
    }

    public Future<?> updateSpec(Spec updatedSpec) {
        AvroJobSpec avroJobSpec = this.convertToAvroJobSpec(updatedSpec, SpecExecutor.Verb.UPDATE);
        log.info("Updating Spec: " + updatedSpec + " using Kafka.");
        return this.getKafkaProducer().write((Object)this._serializer.serializeRecord((SpecificRecord)avroJobSpec), WriteCallback.EMPTY);
    }

    public Future<?> deleteSpec(URI deletedSpecURI) {
        AvroJobSpec avroJobSpec = AvroJobSpec.newBuilder().setUri(deletedSpecURI.toString()).setMetadata((Map)ImmutableMap.of((Object)"Verb", (Object)SpecExecutor.Verb.DELETE.name())).build();
        log.info("Deleting Spec: " + deletedSpecURI + " using Kafka.");
        return this.getKafkaProducer().write((Object)this._serializer.serializeRecord((SpecificRecord)avroJobSpec), WriteCallback.EMPTY);
    }

    public Future<? extends List<Spec>> listSpecs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this._kafkaProducer.close();
    }

    private AsyncDataWriter<byte[]> getKafkaProducer() {
        if (null == this._kafkaProducer) {
            try {
                Class<?> kafkaProducerClass = Class.forName(this._kafkaProducerClassName);
                this._kafkaProducer = (AsyncDataWriter)ConstructorUtils.invokeConstructor(kafkaProducerClass, (Object[])new Object[]{ConfigUtils.configToProperties((Config)this._config)});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Failed to instantiate Kafka consumer from class " + this._kafkaProducerClassName, (Throwable)e);
                throw new RuntimeException("Failed to instantiate Kafka consumer", e);
            }
        }
        return this._kafkaProducer;
    }

    private AvroJobSpec convertToAvroJobSpec(Spec spec, SpecExecutor.Verb verb) {
        if (spec instanceof JobSpec) {
            JobSpec jobSpec = (JobSpec)spec;
            AvroJobSpec.Builder avroJobSpecBuilder = AvroJobSpec.newBuilder();
            avroJobSpecBuilder.setUri(jobSpec.getUri().toString()).setVersion(jobSpec.getVersion()).setDescription(jobSpec.getDescription()).setProperties((Map)Maps.fromProperties((Properties)jobSpec.getConfigAsProperties())).setMetadata((Map)ImmutableMap.of((Object)"Verb", (Object)verb.name()));
            if (jobSpec.getTemplateURI().isPresent()) {
                avroJobSpecBuilder.setTemplateUri(((URI)jobSpec.getTemplateURI().get()).toString());
            }
            return avroJobSpecBuilder.build();
        }
        throw new RuntimeException("Unsupported spec type " + spec.getClass());
    }
}

