/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecConsumer;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.job_monitor.AvroJobSpecKafkaJobMonitor;
import org.apache.gobblin.runtime.std.DefaultJobCatalogListenerImpl;
import org.apache.gobblin.util.CompletedFuture;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingKafkaSpecConsumer
extends AbstractIdleService
implements SpecConsumer<Spec>,
Closeable,
StandardMetricsBridge {
    private static final Logger log = LoggerFactory.getLogger(StreamingKafkaSpecConsumer.class);
    public static final String SPEC_STREAMING_BLOCKING_QUEUE_SIZE = "spec.StreamingBlockingQueueSize";
    private static final int DEFAULT_SPEC_STREAMING_BLOCKING_QUEUE_SIZE = 100;
    private final AvroJobSpecKafkaJobMonitor _jobMonitor;
    private final BlockingQueue<ImmutablePair<SpecExecutor.Verb, Spec>> _jobSpecQueue;
    private final MutableJobCatalog _jobCatalog;
    private final MetricContext _metricContext;
    private final Metrics _metrics;
    private final boolean _isInstrumentedEnabled;

    public StreamingKafkaSpecConsumer(Config config, MutableJobCatalog jobCatalog, Optional<Logger> log) {
        String topic = config.getString("spec.kafka.topics");
        Config defaults = ConfigFactory.parseMap((Map)ImmutableMap.of((Object)"topic", (Object)topic, (Object)"jobSpecMonitor.kafka.auto.offset.reset", (Object)"smallest"));
        try {
            this._jobMonitor = (AvroJobSpecKafkaJobMonitor)new AvroJobSpecKafkaJobMonitor.Factory().forConfig(config.withFallback((ConfigMergeable)defaults), jobCatalog);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create job monitor", e);
        }
        this._isInstrumentedEnabled = GobblinMetrics.isEnabled((Properties)ConfigUtils.configToProperties((Config)config));
        this._jobCatalog = jobCatalog;
        this._jobSpecQueue = new LinkedBlockingQueue<ImmutablePair<SpecExecutor.Verb, Spec>>(ConfigUtils.getInt((Config)config, (String)"SPEC_STREAMING_BLOCKING_QUEUE_SIZE", (Integer)100));
        this._metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), this.getClass());
        this._metrics = new Metrics(this._metricContext);
    }

    public StreamingKafkaSpecConsumer(Config config, MutableJobCatalog jobCatalog, Logger log) {
        this(config, jobCatalog, (Optional<Logger>)Optional.of((Object)log));
    }

    public StreamingKafkaSpecConsumer(Config config, MutableJobCatalog jobCatalog) {
        this(config, jobCatalog, (Optional<Logger>)Optional.absent());
    }

    public Future<? extends List<Pair<SpecExecutor.Verb, Spec>>> changedSpecs() {
        ArrayList<Pair> changesSpecs = new ArrayList<Pair>();
        try {
            Pair specPair = (Pair)this._jobSpecQueue.take();
            this._metrics.jobSpecDeqCount.incrementAndGet();
            do {
                changesSpecs.add(specPair);
            } while ((specPair = (Pair)this._jobSpecQueue.poll()) != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return new CompletedFuture(changesSpecs, null);
    }

    protected void startUp() {
        this._jobCatalog.addListener((JobCatalogListener)new JobSpecListener());
        this._jobMonitor.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this._jobMonitor.stopAsync().awaitTerminated();
    }

    @Override
    public void close() throws IOException {
        this.shutDown();
    }

    public StandardMetricsBridge.StandardMetrics getStandardMetrics() {
        return this._metrics;
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this._metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return this._isInstrumentedEnabled;
    }

    public AvroJobSpecKafkaJobMonitor get_jobMonitor() {
        return this._jobMonitor;
    }

    private class Metrics
    extends StandardMetricsBridge.StandardMetrics {
        private AtomicLong jobSpecEnqCount = new AtomicLong(0L);
        private AtomicLong jobSpecDeqCount = new AtomicLong(0L);
        public static final String SPEC_CONSUMER_JOB_SPEC_QUEUE_SIZE = "specConsumerJobSpecQueueSize";
        public static final String SPEC_CONSUMER_JOB_SPEC_ENQ = "specConsumerJobSpecEnq";
        public static final String SPEC_CONSUMER_JOB_SPEC_DEQ = "specConsumerJobSpecDeq";
        public static final String SPEC_CONSUMER_JOB_SPEC_CONSUMED = "specConsumerJobSpecConsumed";
        public static final String SPEC_CONSUMER_JOB_SPEC_PARSE_FAILURES = "specConsumerJobSpecParseFailures";

        public Metrics(MetricContext context) {
            this.contextAwareMetrics.add(context.newContextAwareGauge(SPEC_CONSUMER_JOB_SPEC_QUEUE_SIZE, () -> StreamingKafkaSpecConsumer.this._jobSpecQueue.size()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(SPEC_CONSUMER_JOB_SPEC_ENQ, () -> this.jobSpecEnqCount.get()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(SPEC_CONSUMER_JOB_SPEC_DEQ, () -> this.jobSpecDeqCount.get()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(SPEC_CONSUMER_JOB_SPEC_CONSUMED, () -> this.getNewSpecs() + this.getRemovedSpecs() + this.getMessageParseFailures()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(SPEC_CONSUMER_JOB_SPEC_PARSE_FAILURES, () -> this.getMessageParseFailures()));
        }

        private long getNewSpecs() {
            return StreamingKafkaSpecConsumer.this._jobMonitor.getNewSpecs() != null ? StreamingKafkaSpecConsumer.this._jobMonitor.getNewSpecs().getCount() : 0L;
        }

        private long getRemovedSpecs() {
            return StreamingKafkaSpecConsumer.this._jobMonitor.getRemmovedSpecs() != null ? StreamingKafkaSpecConsumer.this._jobMonitor.getRemmovedSpecs().getCount() : 0L;
        }

        private long getMessageParseFailures() {
            return StreamingKafkaSpecConsumer.this._jobMonitor.getMessageParseFailures() != null ? StreamingKafkaSpecConsumer.this._jobMonitor.getMessageParseFailures().getCount() : 0L;
        }
    }

    protected class JobSpecListener
    extends DefaultJobCatalogListenerImpl {
        public JobSpecListener() {
            super(log);
        }

        public void onAddJob(JobSpec addedJob) {
            super.onAddJob(addedJob);
            try {
                StreamingKafkaSpecConsumer.this._jobSpecQueue.put(new ImmutablePair((Object)SpecExecutor.Verb.ADD, (Object)addedJob));
                StreamingKafkaSpecConsumer.this._metrics.jobSpecEnqCount.incrementAndGet();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
            super.onDeleteJob(deletedJobURI, deletedJobVersion);
            try {
                JobSpec.Builder jobSpecBuilder = JobSpec.builder((URI)deletedJobURI);
                Properties props = new Properties();
                jobSpecBuilder.withVersion(deletedJobVersion).withConfigAsProperties(props);
                StreamingKafkaSpecConsumer.this._jobSpecQueue.put(new ImmutablePair((Object)SpecExecutor.Verb.DELETE, (Object)jobSpecBuilder.build()));
                StreamingKafkaSpecConsumer.this._metrics.jobSpecEnqCount.incrementAndGet();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void onUpdateJob(JobSpec updatedJob) {
            super.onUpdateJob(updatedJob);
            try {
                StreamingKafkaSpecConsumer.this._jobSpecQueue.put(new ImmutablePair((Object)SpecExecutor.Verb.UPDATE, (Object)updatedJob));
                StreamingKafkaSpecConsumer.this._metrics.jobSpecEnqCount.incrementAndGet();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

