/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class TransferFsImage {
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String MD5_HEADER = "X-MD5-Digest";
    @VisibleForTesting
    static int timeout = 0;
    private static URLConnectionFactory connectionFactory;
    private static boolean isSpnegoEnabled;
    private static final Log LOG;

    public static void downloadMostRecentImageToDirectory(URL infoServer, File dir) throws IOException {
        String fileId = GetImageServlet.getParamStringForMostRecentImage();
        TransferFsImage.getFileClient(infoServer, fileId, Lists.newArrayList((Object[])new File[]{dir}), null, false);
    }

    public static MD5Hash downloadImageToStorage(URL fsName, long imageTxId, Storage dstStorage, boolean needDigest) throws IOException {
        String fileid = GetImageServlet.getParamStringForImage(imageTxId, dstStorage);
        String fileName = NNStorage.getCheckpointImageFileName(imageTxId);
        List<File> dstFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.IMAGE, fileName);
        if (dstFiles.isEmpty()) {
            throw new IOException("No targets in destination storage!");
        }
        MD5Hash hash = TransferFsImage.getFileClient(fsName, fileid, dstFiles, dstStorage, needDigest);
        LOG.info((Object)("Downloaded file " + dstFiles.get(0).getName() + " size " + dstFiles.get(0).length() + " bytes."));
        return hash;
    }

    static void downloadEditsToStorage(URL fsName, RemoteEditLog log, NNStorage dstStorage) throws IOException {
        assert (log.getStartTxId() > 0L && log.getEndTxId() > 0L) : "bad log: " + log;
        String fileid = GetImageServlet.getParamStringForLog(log, dstStorage);
        String finalFileName = NNStorage.getFinalizedEditsFileName(log.getStartTxId(), log.getEndTxId());
        List<File> finalFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.EDITS, finalFileName);
        assert (!finalFiles.isEmpty()) : "No checkpoint targets.";
        for (File f : finalFiles) {
            if (f.exists() && FileUtil.canRead((File)f)) {
                LOG.info((Object)("Skipping download of remote edit log " + log + " since it already is stored locally at " + f));
                return;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Dest file: " + f));
        }
        long milliTime = System.currentTimeMillis();
        String tmpFileName = NNStorage.getTemporaryEditsFileName(log.getStartTxId(), log.getEndTxId(), milliTime);
        List<File> tmpFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.EDITS, tmpFileName);
        TransferFsImage.getFileClient(fsName, fileid, tmpFiles, dstStorage, false);
        LOG.info((Object)("Downloaded file " + tmpFiles.get(0).getName() + " size " + finalFiles.get(0).length() + " bytes."));
        CheckpointFaultInjector.getInstance().beforeEditsRename();
        for (Storage.StorageDirectory sd : dstStorage.dirIterable(NNStorage.NameNodeDirType.EDITS)) {
            boolean success;
            File tmpFile = NNStorage.getTemporaryEditsFile(sd, log.getStartTxId(), log.getEndTxId(), milliTime);
            File finalizedFile = NNStorage.getFinalizedEditsFile(sd, log.getStartTxId(), log.getEndTxId());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Renaming " + tmpFile + " to " + finalizedFile));
            }
            if (success = tmpFile.renameTo(finalizedFile)) continue;
            LOG.warn((Object)("Unable to rename edits file from " + tmpFile + " to " + finalizedFile));
        }
    }

    public static void uploadImageFromStorage(URL fsName, URL myNNAddress, Storage storage, long txid) throws IOException {
        String fileid = GetImageServlet.getParamStringToPutImage(txid, myNNAddress, storage);
        try {
            TransferFsImage.getFileClient(fsName, fileid, null, null, false);
        }
        catch (HttpGetFailedException e) {
            if (e.getResponseCode() == 409) {
                LOG.info((Object)("Image upload with txid " + txid + " conflicted with a previous image upload to the " + "same NameNode. Continuing..."), (Throwable)e);
                return;
            }
            throw e;
        }
        LOG.info((Object)("Uploaded image with txid " + txid + " to namenode at " + fsName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFileServer(ServletResponse response, File localfile, FileInputStream infile, DataTransferThrottler throttler) throws IOException {
        byte[] buf = new byte[HdfsConstants.IO_FILE_BUFFER_SIZE];
        ServletOutputStream out = null;
        try {
            CheckpointFaultInjector.getInstance().aboutToSendFile(localfile);
            out = response.getOutputStream();
            if (CheckpointFaultInjector.getInstance().shouldSendShortFile(localfile)) {
                long len = localfile.length();
                buf = new byte[(int)Math.min(len / 2L, (long)HdfsConstants.IO_FILE_BUFFER_SIZE)];
                infile.read(buf);
            }
            int num = 1;
            while (num > 0) {
                num = infile.read(buf);
                if (num <= 0) {
                    break;
                }
                if (CheckpointFaultInjector.getInstance().shouldCorruptAByte(localfile)) {
                    LOG.warn((Object)"SIMULATING A CORRUPT BYTE IN IMAGE TRANSFER!");
                    buf[0] = (byte)(buf[0] + 1);
                }
                out.write(buf, 0, num);
                if (throttler == null) continue;
                throttler.throttle(num);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    static MD5Hash getFileClient(URL infoServer, String queryString, List<File> localPaths, Storage dstStorage, boolean getChecksum) throws IOException {
        URL url = new URL(infoServer, "/getimage?" + queryString);
        LOG.info((Object)("Opening connection to " + url));
        return TransferFsImage.doGetUrl(url, localPaths, dstStorage, getChecksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MD5Hash doGetUrl(URL url, List<File> localPaths, Storage dstStorage, boolean getChecksum) throws IOException {
        HttpURLConnection connection;
        long startTime = Time.monotonicNow();
        try {
            connection = (HttpURLConnection)connectionFactory.openConnection(url, isSpnegoEnabled);
        }
        catch (AuthenticationException e) {
            throw new IOException(e);
        }
        if (timeout <= 0) {
            HdfsConfiguration conf = new HdfsConfiguration();
            timeout = conf.getInt("dfs.image.transfer.timeout", 600000);
        }
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }
        if (connection.getResponseCode() != 200) {
            throw new HttpGetFailedException("Image transfer servlet at " + url + " failed with status code " + connection.getResponseCode() + "\nResponse message:\n" + connection.getResponseMessage(), connection);
        }
        String contentLength = connection.getHeaderField(CONTENT_LENGTH);
        if (contentLength == null) {
            throw new IOException("Content-Length header is not provided by the namenode when trying to fetch " + url);
        }
        long advertisedSize = Long.parseLong(contentLength);
        if (localPaths != null) {
            String fsImageName = connection.getHeaderField("X-Image-Edits-Name");
            ArrayList<File> newLocalPaths = new ArrayList<File>();
            for (File localPath : localPaths) {
                if (localPath.isDirectory()) {
                    if (fsImageName == null) {
                        throw new IOException("No filename header provided by server");
                    }
                    newLocalPaths.add(new File(localPath, fsImageName));
                    continue;
                }
                newLocalPaths.add(localPath);
            }
            localPaths = newLocalPaths;
        }
        MD5Hash advertisedDigest = TransferFsImage.parseMD5Header(connection);
        long received = 0L;
        InputStream stream = connection.getInputStream();
        MessageDigest digester = null;
        if (getChecksum) {
            digester = MD5Hash.getDigester();
            stream = new DigestInputStream(stream, digester);
        }
        boolean finishedReceiving = false;
        ArrayList outputStreams = Lists.newArrayList();
        try {
            if (localPaths != null) {
                for (File f : localPaths) {
                    try {
                        if (f.exists()) {
                            LOG.warn((Object)("Overwriting existing file " + f + " with file downloaded from " + url));
                        }
                        outputStreams.add(new FileOutputStream(f));
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Unable to download file " + f), (Throwable)ioe);
                        if (dstStorage == null || !(dstStorage instanceof StorageErrorReporter)) continue;
                        ((StorageErrorReporter)((Object)dstStorage)).reportErrorOnFile(f);
                    }
                }
                if (outputStreams.isEmpty()) {
                    throw new IOException("Unable to download to any storage directory");
                }
            }
            int num = 1;
            byte[] buf = new byte[HdfsConstants.IO_FILE_BUFFER_SIZE];
            while (num > 0) {
                num = stream.read(buf);
                if (num <= 0) continue;
                received += (long)num;
                for (FileOutputStream fos : outputStreams) {
                    fos.write(buf, 0, num);
                }
            }
            finishedReceiving = true;
        }
        finally {
            stream.close();
            for (FileOutputStream fos : outputStreams) {
                fos.getChannel().force(true);
                fos.close();
            }
            if (finishedReceiving && received != advertisedSize) {
                throw new IOException("File " + url + " received length " + received + " is not of the advertised size " + advertisedSize);
            }
        }
        double xferSec = Math.max((double)(Time.monotonicNow() - startTime) / 1000.0, 0.001);
        long xferKb = received / 1024L;
        LOG.info((Object)String.format("Transfer took %.2fs at %.2f KB/s", xferSec, (double)xferKb / xferSec));
        if (digester != null) {
            MD5Hash computedDigest = new MD5Hash(digester.digest());
            if (advertisedDigest != null && !computedDigest.equals((Object)advertisedDigest)) {
                throw new IOException("File " + url + " computed digest " + computedDigest + " does not match advertised digest " + advertisedDigest);
            }
            return computedDigest;
        }
        return null;
    }

    private static MD5Hash parseMD5Header(HttpURLConnection connection) {
        String header = connection.getHeaderField(MD5_HEADER);
        return header != null ? new MD5Hash(header) : null;
    }

    static {
        Configuration conf = new Configuration();
        connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory(conf);
        isSpnegoEnabled = UserGroupInformation.isSecurityEnabled();
        LOG = LogFactory.getLog(TransferFsImage.class);
    }

    public static class HttpGetFailedException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final int responseCode;

        HttpGetFailedException(String msg, HttpURLConnection connection) throws IOException {
            super(msg);
            this.responseCode = connection.getResponseCode();
        }

        public int getResponseCode() {
            return this.responseCode;
        }
    }
}

