/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.csv;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.source.extractor.utils.InputStreamCSVReader;

public class CsvToJsonConverter
extends Converter<String, JsonArray, String, JsonObject> {
    private static final String NULL = "null";

    public JsonArray convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonSchema = jsonParser.parse(inputSchema);
        return jsonSchema.getAsJsonArray();
    }

    public Iterable<JsonObject> convertRecord(JsonArray outputSchema, String inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            String strDelimiter = workUnit.getProp("converter.csv.to.json.delimiter");
            if (Strings.isNullOrEmpty((String)strDelimiter)) {
                throw new IllegalArgumentException("Delimiter cannot be empty");
            }
            InputStreamCSVReader reader = new InputStreamCSVReader(inputRecord, strDelimiter.charAt(0), workUnit.getProp("converter.csv.to.json.enclosedchar", "\u0000").charAt(0));
            ArrayList recordSplit = Lists.newArrayList(reader.splitRecord());
            JsonObject outputRecord = new JsonObject();
            for (int i = 0; i < outputSchema.size(); ++i) {
                if (i < recordSplit.size()) {
                    if (recordSplit.get(i) == null) {
                        outputRecord.add(outputSchema.get(i).getAsJsonObject().get("columnName").getAsString(), (JsonElement)JsonNull.INSTANCE);
                        continue;
                    }
                    if (((String)recordSplit.get(i)).isEmpty() || ((String)recordSplit.get(i)).toLowerCase().equals(NULL)) {
                        outputRecord.add(outputSchema.get(i).getAsJsonObject().get("columnName").getAsString(), (JsonElement)JsonNull.INSTANCE);
                        continue;
                    }
                    outputRecord.addProperty(outputSchema.get(i).getAsJsonObject().get("columnName").getAsString(), (String)recordSplit.get(i));
                    continue;
                }
                outputRecord.add(outputSchema.get(i).getAsJsonObject().get("columnName").getAsString(), (JsonElement)JsonNull.INSTANCE);
            }
            return new SingleRecordIterable((Object)outputRecord);
        }
        catch (Exception e) {
            throw new DataConversionException((Throwable)e);
        }
    }
}

