/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.filebased;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.opencsv.CSVReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.filebased.FileBasedExtractor;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.FileDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFileDownloader
extends FileDownloader<String[]> {
    private static final Logger log = LoggerFactory.getLogger(CsvFileDownloader.class);
    public static final String CSV_DOWNLOADER_PREFIX = "source.csv_file.";
    public static final String SKIP_TOP_ROWS_REGEX = "source.csv_file.skip_top_rows_regex";
    public static final String DELIMITER = "source.csv_file.delimiter";

    public CsvFileDownloader(FileBasedExtractor<?, ?> fileBasedExtractor) {
        super(fileBasedExtractor);
    }

    @Override
    public Iterator<String[]> downloadFile(String file) throws IOException {
        CSVReader reader;
        log.info("Beginning to download file: " + file);
        WorkUnitState state = this.fileBasedExtractor.workUnitState;
        try {
            if (state.contains(DELIMITER)) {
                String delimiterStr = state.getProp(DELIMITER).trim();
                Preconditions.checkArgument((delimiterStr.length() == 1 ? 1 : 0) != 0, (Object)"Delimiter should be a character.");
                char delimiter = delimiterStr.charAt(0);
                log.info("Using " + delimiter + " as a delimiter.");
                reader = (CSVReader)this.fileBasedExtractor.getCloser().register((Closeable)new CSVReader((Reader)new InputStreamReader(this.fileBasedExtractor.getFsHelper().getFileStream(file), ConfigurationKeys.DEFAULT_CHARSET_ENCODING), delimiter));
            } else {
                reader = (CSVReader)this.fileBasedExtractor.getCloser().register((Closeable)new CSVReader((Reader)new InputStreamReader(this.fileBasedExtractor.getFsHelper().getFileStream(file), ConfigurationKeys.DEFAULT_CHARSET_ENCODING)));
            }
        }
        catch (FileBasedHelperException e) {
            throw new IOException(e);
        }
        PeekingIterator iterator = Iterators.peekingIterator((Iterator)reader.iterator());
        if (state.contains(SKIP_TOP_ROWS_REGEX)) {
            String[] row;
            String regex = state.getProp(SKIP_TOP_ROWS_REGEX);
            log.info("Trying to skip with regex: " + regex);
            while (iterator.hasNext() && (row = (String[])iterator.peek()).length != 0 && row[0].matches(regex)) {
                iterator.next();
            }
        }
        if (this.fileBasedExtractor.isShouldSkipFirstRecord() && iterator.hasNext()) {
            log.info("Skipping first record");
            iterator.next();
        }
        return iterator;
    }
}

