/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.hadoop;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.TimestampAwareFileBasedHelper;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.ProxiedFileSystemWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

public class HadoopFsHelper
implements TimestampAwareFileBasedHelper {
    private final State state;
    private final Configuration configuration;
    private FileSystem fs;

    public HadoopFsHelper(State state) {
        this(state, HadoopUtils.getConfFromState((State)state));
    }

    public HadoopFsHelper(State state, Configuration configuration) {
        this.state = state;
        this.configuration = configuration;
    }

    protected State getState() {
        return this.state;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public void connect() throws FileBasedHelperException {
        String uri = this.state.getProp("source.filebased.fs.uri");
        try {
            if (Strings.isNullOrEmpty((String)uri)) {
                throw new FileBasedHelperException("source.filebased.fs.uri has not been configured");
            }
            this.createFileSystem(uri);
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Cannot connect to given URI " + uri + " due to " + e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new FileBasedHelperException("Malformed uri " + uri + " due to " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new FileBasedHelperException("Interrupted exception is caught when getting the proxy file system", e);
        }
    }

    @Override
    public List<String> ls(String path) throws FileBasedHelperException {
        ArrayList<String> results = new ArrayList<String>();
        try {
            this.lsr(new Path(path), results);
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Cannot do ls on path " + path + " due to " + e.getMessage(), e);
        }
        return results;
    }

    public void lsr(Path p, List<String> results) throws IOException {
        if (!this.fs.getFileStatus(p).isDirectory()) {
            results.add(p.toString());
        }
        Path qualifiedPath = this.fs.makeQualified(p);
        for (FileStatus status : this.fs.listStatus(p)) {
            if (status.isDirectory()) {
                if (qualifiedPath.equals((Object)status.getPath())) continue;
                this.lsr(status.getPath(), results);
                continue;
            }
            results.add(status.getPath().toString());
        }
    }

    private void createFileSystem(String uri) throws IOException, InterruptedException, URISyntaxException {
        this.fs = this.state.getPropAsBoolean("should.fs.proxy.as.user", false) ? new ProxiedFileSystemWrapper().getProxiedFileSystem(this.state, ProxiedFileSystemWrapper.AuthType.TOKEN, this.state.getProp("fs.proxy.as.user.token.file"), uri, this.configuration) : FileSystem.newInstance((URI)URI.create(uri), (Configuration)this.configuration);
    }

    @Override
    public long getFileMTime(String filePath) throws FileBasedHelperException {
        try {
            return this.getFileSystem().getFileStatus(new Path(filePath)).getModificationTime();
        }
        catch (IOException e) {
            throw new FileBasedHelperException(String.format("Failed to get last modified time for file at path %s due to error %s", filePath, e.getMessage()), e);
        }
    }

    @Override
    public long getFileSize(String filePath) throws FileBasedHelperException {
        try {
            return this.getFileSystem().getFileStatus(new Path(filePath)).getLen();
        }
        catch (IOException e) {
            throw new FileBasedHelperException(String.format("Failed to get size for file at path %s due to error %s", filePath, e.getMessage()), e);
        }
    }

    @Override
    public InputStream getFileStream(String path) throws FileBasedHelperException {
        try {
            Path p = new Path(path);
            FSDataInputStream in = this.getFileSystem().open(p);
            CompressionCodecFactory factory = new CompressionCodecFactory(this.getFileSystem().getConf());
            CompressionCodec codec = factory.getCodec(p);
            return codec == null ? in : codec.createInputStream((InputStream)in);
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Cannot open file " + path + " due to " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.getFileSystem().close();
    }
}

