/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.watermark;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.gobblin.source.extractor.extract.QueryBasedExtractor;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Watermark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampWatermark
implements Watermark {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampWatermark.class);
    private static final String INPUTFORMAT = "yyyyMMddHHmmss";
    private final SimpleDateFormat inputFormatParser;
    private static final int deltaForNextWatermark = 1;
    private String watermarkColumn;
    private String watermarkFormat;

    public TimestampWatermark(String watermarkColumn, String watermarkFormat) {
        this.watermarkColumn = watermarkColumn;
        this.watermarkFormat = watermarkFormat;
        this.inputFormatParser = new SimpleDateFormat(INPUTFORMAT);
    }

    @Override
    public String getWatermarkCondition(QueryBasedExtractor<?, ?> extractor, long watermarkValue, String operator) {
        return extractor.getTimestampPredicateCondition(this.watermarkColumn, watermarkValue, this.watermarkFormat, operator);
    }

    @Override
    public int getDeltaNumForNextWatermark() {
        return 1;
    }

    @Override
    public synchronized HashMap<Long, Long> getIntervals(long lowWatermarkValue, long highWatermarkValue, long partitionInterval, int maxIntervals) {
        Preconditions.checkArgument((partitionInterval >= 1L ? 1 : 0) != 0, (Object)"Invalid value for partitionInterval, value should be at least 1.");
        Preconditions.checkArgument((maxIntervals > 0 ? 1 : 0) != 0, (Object)"Invalid value for maxIntervals, positive value expected.");
        HashMap<Long, Long> intervalMap = new HashMap<Long, Long>();
        if (lowWatermarkValue > highWatermarkValue) {
            LOG.warn("lowWatermarkValue: " + lowWatermarkValue + " is greater than highWatermarkValue: " + highWatermarkValue);
            return intervalMap;
        }
        Calendar calendar = Calendar.getInstance();
        long lowWatermark = TimestampWatermark.toEpoch(Long.toString(lowWatermarkValue));
        long highWatermark = TimestampWatermark.toEpoch(Long.toString(highWatermarkValue));
        long interval = TimestampWatermark.getInterval(highWatermark - lowWatermark, partitionInterval, maxIntervals);
        LOG.info("Recalculated partition interval:" + interval + " hours");
        if (interval == 0L) {
            return intervalMap;
        }
        Date startTime = new Date(lowWatermark);
        Date endTime = new Date(highWatermark);
        LOG.debug("Sart time:" + startTime + "; End time:" + endTime);
        while (startTime.getTime() < endTime.getTime()) {
            long lwm = Long.parseLong(this.inputFormatParser.format(startTime));
            calendar.setTime(startTime);
            calendar.add(10, (int)interval);
            Date nextTime = calendar.getTime();
            long hwm = Long.parseLong(this.inputFormatParser.format(nextTime.getTime() <= endTime.getTime() ? nextTime : endTime));
            intervalMap.put(lwm, hwm);
            LOG.debug("Partition - low:" + lwm + "; high:" + hwm);
            startTime = nextTime;
        }
        return intervalMap;
    }

    private static int getInterval(long diffInMilliSecs, long hourInterval, int maxIntervals) {
        long totalHours = DoubleMath.roundToInt((double)((double)diffInMilliSecs / 3600000.0), (RoundingMode)RoundingMode.CEILING);
        long totalIntervals = DoubleMath.roundToInt((double)((double)totalHours / (double)hourInterval), (RoundingMode)RoundingMode.CEILING);
        if (totalIntervals > (long)maxIntervals) {
            hourInterval = DoubleMath.roundToInt((double)((double)totalHours / (double)maxIntervals), (RoundingMode)RoundingMode.CEILING);
        }
        return Ints.checkedCast((long)hourInterval);
    }

    private static synchronized long toEpoch(String dateTime) {
        Date date = null;
        SimpleDateFormat inputFormat = new SimpleDateFormat(INPUTFORMAT);
        try {
            date = inputFormat.parse(dateTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return date.getTime();
    }

    public static long adjustWatermark(String baseWatermark, int diff) {
        SimpleDateFormat parser = new SimpleDateFormat(INPUTFORMAT);
        try {
            Date date = parser.parse(baseWatermark);
            return Long.parseLong(parser.format(Utils.addSecondsToDate(date, diff)));
        }
        catch (ParseException e) {
            LOG.error("Fail to adjust timestamp watermark", (Throwable)e);
            return -1L;
        }
    }
}

