/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util.degrader;

import com.linkedin.common.stats.LongStats;
import com.linkedin.util.degrader.CallCompletion;
import com.linkedin.util.degrader.ErrorType;
import java.util.Map;

public interface CallTracker {
    public CallStats getCallStats();

    public long getInterval();

    public void addStatsRolloverEventListener(StatsRolloverEventListener var1);

    public boolean removeStatsRolloverEventListener(StatsRolloverEventListener var1);

    public void reset();

    public long getTimeSinceLastCallStart();

    public long getLastResetTime();

    public long getCurrentCallCountTotal();

    public long getCurrentCallStartCountTotal();

    public long getCurrentErrorCountTotal();

    public Map<ErrorType, Integer> getCurrentErrorTypeCountsTotal();

    public int getCurrentConcurrency();

    public void trackCall(long var1);

    public void trackCallWithError(long var1);

    public CallCompletion startCall();

    public static interface StatsRolloverEvent {
        public CallStats getCallStats();

        public boolean isReset();
    }

    public static interface StatsRolloverEventListener {
        public void onStatsRollover(StatsRolloverEvent var1);
    }

    public static interface CallStats {
        public boolean stale(long var1);

        public Map<ErrorType, Integer> getErrorTypeCounts();

        public Map<ErrorType, Integer> getErrorTypeCountsTotal();

        public long getIntervalStartTime();

        public long getIntervalEndTime();

        public long getInterval();

        public int getCallCount();

        public long getCallCountTotal();

        public int getCallStartCount();

        public long getCallStartCountTotal();

        public double getCallsPerSecond();

        public int getErrorCount();

        public long getErrorCountTotal();

        public double getErrorRate();

        public int getConcurrentMax();

        public long getOutstandingStartTimeAvg();

        public int getOutstandingCount();

        public LongStats getCallTimeStats();
    }
}

