/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import javax.xml.bind.DatatypeConverter;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.filter.AvroSchemaFieldRemover;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistryFactory;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.apache.gobblin.util.AvroUtils;

@Deprecated
public class EnvelopeSchemaConverter
extends Converter<Schema, String, GenericRecord, GenericRecord> {
    public static final String PAYLOAD_SCHEMA_ID_FIELD = "EnvelopeSchemaConverter.schemaIdField";
    public static final String PAYLOAD_FIELD = "EnvelopeSchemaConverter.payloadField";
    public static final String DEFAULT_PAYLOAD_SCHEMA_ID_FIELD = "payloadSchemaId";
    public static final String DEFAULT_PAYLOAD_FIELD = "payload";
    public static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_FACTORY_CLASS = "org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistryFactory";
    private Optional<AvroSchemaFieldRemover> fieldRemover;
    private KafkaSchemaRegistry registry;
    private DecoderFactory decoderFactory;
    private LoadingCache<Schema, GenericDatumReader<GenericRecord>> readers;

    public EnvelopeSchemaConverter init(WorkUnitState workUnit) {
        if (workUnit.contains("extract.table.name")) {
            String removeFieldsPropName = workUnit.getProp("extract.table.name") + ".remove.fields";
            this.fieldRemover = workUnit.contains(removeFieldsPropName) ? Optional.of((Object)new AvroSchemaFieldRemover(workUnit.getProp(removeFieldsPropName))) : Optional.absent();
        }
        String registryFactoryField = workUnit.contains("kafka.schema.registry.factory.class") ? workUnit.getProp("kafka.schema.registry.factory.class") : DEFAULT_KAFKA_SCHEMA_REGISTRY_FACTORY_CLASS;
        try {
            KafkaSchemaRegistryFactory registryFactory = (KafkaSchemaRegistryFactory)Class.forName(registryFactoryField).newInstance();
            this.registry = registryFactory.create(workUnit.getProperties());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
        this.decoderFactory = DecoderFactory.get();
        this.readers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Schema, GenericDatumReader<GenericRecord>>(){

            public GenericDatumReader<GenericRecord> load(Schema key) throws Exception {
                return new GenericDatumReader(key);
            }
        });
        return this;
    }

    public String convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return EnvelopeSchemaConverter.class.getName();
    }

    public Iterable<GenericRecord> convertRecord(String outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            String schemaIdField = workUnit.contains(PAYLOAD_SCHEMA_ID_FIELD) ? workUnit.getProp(PAYLOAD_SCHEMA_ID_FIELD) : DEFAULT_PAYLOAD_SCHEMA_ID_FIELD;
            String payloadField = workUnit.contains(PAYLOAD_FIELD) ? workUnit.getProp(PAYLOAD_FIELD) : DEFAULT_PAYLOAD_FIELD;
            String schemaKey = String.valueOf(inputRecord.get(schemaIdField));
            Schema payloadSchema = (Schema)this.registry.getSchemaByKey(schemaKey);
            byte[] payload = this.getPayload(inputRecord, payloadField);
            GenericRecord outputRecord = this.deserializePayload(payload, payloadSchema);
            if (this.fieldRemover.isPresent()) {
                payloadSchema = ((AvroSchemaFieldRemover)this.fieldRemover.get()).removeFields(payloadSchema);
            }
            return new SingleRecordIterable((Object)AvroUtils.convertRecordSchema((GenericRecord)outputRecord, (Schema)payloadSchema));
        }
        catch (IOException | ExecutionException | SchemaRegistryException e) {
            throw new DataConversionException((Throwable)e);
        }
    }

    public byte[] getPayload(GenericRecord inputRecord, String payloadFieldName) {
        byte[] payloadBytes;
        ByteBuffer bb = (ByteBuffer)inputRecord.get(payloadFieldName);
        if (bb.hasArray()) {
            payloadBytes = bb.array();
        } else {
            payloadBytes = new byte[bb.remaining()];
            bb.get(payloadBytes);
        }
        String hexString = new String(payloadBytes, StandardCharsets.UTF_8);
        return DatatypeConverter.parseHexBinary((String)hexString);
    }

    public GenericRecord deserializePayload(byte[] payload, Schema payloadSchema) throws IOException, ExecutionException {
        BinaryDecoder decoder = this.decoderFactory.binaryDecoder(payload, null);
        GenericDatumReader reader = (GenericDatumReader)this.readers.get((Object)payloadSchema);
        return (GenericRecord)reader.read(null, (Decoder)decoder);
    }
}

