/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.ToAvroConverterBase;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistryFactory;
import org.apache.gobblin.kafka.schemareg.SchemaRegistryException;
import org.apache.gobblin.kafka.serialize.LiAvroDeserializerBase;
import org.apache.gobblin.kafka.serialize.SerializationException;
import org.apache.gobblin.util.EmptyIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiKafkaByteArrayMsgToAvroConverter<S>
extends ToAvroConverterBase<S, byte[]> {
    private static final Logger log = LoggerFactory.getLogger(LiKafkaByteArrayMsgToAvroConverter.class);
    KafkaSchemaRegistry schemaRegistry;
    LiAvroDeserializerBase deserializer;

    public Converter<S, Schema, byte[], GenericRecord> init(WorkUnitState workUnit) {
        this.schemaRegistry = KafkaSchemaRegistryFactory.getSchemaRegistry(workUnit.getProperties());
        this.deserializer = new LiAvroDeserializerBase(this.schemaRegistry);
        return this;
    }

    public Schema convertSchema(S schemaIn, WorkUnitState workUnit) throws SchemaConversionException {
        Preconditions.checkArgument((boolean)workUnit.contains("topic.name"), (Object)"Must specify topic name.");
        String topic = workUnit.getProp("topic.name");
        try {
            return (Schema)this.schemaRegistry.getLatestSchema(topic);
        }
        catch (IOException | SchemaRegistryException e) {
            throw new SchemaConversionException((Throwable)e);
        }
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, byte[] inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            String topic = workUnit.getProp("topic.name");
            GenericRecord record = this.deserializer.deserialize(topic, inputRecord, outputSchema);
            return new SingleRecordIterable((Object)record);
        }
        catch (SerializationException e) {
            log.error("Cannot decode one record.", (Throwable)e);
            return new EmptyIterable();
        }
    }
}

