/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter.util;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class KafkaAvroReporterUtil {
    private static final Splitter SPLIT_BY_COMMA = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final Splitter SPLIT_BY_COLON = Splitter.on((String)":").omitEmptyStrings().trimResults();

    public static Optional<Map<String, String>> extractOverrideNamespace(Properties properties) {
        if (properties.containsKey("kafka.schemaRegistry.overrideNamespace")) {
            HashMap namespaceOverridesMap = Maps.newHashMap();
            ArrayList namespaceOverrides = Lists.newArrayList((Iterable)SPLIT_BY_COMMA.split((CharSequence)properties.getProperty("kafka.schemaRegistry.overrideNamespace")));
            for (String namespaceOverride : namespaceOverrides) {
                ArrayList override = Lists.newArrayList((Iterable)SPLIT_BY_COLON.split((CharSequence)namespaceOverride));
                if (override.size() != 2) {
                    throw new RuntimeException("Namespace override should be of the format originalNamespace:replacementNamespace, found: " + namespaceOverride);
                }
                namespaceOverridesMap.put(override.get(0), override.get(1));
            }
            if (namespaceOverridesMap.size() != 0) {
                return Optional.of((Object)namespaceOverridesMap);
            }
        }
        return Optional.absent();
    }
}

