/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter.util;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistry;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;
import org.apache.gobblin.util.ConfigUtils;

public class SchemaRegistryVersionWriter
implements SchemaVersionWriter<Schema> {
    private final KafkaAvroSchemaRegistry registry;
    private Map<Schema, String> registrySchemaIds;
    private final Optional<String> overrideName;
    private final Optional<Schema> schema;
    private final Optional<String> schemaId;
    private final int schemaIdLengthBytes;

    public SchemaRegistryVersionWriter(Config config) throws IOException {
        this(new KafkaAvroSchemaRegistry(ConfigUtils.configToProperties((Config)config)), (Optional<String>)Optional.absent(), (Optional<Schema>)Optional.absent());
    }

    public SchemaRegistryVersionWriter(KafkaAvroSchemaRegistry registry, String overrideName) throws IOException {
        this(registry, overrideName, (Optional<Schema>)Optional.absent());
    }

    public SchemaRegistryVersionWriter(KafkaAvroSchemaRegistry registry, String overrideName, Optional<Schema> singleSchema) throws IOException {
        this(registry, (Optional<String>)Optional.of((Object)overrideName), singleSchema);
    }

    public SchemaRegistryVersionWriter(KafkaAvroSchemaRegistry registry, Optional<String> overrideName, Optional<Schema> singleSchema) throws IOException {
        this.registry = registry;
        this.registrySchemaIds = Maps.newConcurrentMap();
        this.overrideName = overrideName;
        this.schema = singleSchema;
        this.schemaIdLengthBytes = registry.getSchemaIdLengthByte();
        if (this.schema.isPresent()) {
            try {
                this.schemaId = this.overrideName.isPresent() ? Optional.of((Object)this.registry.register((Schema)this.schema.get(), (String)this.overrideName.get())) : Optional.of((Object)this.registry.register((Schema)this.schema.get()));
            }
            catch (SchemaRegistryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            this.schemaId = Optional.absent();
        }
    }

    public void writeSchemaVersioningInformation(Schema schema, DataOutputStream outputStream) throws IOException {
        String schemaId = this.schemaId.isPresent() ? (String)this.schemaId.get() : this.getIdForSchema(schema);
        outputStream.writeByte(0);
        try {
            outputStream.write(Hex.decodeHex((char[])schemaId.toCharArray()));
        }
        catch (DecoderException exception) {
            throw new IOException(exception);
        }
    }

    private String getIdForSchema(Schema schema) {
        if (!this.registrySchemaIds.containsKey(schema)) {
            try {
                String schemaId = this.overrideName.isPresent() ? this.registry.register(schema, (String)this.overrideName.get()) : this.registry.register(schema);
                this.registrySchemaIds.put(schema, schemaId);
            }
            catch (SchemaRegistryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return this.registrySchemaIds.get(schema);
    }

    public Schema readSchemaVersioningInformation(DataInputStream inputStream) throws IOException {
        if (inputStream.readByte() != 0) {
            throw new IOException("MAGIC_BYTE not found in Avro message.");
        }
        byte[] byteKey = new byte[this.schemaIdLengthBytes];
        int bytesRead = inputStream.read(byteKey, 0, this.schemaIdLengthBytes);
        if (bytesRead != this.schemaIdLengthBytes) {
            throw new IOException(String.format("Could not read enough bytes for schema id. Expected: %d, found: %d.", this.schemaIdLengthBytes, bytesRead));
        }
        String hexKey = Hex.encodeHexString((byte[])byteKey);
        try {
            return this.registry.getSchemaByKey(hexKey);
        }
        catch (SchemaRegistryException sre) {
            throw new IOException("Failed to retrieve schema for key " + hexKey, sre);
        }
    }
}

