/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.kafka.client.ByteArrayBasedKafkaRecord;
import org.apache.gobblin.kafka.client.DecodeableKafkaRecord;
import org.apache.gobblin.kafka.client.GobblinKafkaConsumerClient;
import org.apache.gobblin.kafka.client.KafkaConsumerRecord;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.extract.EventBasedExtractor;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaUtils;
import org.apache.gobblin.source.extractor.extract.kafka.MultiLongWatermark;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaExtractor<S, D>
extends EventBasedExtractor<S, D> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaExtractor.class);
    protected static final int INITIAL_PARTITION_IDX = -1;
    protected static final Integer MAX_LOG_DECODING_ERRORS = 5;
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String LOW_WATERMARK = "lowWatermark";
    public static final String ACTUAL_HIGH_WATERMARK = "actualHighWatermark";
    public static final String EXPECTED_HIGH_WATERMARK = "expectedHighWatermark";
    public static final String ELAPSED_TIME = "elapsedTime";
    public static final String PROCESSED_RECORD_COUNT = "processedRecordCount";
    public static final String AVG_RECORD_PULL_TIME = "avgRecordPullTime";
    public static final String READ_RECORD_TIME = "readRecordTime";
    public static final String DECODE_RECORD_TIME = "decodeRecordTime";
    public static final String FETCH_MESSAGE_BUFFER_TIME = "fetchMessageBufferTime";
    public static final String GOBBLIN_KAFKA_NAMESPACE = "gobblin.kafka";
    public static final String KAFKA_EXTRACTOR_TOPIC_METADATA_EVENT_NAME = "KafkaExtractorTopicMetadata";
    protected final WorkUnitState workUnitState;
    protected final String topicName;
    protected final List<KafkaPartition> partitions;
    protected final MultiLongWatermark lowWatermark;
    protected final MultiLongWatermark highWatermark;
    protected final MultiLongWatermark nextWatermark;
    protected final GobblinKafkaConsumerClient kafkaConsumerClient;
    private final ClassAliasResolver<GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory> kafkaConsumerClientResolver;
    protected final Stopwatch stopwatch;
    protected final Map<KafkaPartition, Integer> decodingErrorCount;
    private final Map<KafkaPartition, Double> avgMillisPerRecord;
    private final Map<KafkaPartition, Long> avgRecordSizes;
    private final Map<KafkaPartition, Long> elapsedTime;
    private final Map<KafkaPartition, Long> processedRecordCount;
    private final Map<KafkaPartition, Long> decodeRecordTime;
    private final Map<KafkaPartition, Long> fetchMessageBufferTime;
    private final Map<KafkaPartition, Long> readRecordTime;
    private final Set<Integer> errorPartitions;
    private int undecodableMessageCount = 0;
    private Iterator<KafkaConsumerRecord> messageIterator = null;
    private int currentPartitionIdx = -1;
    private long currentPartitionRecordCount = 0L;
    private long currentPartitionTotalSize = 0L;
    private long currentPartitionFetchDuration = 0L;
    private long currentPartitionDecodeRecordTime = 0L;
    private long currentPartitionFetchMessageBufferTime = 0L;
    private long currentPartitionReadRecordTime = 0L;

    public KafkaExtractor(WorkUnitState state) {
        super(state);
        this.workUnitState = state;
        this.topicName = KafkaUtils.getTopicName((State)state);
        this.partitions = KafkaUtils.getPartitions((State)state);
        this.lowWatermark = (MultiLongWatermark)state.getWorkunit().getLowWatermark(MultiLongWatermark.class);
        this.highWatermark = (MultiLongWatermark)state.getWorkunit().getExpectedHighWatermark(MultiLongWatermark.class);
        this.nextWatermark = new MultiLongWatermark(this.lowWatermark);
        this.kafkaConsumerClientResolver = new ClassAliasResolver(GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory.class);
        try {
            this.kafkaConsumerClient = (GobblinKafkaConsumerClient)this.closer.register((Closeable)((GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory)this.kafkaConsumerClientResolver.resolveClass(state.getProp("gobblin.kafka.consumerClient.class", "org.apache.gobblin.kafka.client.Kafka08ConsumerClient$Factory")).newInstance()).create(ConfigUtils.propertiesToConfig((Properties)state.getProperties())));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.stopwatch = Stopwatch.createUnstarted();
        this.decodingErrorCount = Maps.newHashMap();
        this.avgMillisPerRecord = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        this.avgRecordSizes = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        this.elapsedTime = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        this.processedRecordCount = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        this.decodeRecordTime = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        this.fetchMessageBufferTime = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        this.readRecordTime = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        this.errorPartitions = Sets.newHashSet();
        this.workUnitState.setActualHighWatermark((Watermark)this.lowWatermark);
    }

    public List<Tag<?>> generateTags(State state) {
        List tags = super.generateTags(state);
        tags.add(new Tag("kafkaTopic", (Object)KafkaUtils.getTopicName(state)));
        return tags;
    }

    public D readRecordImpl(D reuse) throws DataRecordException, IOException {
        long readStartTime = System.nanoTime();
        while (!this.allPartitionsFinished()) {
            if (this.currentPartitionFinished()) {
                this.moveToNextPartition();
                continue;
            }
            if (this.messageIterator == null || !this.messageIterator.hasNext()) {
                try {
                    long fetchStartTime = System.nanoTime();
                    this.messageIterator = this.fetchNextMessageBuffer();
                    this.currentPartitionFetchMessageBufferTime += System.nanoTime() - fetchStartTime;
                }
                catch (Exception e) {
                    LOG.error(String.format("Failed to fetch next message buffer for partition %s. Will skip this partition.", this.getCurrentPartition()), (Throwable)e);
                    this.moveToNextPartition();
                    continue;
                }
                if (this.messageIterator == null || !this.messageIterator.hasNext()) {
                    this.moveToNextPartition();
                    continue;
                }
            }
            while (!this.currentPartitionFinished() && this.messageIterator.hasNext()) {
                KafkaConsumerRecord nextValidMessage = this.messageIterator.next();
                if (nextValidMessage.getOffset() < this.nextWatermark.get(this.currentPartitionIdx)) continue;
                this.nextWatermark.set(this.currentPartitionIdx, nextValidMessage.getNextOffset());
                try {
                    D record = null;
                    long decodeStartTime = System.nanoTime();
                    if (nextValidMessage instanceof ByteArrayBasedKafkaRecord) {
                        record = this.decodeRecord((ByteArrayBasedKafkaRecord)nextValidMessage);
                    } else if (nextValidMessage instanceof DecodeableKafkaRecord) {
                        if (((DecodeableKafkaRecord)nextValidMessage).getValue() == null) {
                            throw new DataRecordException("Could not decode Kafka record");
                        }
                        record = (D)this.convertRecord(((DecodeableKafkaRecord)nextValidMessage).getValue());
                    } else {
                        throw new IllegalStateException("Unsupported KafkaConsumerRecord type. The returned record can either be ByteArrayBasedKafkaRecord or DecodeableKafkaRecord");
                    }
                    this.currentPartitionDecodeRecordTime += System.nanoTime() - decodeStartTime;
                    ++this.currentPartitionRecordCount;
                    this.currentPartitionTotalSize += nextValidMessage.getValueSizeInBytes();
                    this.currentPartitionReadRecordTime += System.nanoTime() - readStartTime;
                    return record;
                }
                catch (Throwable t) {
                    this.errorPartitions.add(this.currentPartitionIdx);
                    ++this.undecodableMessageCount;
                    if (!this.shouldLogError()) continue;
                    LOG.error(String.format("A record from partition %s cannot be decoded.", this.getCurrentPartition()), t);
                    this.incrementErrorCount();
                }
            }
        }
        LOG.info("Finished pulling topic " + this.topicName);
        this.currentPartitionReadRecordTime += System.nanoTime() - readStartTime;
        return null;
    }

    private boolean allPartitionsFinished() {
        return this.currentPartitionIdx != -1 && this.currentPartitionIdx >= this.highWatermark.size();
    }

    private boolean currentPartitionFinished() {
        if (this.currentPartitionIdx == -1) {
            return true;
        }
        if (this.nextWatermark.get(this.currentPartitionIdx) >= this.highWatermark.get(this.currentPartitionIdx)) {
            LOG.info("Finished pulling partition " + this.getCurrentPartition());
            return true;
        }
        return false;
    }

    private void moveToNextPartition() {
        if (this.currentPartitionIdx == -1) {
            LOG.info("Pulling topic " + this.topicName);
            this.currentPartitionIdx = 0;
        } else {
            this.updateStatisticsForCurrentPartition();
            ++this.currentPartitionIdx;
            this.currentPartitionRecordCount = 0L;
            this.currentPartitionFetchDuration = 0L;
            this.currentPartitionDecodeRecordTime = 0L;
            this.currentPartitionFetchMessageBufferTime = 0L;
            this.currentPartitionReadRecordTime = 0L;
        }
        this.messageIterator = null;
        if (this.currentPartitionIdx < this.partitions.size()) {
            LOG.info(String.format("Pulling partition %s from offset %d to %d, range=%d", this.getCurrentPartition(), this.nextWatermark.get(this.currentPartitionIdx), this.highWatermark.get(this.currentPartitionIdx), this.highWatermark.get(this.currentPartitionIdx) - this.nextWatermark.get(this.currentPartitionIdx)));
            this.switchMetricContextToCurrentPartition();
        }
        this.stopwatch.start();
    }

    private void updateStatisticsForCurrentPartition() {
        this.stopwatch.stop();
        if (this.currentPartitionRecordCount != 0L) {
            this.currentPartitionFetchDuration = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            double avgMillisForCurrentPartition = (double)this.currentPartitionFetchDuration / (double)this.currentPartitionRecordCount;
            this.avgMillisPerRecord.put(this.getCurrentPartition(), avgMillisForCurrentPartition);
            long avgRecordSize = this.currentPartitionTotalSize / this.currentPartitionRecordCount;
            this.avgRecordSizes.put(this.getCurrentPartition(), avgRecordSize);
            this.elapsedTime.put(this.getCurrentPartition(), this.currentPartitionFetchDuration);
            this.processedRecordCount.put(this.getCurrentPartition(), this.currentPartitionRecordCount);
            this.decodeRecordTime.put(this.getCurrentPartition(), this.currentPartitionDecodeRecordTime);
            this.fetchMessageBufferTime.put(this.getCurrentPartition(), this.currentPartitionFetchMessageBufferTime);
            this.readRecordTime.put(this.getCurrentPartition(), this.currentPartitionReadRecordTime);
        }
        this.stopwatch.reset();
    }

    private void switchMetricContextToCurrentPartition() {
        if (this.currentPartitionIdx >= this.partitions.size()) {
            return;
        }
        int currentPartitionId = this.getCurrentPartition().getId();
        this.switchMetricContext(Lists.newArrayList((Object[])new Tag[]{new Tag("kafka_partition", (Object)currentPartitionId)}));
    }

    private Iterator<KafkaConsumerRecord> fetchNextMessageBuffer() {
        return this.kafkaConsumerClient.consume(this.partitions.get(this.currentPartitionIdx), this.nextWatermark.get(this.currentPartitionIdx), this.highWatermark.get(this.currentPartitionIdx));
    }

    private boolean shouldLogError() {
        return !this.decodingErrorCount.containsKey(this.getCurrentPartition()) || this.decodingErrorCount.get(this.getCurrentPartition()) <= MAX_LOG_DECODING_ERRORS;
    }

    private void incrementErrorCount() {
        if (this.decodingErrorCount.containsKey(this.getCurrentPartition())) {
            this.decodingErrorCount.put(this.getCurrentPartition(), this.decodingErrorCount.get(this.getCurrentPartition()) + 1);
        } else {
            this.decodingErrorCount.put(this.getCurrentPartition(), 1);
        }
    }

    protected KafkaPartition getCurrentPartition() {
        Preconditions.checkElementIndex((int)this.currentPartitionIdx, (int)this.partitions.size(), (String)"KafkaExtractor has finished extracting all partitions. There's no current partition.");
        return this.partitions.get(this.currentPartitionIdx);
    }

    protected abstract D decodeRecord(ByteArrayBasedKafkaRecord var1) throws IOException;

    protected D convertRecord(D record) throws IOException {
        return record;
    }

    public long getExpectedRecordCount() {
        return this.lowWatermark.getGap(this.highWatermark);
    }

    public void close() throws IOException {
        this.updateStatisticsForCurrentPartition();
        HashMap tagsForPartitionsMap = Maps.newHashMap();
        this.workUnitState.setProp("error.partition.count", (Object)this.errorPartitions.size());
        this.workUnitState.setProp("error.message.undecodable.count", (Object)this.undecodableMessageCount);
        for (int i = 0; i < this.partitions.size(); ++i) {
            LOG.info(String.format("Actual high watermark for partition %s=%d, expected=%d", this.partitions.get(i), this.nextWatermark.get(i), this.highWatermark.get(i)));
            HashMap hashMap = Maps.newHashMap();
            KafkaPartition partition = this.partitions.get(i);
            hashMap.put(TOPIC, partition.getTopicName());
            hashMap.put(PARTITION, Integer.toString(partition.getId()));
            hashMap.put(LOW_WATERMARK, Long.toString(this.lowWatermark.get(i)));
            hashMap.put(ACTUAL_HIGH_WATERMARK, Long.toString(this.nextWatermark.get(i)));
            hashMap.put(EXPECTED_HIGH_WATERMARK, Long.toString(this.highWatermark.get(i)));
            hashMap.put("previousOffsetFetchEpochTime", this.workUnitState.getProp(KafkaUtils.getPartitionPropName("previousOffsetFetchEpochTime", i)));
            hashMap.put("offsetFetchEpochTime", this.workUnitState.getProp(KafkaUtils.getPartitionPropName("offsetFetchEpochTime", i)));
            hashMap.put("previousLatestOffset", this.workUnitState.getProp(KafkaUtils.getPartitionPropName("previousLatestOffset", i)));
            if (this.processedRecordCount.containsKey(partition)) {
                hashMap.put(PROCESSED_RECORD_COUNT, Long.toString(this.processedRecordCount.get(partition)));
                hashMap.put(ELAPSED_TIME, Long.toString(this.elapsedTime.get(partition)));
                hashMap.put(DECODE_RECORD_TIME, Long.toString(TimeUnit.NANOSECONDS.toMillis(this.decodeRecordTime.get(partition))));
                hashMap.put(FETCH_MESSAGE_BUFFER_TIME, Long.toString(TimeUnit.NANOSECONDS.toMillis(this.fetchMessageBufferTime.get(partition))));
                hashMap.put(READ_RECORD_TIME, Long.toString(TimeUnit.NANOSECONDS.toMillis(this.readRecordTime.get(partition))));
            } else {
                hashMap.put(PROCESSED_RECORD_COUNT, "0");
                hashMap.put(ELAPSED_TIME, "0");
                hashMap.put(DECODE_RECORD_TIME, "0");
                hashMap.put(FETCH_MESSAGE_BUFFER_TIME, "0");
                hashMap.put(READ_RECORD_TIME, "0");
            }
            tagsForPartitionsMap.put(partition, hashMap);
        }
        this.workUnitState.setActualHighWatermark((Watermark)this.nextWatermark);
        for (KafkaPartition kafkaPartition : this.partitions) {
            if (this.avgMillisPerRecord.containsKey(kafkaPartition)) {
                double avgMillis = this.avgMillisPerRecord.get(kafkaPartition);
                LOG.info(String.format("Avg time to pull a record for partition %s = %f milliseconds", kafkaPartition, avgMillis));
                KafkaUtils.setPartitionAvgRecordMillis((State)this.workUnitState, kafkaPartition, avgMillis);
                ((Map)tagsForPartitionsMap.get(kafkaPartition)).put(AVG_RECORD_PULL_TIME, Double.toString(avgMillis));
                continue;
            }
            LOG.info(String.format("Avg time to pull a record for partition %s not recorded", kafkaPartition));
            ((Map)tagsForPartitionsMap.get(kafkaPartition)).put(AVG_RECORD_PULL_TIME, Double.toString(-1.0));
        }
        if (this.isInstrumentationEnabled()) {
            for (Map.Entry entry : tagsForPartitionsMap.entrySet()) {
                new EventSubmitter.Builder(this.getMetricContext(), GOBBLIN_KAFKA_NAMESPACE).build().submit(KAFKA_EXTRACTOR_TOPIC_METADATA_EVENT_NAME, (Map)entry.getValue());
            }
        }
        this.closer.close();
    }

    @Deprecated
    public long getHighWatermark() {
        return 0L;
    }
}

