/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka.workunit.packer;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.WatermarkInterval;
import org.apache.gobblin.source.extractor.extract.AbstractSource;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaUtils;
import org.apache.gobblin.source.extractor.extract.kafka.MultiLongWatermark;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaAvgRecordSizeBasedWorkUnitSizeEstimator;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaAvgRecordTimeBasedWorkUnitSizeEstimator;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaBiLevelWorkUnitPacker;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaSingleLevelWorkUnitPacker;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaWorkUnitSizeEstimator;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaWorkUnitPacker {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaWorkUnitPacker.class);
    public static final String KAFKA_WORKUNIT_PACKER_TYPE = "kafka.workunit.packer.type";
    private static final PackerType DEFAULT_PACKER_TYPE = PackerType.SINGLE_LEVEL;
    public static final String KAFKA_WORKUNIT_SIZE_ESTIMATOR_TYPE = "kafka.workunit.size.estimator.type";
    private static final SizeEstimatorType DEFAULT_SIZE_ESTIMATOR_TYPE = SizeEstimatorType.AVG_RECORD_TIME;
    protected static final double EPS = 0.01;
    public static final String MIN_MULTIWORKUNIT_LOAD = "min.multiworkunit.load";
    public static final String MAX_MULTIWORKUNIT_LOAD = "max.multiworkunit.load";
    private static final String ESTIMATED_WORKUNIT_SIZE = "estimated.workunit.size";
    protected final AbstractSource<?, ?> source;
    protected final SourceState state;
    protected final KafkaWorkUnitSizeEstimator sizeEstimator;
    protected static final Comparator<WorkUnit> LOAD_ASC_COMPARATOR = new Comparator<WorkUnit>(){

        @Override
        public int compare(WorkUnit w1, WorkUnit w2) {
            return Doubles.compare((double)KafkaWorkUnitPacker.getWorkUnitEstLoad(w1), (double)KafkaWorkUnitPacker.getWorkUnitEstLoad(w2));
        }
    };
    protected static final Comparator<WorkUnit> LOAD_DESC_COMPARATOR = new Comparator<WorkUnit>(){

        @Override
        public int compare(WorkUnit w1, WorkUnit w2) {
            return Doubles.compare((double)KafkaWorkUnitPacker.getWorkUnitEstLoad(w2), (double)KafkaWorkUnitPacker.getWorkUnitEstLoad(w1));
        }
    };

    protected KafkaWorkUnitPacker(AbstractSource<?, ?> source, SourceState state) {
        this.source = source;
        this.state = state;
        this.sizeEstimator = this.getWorkUnitSizeEstimator();
    }

    protected double setWorkUnitEstSizes(Map<String, List<WorkUnit>> workUnitsByTopic) {
        double totalEstDataSize = 0.0;
        for (List<WorkUnit> workUnitsForTopic : workUnitsByTopic.values()) {
            for (WorkUnit workUnit : workUnitsForTopic) {
                this.setWorkUnitEstSize(workUnit);
                totalEstDataSize += KafkaWorkUnitPacker.getWorkUnitEstSize(workUnit);
            }
        }
        return totalEstDataSize;
    }

    private void setWorkUnitEstSize(WorkUnit workUnit) {
        workUnit.setProp(ESTIMATED_WORKUNIT_SIZE, (Object)this.sizeEstimator.calcEstimatedSize(workUnit));
    }

    private KafkaWorkUnitSizeEstimator getWorkUnitSizeEstimator() {
        if (this.state.contains(KAFKA_WORKUNIT_SIZE_ESTIMATOR_TYPE)) {
            String sizeEstimatorTypeString = this.state.getProp(KAFKA_WORKUNIT_SIZE_ESTIMATOR_TYPE);
            Optional sizeEstimatorType = Enums.getIfPresent(SizeEstimatorType.class, (String)sizeEstimatorTypeString);
            if (sizeEstimatorType.isPresent()) {
                return this.getWorkUnitSizeEstimator((SizeEstimatorType)((Object)sizeEstimatorType.get()));
            }
            throw new IllegalArgumentException("WorkUnit size estimator type " + sizeEstimatorType + " not found");
        }
        return this.getWorkUnitSizeEstimator(DEFAULT_SIZE_ESTIMATOR_TYPE);
    }

    private KafkaWorkUnitSizeEstimator getWorkUnitSizeEstimator(SizeEstimatorType sizeEstimatorType) {
        switch (sizeEstimatorType) {
            case AVG_RECORD_TIME: {
                return new KafkaAvgRecordTimeBasedWorkUnitSizeEstimator(this.state);
            }
            case AVG_RECORD_SIZE: {
                return new KafkaAvgRecordSizeBasedWorkUnitSizeEstimator(this.state);
            }
        }
        throw new IllegalArgumentException("WorkUnit size estimator type " + (Object)((Object)sizeEstimatorType) + " not found");
    }

    private static void setWorkUnitEstSize(WorkUnit workUnit, double estSize) {
        workUnit.setProp(ESTIMATED_WORKUNIT_SIZE, (Object)estSize);
    }

    protected static double getWorkUnitEstSize(WorkUnit workUnit) {
        Preconditions.checkArgument((boolean)workUnit.contains(ESTIMATED_WORKUNIT_SIZE));
        return workUnit.getPropAsDouble(ESTIMATED_WORKUNIT_SIZE);
    }

    protected static double getWorkUnitEstLoad(WorkUnit workUnit) {
        if (workUnit instanceof MultiWorkUnit) {
            MultiWorkUnit mwu = (MultiWorkUnit)workUnit;
            return Math.max(KafkaWorkUnitPacker.getWorkUnitEstSize(workUnit), 0.01) * Math.log10(Math.max(mwu.getWorkUnits().size(), 2));
        }
        return Math.max(KafkaWorkUnitPacker.getWorkUnitEstSize(workUnit), 0.01) * Math.log10(2.0);
    }

    protected static void addWorkUnitToMultiWorkUnit(WorkUnit workUnit, MultiWorkUnit multiWorkUnit) {
        multiWorkUnit.addWorkUnit(workUnit);
        double size = multiWorkUnit.getPropAsDouble(ESTIMATED_WORKUNIT_SIZE, 0.0);
        multiWorkUnit.setProp(ESTIMATED_WORKUNIT_SIZE, (Object)(size + KafkaWorkUnitPacker.getWorkUnitEstSize(workUnit)));
    }

    protected static void addWorkUnitsToMultiWorkUnit(List<WorkUnit> workUnits, MultiWorkUnit multiWorkUnit) {
        for (WorkUnit workUnit : workUnits) {
            KafkaWorkUnitPacker.addWorkUnitToMultiWorkUnit(workUnit, multiWorkUnit);
        }
    }

    protected static WatermarkInterval getWatermarkIntervalFromWorkUnit(WorkUnit workUnit) {
        if (workUnit instanceof MultiWorkUnit) {
            return KafkaWorkUnitPacker.getWatermarkIntervalFromMultiWorkUnit((MultiWorkUnit)workUnit);
        }
        ArrayList lowWatermarkValues = Lists.newArrayList((Object[])new Long[]{workUnit.getLowWaterMark()});
        ArrayList expectedHighWatermarkValues = Lists.newArrayList((Object[])new Long[]{workUnit.getHighWaterMark()});
        return new WatermarkInterval((Watermark)new MultiLongWatermark(lowWatermarkValues), (Watermark)new MultiLongWatermark(expectedHighWatermarkValues));
    }

    protected static WatermarkInterval getWatermarkIntervalFromMultiWorkUnit(MultiWorkUnit multiWorkUnit) {
        ArrayList lowWatermarkValues = Lists.newArrayList();
        ArrayList expectedHighWatermarkValues = Lists.newArrayList();
        for (WorkUnit workUnit : multiWorkUnit.getWorkUnits()) {
            lowWatermarkValues.add(workUnit.getLowWaterMark());
            expectedHighWatermarkValues.add(workUnit.getHighWaterMark());
        }
        return new WatermarkInterval((Watermark)new MultiLongWatermark(lowWatermarkValues), (Watermark)new MultiLongWatermark(expectedHighWatermarkValues));
    }

    protected List<WorkUnit> squeezeMultiWorkUnits(List<MultiWorkUnit> multiWorkUnits) {
        ArrayList workUnits = Lists.newArrayList();
        for (MultiWorkUnit multiWorkUnit : multiWorkUnits) {
            workUnits.add(this.squeezeMultiWorkUnit(multiWorkUnit));
        }
        return workUnits;
    }

    protected WorkUnit squeezeMultiWorkUnit(MultiWorkUnit multiWorkUnit) {
        WatermarkInterval interval = KafkaWorkUnitPacker.getWatermarkIntervalFromMultiWorkUnit(multiWorkUnit);
        List<KafkaPartition> partitions = KafkaWorkUnitPacker.getPartitionsFromMultiWorkUnit(multiWorkUnit);
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one partition in the multiWorkUnit");
        WorkUnit workUnit = (WorkUnit)multiWorkUnit.getWorkUnits().get(0);
        workUnit.removeProp("workunit.low.water.mark");
        workUnit.removeProp("workunit.high.water.mark");
        workUnit.setWatermarkInterval(interval);
        int index = 0;
        for (WorkUnit wu : multiWorkUnit.getWorkUnits()) {
            workUnit.setProp(KafkaUtils.getPartitionPropName("previousOffsetFetchEpochTime", index), (Object)wu.getProp("previousOffsetFetchEpochTime"));
            workUnit.setProp(KafkaUtils.getPartitionPropName("offsetFetchEpochTime", index), (Object)wu.getProp("offsetFetchEpochTime"));
            workUnit.setProp(KafkaUtils.getPartitionPropName("previousLatestOffset", index), (Object)wu.getProp("previousLatestOffset"));
            ++index;
        }
        workUnit.removeProp("previousOffsetFetchEpochTime");
        workUnit.removeProp("offsetFetchEpochTime");
        workUnit.removeProp("previousLatestOffset");
        workUnit.removeProp("partition.id");
        workUnit.removeProp("leader.id");
        workUnit.removeProp("leader.hostandport");
        KafkaWorkUnitPacker.populateMultiPartitionWorkUnit(partitions, workUnit);
        LOG.info(String.format("Created MultiWorkUnit for partitions %s", partitions));
        return workUnit;
    }

    private static void populateMultiPartitionWorkUnit(List<KafkaPartition> partitions, WorkUnit workUnit) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"There should be at least one partition");
        GobblinMetrics.addCustomTagToState((State)workUnit, (Tag)new Tag("kafkaTopic", (Object)partitions.get(0).getTopicName()));
        for (int i = 0; i < partitions.size(); ++i) {
            workUnit.setProp(KafkaUtils.getPartitionPropName("partition.id", i), (Object)partitions.get(i).getId());
            workUnit.setProp(KafkaUtils.getPartitionPropName("leader.id", i), (Object)partitions.get(i).getLeader().getId());
            workUnit.setProp(KafkaUtils.getPartitionPropName("leader.hostandport", i), (Object)partitions.get(i).getLeader().getHostAndPort());
        }
    }

    private static List<KafkaPartition> getPartitionsFromMultiWorkUnit(MultiWorkUnit multiWorkUnit) {
        ArrayList partitions = Lists.newArrayList();
        for (WorkUnit workUnit : multiWorkUnit.getWorkUnits()) {
            partitions.add(KafkaUtils.getPartition((State)workUnit));
        }
        return partitions;
    }

    protected List<WorkUnit> worstFitDecreasingBinPacking(List<WorkUnit> groups, int numOfMultiWorkUnits) {
        Collections.sort(groups, LOAD_DESC_COMPARATOR);
        MinMaxPriorityQueue pQueue = MinMaxPriorityQueue.orderedBy(LOAD_ASC_COMPARATOR).expectedSize(numOfMultiWorkUnits).create();
        for (int i = 0; i < numOfMultiWorkUnits; ++i) {
            MultiWorkUnit multiWorkUnit = MultiWorkUnit.createEmpty();
            KafkaWorkUnitPacker.setWorkUnitEstSize((WorkUnit)multiWorkUnit, 0.0);
            pQueue.add((Object)multiWorkUnit);
        }
        for (WorkUnit group : groups) {
            MultiWorkUnit lightestMultiWorkUnit = (MultiWorkUnit)pQueue.poll();
            KafkaWorkUnitPacker.addWorkUnitToMultiWorkUnit(group, lightestMultiWorkUnit);
            pQueue.add((Object)lightestMultiWorkUnit);
        }
        KafkaWorkUnitPacker.logMultiWorkUnitInfo((Iterable<MultiWorkUnit>)pQueue);
        double minLoad = KafkaWorkUnitPacker.getWorkUnitEstLoad((WorkUnit)pQueue.peekFirst());
        double maxLoad = KafkaWorkUnitPacker.getWorkUnitEstLoad((WorkUnit)pQueue.peekLast());
        LOG.info(String.format("Min load of multiWorkUnit = %f; Max load of multiWorkUnit = %f; Diff = %f%%", minLoad, maxLoad, (maxLoad - minLoad) / maxLoad * 100.0));
        this.state.setProp(MIN_MULTIWORKUNIT_LOAD, (Object)minLoad);
        this.state.setProp(MAX_MULTIWORKUNIT_LOAD, (Object)maxLoad);
        ArrayList multiWorkUnits = Lists.newArrayList();
        multiWorkUnits.addAll(pQueue);
        return multiWorkUnits;
    }

    private static void logMultiWorkUnitInfo(Iterable<MultiWorkUnit> mwus) {
        int idx = 0;
        for (MultiWorkUnit mwu : mwus) {
            LOG.info(String.format("MultiWorkUnit %d: estimated load=%f, partitions=%s", idx++, KafkaWorkUnitPacker.getWorkUnitEstLoad((WorkUnit)mwu), KafkaWorkUnitPacker.getMultiWorkUnitPartitions(mwu)));
        }
    }

    protected static List<List<KafkaPartition>> getMultiWorkUnitPartitions(MultiWorkUnit mwu) {
        ArrayList partitions = Lists.newArrayList();
        for (WorkUnit workUnit : mwu.getWorkUnits()) {
            partitions.add(KafkaUtils.getPartitions((State)workUnit));
        }
        return partitions;
    }

    public static KafkaWorkUnitPacker getInstance(AbstractSource<?, ?> source, SourceState state) {
        if (state.contains(KAFKA_WORKUNIT_PACKER_TYPE)) {
            String packerTypeStr = state.getProp(KAFKA_WORKUNIT_PACKER_TYPE);
            Optional packerType = Enums.getIfPresent(PackerType.class, (String)packerTypeStr);
            if (packerType.isPresent()) {
                return KafkaWorkUnitPacker.getInstance((PackerType)((Object)packerType.get()), source, state);
            }
            throw new IllegalArgumentException("WorkUnit packer type " + packerTypeStr + " not found");
        }
        return KafkaWorkUnitPacker.getInstance(DEFAULT_PACKER_TYPE, source, state);
    }

    public static KafkaWorkUnitPacker getInstance(PackerType packerType, AbstractSource<?, ?> source, SourceState state) {
        switch (packerType) {
            case SINGLE_LEVEL: {
                return new KafkaSingleLevelWorkUnitPacker(source, state);
            }
            case BI_LEVEL: {
                return new KafkaBiLevelWorkUnitPacker(source, state);
            }
        }
        throw new IllegalArgumentException("WorkUnit packer type " + (Object)((Object)packerType) + " not found");
    }

    public abstract List<WorkUnit> pack(Map<String, List<WorkUnit>> var1, int var2);

    public static enum SizeEstimatorType {
        AVG_RECORD_TIME,
        AVG_RECORD_SIZE;

    }

    public static enum PackerType {
        SINGLE_LEVEL,
        BI_LEVEL;

    }
}

