/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.cli;

import com.google.common.collect.Sets;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.apache.gobblin.util.ClassAliasResolver;

public class GobblinCli {
    public static void main(String[] args) {
        ClassAliasResolver resolver = new ClassAliasResolver(CliApplication.class);
        if (args.length < 1 || Sets.newHashSet((Object[])new String[]{"-h", "--help"}).contains(args[0])) {
            GobblinCli.printUsage((ClassAliasResolver<CliApplication>)resolver);
            return;
        }
        String alias = args[0];
        try {
            CliApplication application = (CliApplication)resolver.resolveClass(alias).newInstance();
            application.run(args);
        }
        catch (ReflectiveOperationException roe) {
            System.err.println("Could not find an application with alias " + alias);
            GobblinCli.printUsage((ClassAliasResolver<CliApplication>)resolver);
        }
        catch (Throwable t) {
            System.out.println("Error: " + t.getMessage());
            t.printStackTrace();
        }
    }

    private static void printUsage(ClassAliasResolver<CliApplication> resolver) {
        System.out.println("Usage: gobblin <command>");
        System.out.println("Available commands:");
        for (Alias alias : resolver.getAliasObjects()) {
            System.out.println("\t" + alias.value() + "\t" + alias.description());
        }
    }
}

