/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class AutoReturnableObject<T>
implements Closeable {
    private final T object;
    private final GenericObjectPool<T> pool;
    private boolean returned;

    public AutoReturnableObject(GenericObjectPool<T> pool) throws IOException {
        try {
            this.pool = pool;
            this.object = pool.borrowObject();
            this.returned = false;
        }
        catch (Exception exc) {
            throw new IOException(exc);
        }
    }

    public T get() throws IOException {
        if (this.returned) {
            throw new IOException(this.getClass().getCanonicalName() + " has already been closed.");
        }
        return this.object;
    }

    @Override
    public void close() throws IOException {
        try {
            this.pool.returnObject(this.object);
        }
        catch (Exception exc) {
            throw new IOException(exc);
        }
        finally {
            this.returned = true;
        }
    }
}

