/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class ExponentialBackoff {
    private final double alpha;
    private final long maxWait;
    private final int maxRetries;
    private final long maxDelay;
    private int retryNumber = 0;
    private long totalWait = 0L;
    private long nextDelay;

    private ExponentialBackoff(Double alpha, Integer maxRetries, Long maxWait, Long maxDelay, Long initialDelay) {
        this.alpha = alpha == null ? 2.0 : alpha;
        this.maxRetries = maxRetries == null ? Integer.MAX_VALUE : maxRetries;
        this.maxWait = maxWait == null ? Long.MAX_VALUE : maxWait;
        this.maxDelay = maxDelay == null ? Long.MAX_VALUE : maxDelay;
        this.nextDelay = initialDelay == null ? 20L : initialDelay;
    }

    public void awaitNextRetry() throws InterruptedException, NoMoreRetriesException {
        ++this.retryNumber;
        if (this.retryNumber > this.maxRetries) {
            throw new NoMoreRetriesException("Reached maximum number of retries: " + this.maxRetries);
        }
        if (this.totalWait > this.maxWait) {
            throw new NoMoreRetriesException("Reached maximum time to wait: " + this.maxWait);
        }
        Thread.sleep(this.nextDelay);
        this.totalWait += this.nextDelay;
        this.nextDelay = Math.min((long)(this.alpha * (double)this.nextDelay) + 1L, this.maxDelay);
    }

    public boolean awaitNextRetryIfAvailable() throws InterruptedException {
        try {
            this.awaitNextRetry();
            return true;
        }
        catch (NoMoreRetriesException exc) {
            return false;
        }
    }

    private static boolean evaluateConditionUntilTrue(Callable<Boolean> callable, Double alpha, Integer maxRetries, Long maxWait, Long maxDelay, Long initialDelay) throws ExecutionException, InterruptedException {
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(alpha, maxRetries, maxWait, maxDelay, initialDelay);
        do {
            try {
                if (callable.call().booleanValue()) {
                    return true;
                }
            }
            catch (Throwable t) {
                throw new ExecutionException(t);
            }
        } while (exponentialBackoff.awaitNextRetryIfAvailable());
        return false;
    }

    public static ExponentialBackoffBuilder builder() {
        return new ExponentialBackoffBuilder();
    }

    public static BooleanBuilder awaitCondition() {
        return new BooleanBuilder();
    }

    public static class BooleanBuilder {
        private Callable<Boolean> callable;
        private Double alpha;
        private Integer maxRetries;
        private Long maxWait;
        private Long maxDelay;
        private Long initialDelay;

        BooleanBuilder() {
        }

        public BooleanBuilder callable(Callable<Boolean> callable) {
            this.callable = callable;
            return this;
        }

        public BooleanBuilder alpha(Double alpha) {
            this.alpha = alpha;
            return this;
        }

        public BooleanBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public BooleanBuilder maxWait(Long maxWait) {
            this.maxWait = maxWait;
            return this;
        }

        public BooleanBuilder maxDelay(Long maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public BooleanBuilder initialDelay(Long initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public boolean await() throws ExecutionException, InterruptedException {
            return ExponentialBackoff.evaluateConditionUntilTrue(this.callable, this.alpha, this.maxRetries, this.maxWait, this.maxDelay, this.initialDelay);
        }

        public String toString() {
            return "ExponentialBackoff.BooleanBuilder(callable=" + this.callable + ", alpha=" + this.alpha + ", maxRetries=" + this.maxRetries + ", maxWait=" + this.maxWait + ", maxDelay=" + this.maxDelay + ", initialDelay=" + this.initialDelay + ")";
        }
    }

    public static class ExponentialBackoffBuilder {
        private Double alpha;
        private Integer maxRetries;
        private Long maxWait;
        private Long maxDelay;
        private Long initialDelay;

        ExponentialBackoffBuilder() {
        }

        public ExponentialBackoffBuilder alpha(Double alpha) {
            this.alpha = alpha;
            return this;
        }

        public ExponentialBackoffBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ExponentialBackoffBuilder maxWait(Long maxWait) {
            this.maxWait = maxWait;
            return this;
        }

        public ExponentialBackoffBuilder maxDelay(Long maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public ExponentialBackoffBuilder initialDelay(Long initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public ExponentialBackoff build() {
            return new ExponentialBackoff(this.alpha, this.maxRetries, this.maxWait, this.maxDelay, this.initialDelay);
        }

        public String toString() {
            return "ExponentialBackoff.ExponentialBackoffBuilder(alpha=" + this.alpha + ", maxRetries=" + this.maxRetries + ", maxWait=" + this.maxWait + ", maxDelay=" + this.maxDelay + ", initialDelay=" + this.initialDelay + ")";
        }
    }

    public static class NoMoreRetriesException
    extends Exception {
        public NoMoreRetriesException(String message) {
            super(message);
        }
    }
}

