/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import lombok.NonNull;
import org.apache.gobblin.configuration.State;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedFileSystemUtils {
    private static final Logger log = LoggerFactory.getLogger(ProxiedFileSystemUtils.class);
    public static final String AUTH_TYPE_KEY = "gobblin.utility.user.proxy.auth.type";
    public static final String AUTH_TOKEN_PATH = "gobblin.utility.proxy.auth.token.path";

    static FileSystem createProxiedFileSystem(@NonNull String userNameToProxyAs, Properties properties, URI fsURI, Configuration conf) throws IOException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs");
        }
        Preconditions.checkArgument((boolean)properties.containsKey(AUTH_TYPE_KEY));
        switch (AuthType.valueOf(properties.getProperty(AUTH_TYPE_KEY))) {
            case TOKEN: {
                Preconditions.checkArgument((boolean)properties.containsKey(AUTH_TOKEN_PATH));
                Path tokenPath = new Path(properties.getProperty(AUTH_TOKEN_PATH));
                Optional<Token<?>> proxyToken = ProxiedFileSystemUtils.getTokenFromSeqFile(userNameToProxyAs, tokenPath);
                if (proxyToken.isPresent()) {
                    try {
                        return ProxiedFileSystemUtils.createProxiedFileSystemUsingToken(userNameToProxyAs, (Token)proxyToken.get(), fsURI, conf);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Failed to proxy as user " + userNameToProxyAs, e);
                    }
                }
                throw new IOException("No delegation token found for proxy user " + userNameToProxyAs);
            }
            case KEYTAB: {
                Preconditions.checkArgument((properties.containsKey("super.user.name.to.proxy.as.others") && properties.containsKey("super.user.key.tab.location") ? 1 : 0) != 0);
                String superUserName = properties.getProperty("super.user.name.to.proxy.as.others");
                Path keytabPath = new Path(properties.getProperty("super.user.key.tab.location"));
                try {
                    return ProxiedFileSystemUtils.createProxiedFileSystemUsingKeytab(userNameToProxyAs, superUserName, keytabPath, fsURI, conf);
                }
                catch (InterruptedException e) {
                    throw new IOException("Failed to proxy as user " + userNameToProxyAs, e);
                }
            }
        }
        throw new IOException("User proxy auth type " + properties.getProperty(AUTH_TYPE_KEY) + " not recognized.");
    }

    static FileSystem createProxiedFileSystemUsingKeytab(String userNameToProxyAs, String superUserName, Path superUserKeytabLocation, URI fsURI, Configuration conf) throws IOException, InterruptedException {
        return (FileSystem)ProxiedFileSystemUtils.loginAndProxyAsUser(userNameToProxyAs, superUserName, superUserKeytabLocation).doAs((PrivilegedExceptionAction)new ProxiedFileSystem(fsURI, conf));
    }

    static FileSystem createProxiedFileSystemUsingKeytab(State state, URI fsURI, Configuration conf) throws IOException, InterruptedException {
        Preconditions.checkArgument((boolean)state.contains("fs.proxy.as.user.name"));
        Preconditions.checkArgument((boolean)state.contains("super.user.name.to.proxy.as.others"));
        Preconditions.checkArgument((boolean)state.contains("super.user.key.tab.location"));
        return ProxiedFileSystemUtils.createProxiedFileSystemUsingKeytab(state.getProp("fs.proxy.as.user.name"), state.getProp("super.user.name.to.proxy.as.others"), new Path(state.getProp("super.user.key.tab.location")), fsURI, conf);
    }

    static FileSystem createProxiedFileSystemUsingToken(@NonNull String userNameToProxyAs, @NonNull Token<?> userNameToken, URI fsURI, Configuration conf) throws IOException, InterruptedException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs");
        }
        if (userNameToken == null) {
            throw new NullPointerException("userNameToken");
        }
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)userNameToProxyAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
        ugi.addToken(userNameToken);
        return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new ProxiedFileSystem(fsURI, conf));
    }

    public static boolean canProxyAs(String userNameToProxyAs, String superUserName, Path superUserKeytabLocation) {
        try {
            ProxiedFileSystemUtils.loginAndProxyAsUser(userNameToProxyAs, superUserName, superUserKeytabLocation);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static Optional<Token<?>> getTokenFromSeqFile(String userNameKey, Path tokenFilePath) throws IOException {
        log.info("Reading tokens from sequence file " + tokenFilePath);
        try (Closer closer = Closer.create();){
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
            SequenceFile.Reader tokenReader = (SequenceFile.Reader)closer.register((Closeable)new SequenceFile.Reader((FileSystem)localFs, tokenFilePath, localFs.getConf()));
            Text key = new Text();
            Token value = new Token();
            while (tokenReader.next((Writable)key, (Writable)value)) {
                log.debug("Found token for user: " + key);
                if (!key.toString().equals(userNameKey)) continue;
                Optional optional = Optional.of((Object)value);
                return optional;
            }
        }
        log.warn("Did not find any tokens for user " + userNameKey);
        return Optional.absent();
    }

    private static UserGroupInformation loginAndProxyAsUser(@NonNull String userNameToProxyAs, @NonNull String superUserName, Path superUserKeytabLocation) throws IOException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs");
        }
        if (superUserName == null) {
            throw new NullPointerException("superUserName");
        }
        if (!UserGroupInformation.getLoginUser().getUserName().equals(superUserName)) {
            Preconditions.checkNotNull((Object)superUserKeytabLocation);
            UserGroupInformation.loginUserFromKeytab((String)superUserName, (String)superUserKeytabLocation.toString());
        }
        return UserGroupInformation.createProxyUser((String)userNameToProxyAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
    }

    private static class ProxiedFileSystem
    implements PrivilegedExceptionAction<FileSystem> {
        @NonNull
        private URI fsURI;
        @NonNull
        private Configuration conf;

        @Override
        public FileSystem run() throws IOException {
            log.info("Creating a filesystem for user: " + UserGroupInformation.getCurrentUser());
            return FileSystem.get((URI)this.fsURI, (Configuration)this.conf);
        }

        @ConstructorProperties(value={"fsURI", "conf"})
        public ProxiedFileSystem(@NonNull URI fsURI, @NonNull Configuration conf) {
            if (fsURI == null) {
                throw new NullPointerException("fsURI");
            }
            if (conf == null) {
                throw new NullPointerException("conf");
            }
            this.fsURI = fsURI;
            this.conf = conf;
        }
    }

    public static enum AuthType {
        TOKEN,
        KEYTAB;

    }
}

