/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParsingUtils {
    public static final Pattern HUMAN_READABLE_SIZE_PATTERN = Pattern.compile("([0-9\\.]+)\\s*([kKmMgGtTpP]?)[bB]?");

    public static long humanReadableToByteCount(String string) throws FormatException {
        Matcher matcher = HUMAN_READABLE_SIZE_PATTERN.matcher(string.trim());
        if (!matcher.matches()) {
            throw new FormatException("Could not parse human readable size string " + string);
        }
        int exponent = 0;
        switch (matcher.group(2).toUpperCase()) {
            case "": {
                exponent = 0;
                break;
            }
            case "K": {
                exponent = 10;
                break;
            }
            case "M": {
                exponent = 20;
                break;
            }
            case "G": {
                exponent = 30;
                break;
            }
            case "T": {
                exponent = 40;
                break;
            }
            case "P": {
                exponent = 50;
                break;
            }
            default: {
                throw new FormatException("Could not parse human readable size string " + string);
            }
        }
        try {
            double base = Double.parseDouble(matcher.group(1));
            return (long)(base * (double)(1L << exponent));
        }
        catch (NumberFormatException nfe) {
            throw new FormatException("Could not parse human readable size string " + string);
        }
    }

    public static class FormatException
    extends Exception {
        public FormatException(String message) {
            super(message);
        }

        public FormatException(String message, Throwable cause) {
            super(message, cause);
        }

        public FormatException(Throwable cause) {
            super(cause);
        }
    }
}

