/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedList;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.CreateIdStatus;
import com.linkedin.restli.common.CreateStatus;
import com.linkedin.restli.internal.common.CreateIdStatusDecoder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatchCreateIdResponse<K>
extends RecordTemplate {
    private final List<CreateIdStatus<K>> _collection;

    public BatchCreateIdResponse(DataMap map, CreateIdStatusDecoder<K> entityDecoder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        super(map, BatchCreateIdResponse.generateSchema());
        this._collection = this.createCollectionFromDecoder(entityDecoder);
    }

    public BatchCreateIdResponse(List<CreateIdStatus<K>> elements) {
        super(BatchCreateIdResponse.generateDataMap(elements), BatchCreateIdResponse.generateSchema());
        this._collection = elements;
    }

    private static DataMap generateDataMap(List<? extends RecordTemplate> elements) {
        DataMap dataMap = new DataMap();
        DataList listElements = new DataList();
        for (RecordTemplate recordTemplate : elements) {
            CheckedUtil.addWithoutChecking((CheckedList)listElements, (Object)recordTemplate.data());
        }
        dataMap.put((Object)"elements", (Object)listElements);
        return dataMap;
    }

    private static RecordDataSchema generateSchema() {
        StringBuilder errorMessageBuilder = new StringBuilder(10);
        ArrayDataSchema arraySchema = new ArrayDataSchema((DataSchema)new RecordDataSchema(new Name(CreateStatus.class.getSimpleName()), RecordDataSchema.RecordType.RECORD));
        RecordDataSchema.Field arrayField = new RecordDataSchema.Field((DataSchema)arraySchema);
        arrayField.setName("elements", errorMessageBuilder);
        RecordDataSchema schema = new RecordDataSchema(new Name(BatchCreateIdResponse.class.getSimpleName()), RecordDataSchema.RecordType.RECORD);
        schema.setFields(Arrays.asList(arrayField), errorMessageBuilder);
        return schema;
    }

    private CreateIdStatus<K> decodeValue(DataMap dataMap, CreateIdStatusDecoder<K> decoder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return decoder.makeValue(dataMap);
    }

    private List<CreateIdStatus<K>> createCollectionFromDecoder(CreateIdStatusDecoder<K> decoder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        DataList elements = this.data().getDataList("elements");
        ArrayList<CreateIdStatus<K>> collection = new ArrayList<CreateIdStatus<K>>(elements.size());
        for (Object obj : elements) {
            DataMap dataMap = (DataMap)obj;
            collection.add(this.decodeValue(dataMap, decoder));
        }
        return collection;
    }

    public List<CreateIdStatus<K>> getElements() {
        return this._collection;
    }
}

