/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.jersey.core.util.MultivaluedMap;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.QueryParamsDataMap;
import com.linkedin.restli.internal.common.URIElementParser;
import com.linkedin.restli.internal.common.ValueConverter;
import com.linkedin.util.CustomTypeUtil;
import java.util.List;
import java.util.Map;

public class ResponseUtils {
    public static Object convertKey(String rawKey, TypeSpec<?> keyType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType, ProtocolVersion version) {
        ComplexResourceKey<?, ?> result;
        Class keyBindingClass = keyType.getType();
        if (TyperefInfo.class.isAssignableFrom(keyType.getType())) {
            TyperefDataSchema schema = (TyperefDataSchema)keyType.getSchema();
            if (!schema.getDereferencedDataSchema().isPrimitive()) {
                throw new IllegalArgumentException("Typeref must reference a primitive type when used as a key type.");
            }
            DataSchema.Type dereferencedType = schema.getDereferencedType();
            Class primitiveClass = DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)dereferencedType);
            result = ValueConverter.coerceString(rawKey, primitiveClass);
            keyBindingClass = CustomTypeUtil.getJavaCustomTypeClassFromSchema((DataSchema)schema);
            if (keyBindingClass == null) {
                keyBindingClass = primitiveClass;
            }
        } else if (CompoundKey.class.isAssignableFrom(keyType.getType())) {
            DataMap keyDataMap;
            if (version.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
                try {
                    keyDataMap = (DataMap)URIElementParser.parse(rawKey);
                }
                catch (PathSegment.PathSegmentSyntaxException e) {
                    throw new IllegalStateException(rawKey + " is not a valid value for the resource key", e);
                }
            } else {
                keyDataMap = ResponseUtils.parseKey(rawKey);
            }
            result = CompoundKey.fromValues(keyDataMap, keyParts);
        } else {
            if (ComplexResourceKey.class.isAssignableFrom(keyType.getType())) {
                try {
                    ComplexResourceKey<RecordTemplate, RecordTemplate> complexResourceKey = ComplexResourceKey.parseString(rawKey, complexKeyType, version);
                    result = QueryParamsDataMap.fixUpComplexKeySingletonArray(complexResourceKey);
                }
                catch (PathSegment.PathSegmentSyntaxException e) {
                    throw new IllegalStateException(rawKey + " is not a valid value for the resource key", e);
                }
            }
            try {
                result = ValueConverter.coerceString(rawKey, keyType.getType());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(rawKey + " is not a valid value for resource key type " + keyType.getType().getName(), e);
            }
        }
        return DataTemplateUtil.coerceOutput(result, keyBindingClass);
    }

    private static DataMap parseKey(String rawKey) {
        MultivaluedMap fields = UriComponent.decodeQuery((String)rawKey, (boolean)true);
        DataMap result = new DataMap((int)Math.ceil((float)fields.size() / 0.75f));
        for (Map.Entry entry : fields.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                result.put(entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            CheckedUtil.putWithoutChecking((CheckedMap)result, entry.getKey(), (Object)new DataList((List)entry.getValue()));
        }
        return result;
    }
}

