/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer;

import com.linkedin.d2.balancer.D2ClientConfig;
import com.linkedin.d2.balancer.LoadBalancerWithFacilities;
import com.linkedin.d2.balancer.LoadBalancerWithFacilitiesFactory;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyFactoryV3;
import com.linkedin.d2.balancer.strategies.random.RandomLoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.d2.balancer.zkfs.ZKFSComponentFactory;
import com.linkedin.d2.balancer.zkfs.ZKFSLoadBalancer;
import com.linkedin.d2.balancer.zkfs.ZKFSTogglingLoadBalancerFactoryImpl;
import com.linkedin.r2.util.NamedThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class ZKFSLoadBalancerWithFacilitiesFactory
implements LoadBalancerWithFacilitiesFactory {
    @Override
    public LoadBalancerWithFacilities create(D2ClientConfig config) {
        if (config._executorService == null) {
            config._executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("D2 PropertyEventExecutor"));
        }
        return new ZKFSLoadBalancer(config.zkHosts, (int)config.zkSessionTimeoutInMs, (int)config.zkStartupTimeoutInMs, this.createLoadBalancerFactory(config), config.flagFile, config.basePath, config.shutdownAsynchronously, config.isSymlinkAware, config._executorService);
    }

    private ZKFSLoadBalancer.TogglingLoadBalancerFactory createLoadBalancerFactory(D2ClientConfig config) {
        ZKFSTogglingLoadBalancerFactoryImpl.ComponentFactory loadBalancerComponentFactory = config.componentFactory == null ? new ZKFSComponentFactory() : config.componentFactory;
        Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories = this.createDefaultLoadBalancerStrategyFactories(config._healthCheckOperations, config._executorService);
        return new ZKFSTogglingLoadBalancerFactoryImpl(loadBalancerComponentFactory, config.lbWaitTimeout, config.lbWaitUnit, config.basePath, config.fsBasePath, config.clientFactories, loadBalancerStrategyFactories, config.d2ServicePath, config.sslContext, config.sslParameters, config.isSSLEnabled, config.clientServicesConfig, config.useNewEphemeralStoreWatcher);
    }

    private Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> createDefaultLoadBalancerStrategyFactories(HealthCheckOperations healthCheckOperations, ScheduledExecutorService executorService) {
        HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories = new HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>>();
        RandomLoadBalancerStrategyFactory randomStrategyFactory = new RandomLoadBalancerStrategyFactory();
        DegraderLoadBalancerStrategyFactoryV3 degraderStrategyFactoryV3 = new DegraderLoadBalancerStrategyFactoryV3(healthCheckOperations, executorService);
        loadBalancerStrategyFactories.put("random", randomStrategyFactory);
        loadBalancerStrategyFactories.put("degrader", degraderStrategyFactoryV3);
        loadBalancerStrategyFactories.put("degraderV2", degraderStrategyFactoryV3);
        loadBalancerStrategyFactories.put("degraderV3", degraderStrategyFactoryV3);
        loadBalancerStrategyFactories.put("degraderV2_1", degraderStrategyFactoryV3);
        return loadBalancerStrategyFactories;
    }
}

